const Main = imports.ui.main;
const MainLoop = imports.mainloop;
const Lang = imports.lang;
const St = imports.gi.St;
const Clutter = imports.gi.Clutter;
const PanelMenu = imports.ui.panelMenu;
const Gio = imports.gi.Gio;
const PopupMenu = imports.ui.popupMenu;
const Gettext = imports.gettext;

const _ = Gettext.gettext;

const ApiIface = "<node>                  <interface name='org.gahshomar.Api'>                    <method name='GetDay'>                      <arg type='s' name='day' direction='out'/>                    </method>                    <method name='GetDate'>                      <arg type='s' name='date' direction='out'/>                    </method>                  </interface>                </node>";
const ApiProxy = Gio.DBusProxy.makeProxyWrapper(ApiIface);

const ActionsIface = '<node><interface name="org.gtk.Actions"> <method name="List"> <arg type="as" name="list" direction="out"> </arg> </method> <method name="Describe"> <arg type="s" name="action_name" direction="in"> </arg> <arg type="(bgav)" name="description" direction="out"> </arg> </method> <method name="DescribeAll"> <arg type="a{s(bgav)}" name="descriptions" direction="out"> </arg> </method> <method name="Activate"> <arg type="s" name="action_name" direction="in"> </arg> <arg type="av" name="parameter" direction="in"> </arg> <arg type="a{sv}" name="platform_data" direction="in"> </arg> </method> <method name="SetState"> <arg type="s" name="action_name" direction="in"> </arg> <arg type="v" name="value" direction="in"> </arg> <arg type="a{sv}" name="platform_data" direction="in"> </arg> </method> <signal name="Changed"> <arg type="as" name="removals"> </arg> <arg type="a{sb}" name="enable_changes"> </arg> <arg type="a{sv}" name="state_changes"> </arg> <arg type="a{s(bgav)}" name="additions"> </arg> </signal> </interface> </node>';
const ActionsProxy = Gio.DBusProxy.makeProxyWrapper(ActionsIface);

const AppIface = '<node> <interface name="org.gtk.Application"> <method name="Activate"> <arg type="a{sv}" name="platform-data" direction="in"> </arg> </method> <method name="Open"> <arg type="as" name="uris" direction="in"> </arg> <arg type="s" name="hint" direction="in"> </arg> <arg type="a{sv}" name="platform-data" direction="in"> </arg> </method> <method name="CommandLine"> <arg type="o" name="path" direction="in"> </arg> <arg type="aay" name="arguments" direction="in"> </arg> <arg type="a{sv}" name="platform-data" direction="in"> </arg> <arg type="i" name="exit-status" direction="out"> </arg> </method> <property type="b" name="Busy" access="read"> </property> </interface> </node>';
const AppProxy = Gio.DBusProxy.makeProxyWrapper(AppIface);

const Gahshomar = new Lang.Class({
    Name: 'Gahshomar.Gahshomar',
    Extends: PanelMenu.Button,

    _init: function() {
        this.parent(0.0);

        this._bus_name = 'org.gahshomar.Gahshomar';
        this._object_path = '/org/gahshomar/Gahshomar';
        this._interface_name = 'org.gahshomar.Api';
        this._alive = false;
        // add day label
        this.label = new St.Label({y_expand: true,
                                   y_align: Clutter.ActorAlign.CENTER });
        this.actor.add_actor(this.label);

        // add popopMenuItem
        this.popopMenuItemDate = new PopupMenu.PopupMenuItem(_('Open Gahshomar'));
	    this.popopMenuItemDate.connect('activate', Lang.bind(this, this._onDatePressed));
        this.menu.addMenuItem(this.popopMenuItemDate);

        this.popopMenuItemQuit = new PopupMenu.PopupMenuItem('');
	    this.popopMenuItemQuit.connect('activate', Lang.bind(this, this._onQuitPressed));
        this.menu.addMenuItem(this.popopMenuItemQuit);

        this.actor.connect('destroy', Lang.bind(this, this._onDestroy));

        MainLoop.timeout_add(1000,
            Lang.bind(this, this._connect));
    },

    _connect: function(){
    	try {
	        Gio.DBus.session.watch_name(this._bus_name,
	            Gio.BusNameWatcherFlags.NONE, // no auto launch
	            Lang.bind(this, this._onGahshomarAppeared),
	            Lang.bind(this, this._onGahshomarVanished));
	        return false
    	}
    	catch(err){
    		return true
    	}

    },

    _start: function()
    {
    if (! this._alive)
    {
        // this._proxy = Gio.DBusProxy.new_for_bus_sync(Gio.BusType.SESSION,
        // 	Gio.DBusProxyFlags.NONE, null, this._bus_name, this._object_path,
        // 	this._interface_name, null)
		this._proxy = new ApiProxy(Gio.DBus.session, this._bus_name,
			this._object_path);
        this._actions_proxy = new ActionsProxy(Gio.DBus.session, this._bus_name,
            this._object_path);
        this._app_proxy = new AppProxy(Gio.DBus.session, this._bus_name,
            this._object_path);
        this._alive = true;
        this._timeoutId = MainLoop.timeout_add(5000,
            Lang.bind(this, this._update));
        this._update()
    }
    },

    _stop: function()
    {
        if (this._alive)
        {
         MainLoop.source_remove(this._timeoutId);
         this._alive = false;
         this.label.set_text('')
         this.popopMenuItemDate.label.set_text(_('Open Gahshomar'))
         this.popopMenuItemQuit.label.set_text('')
        }
     },

    _onGahshomarAppeared: function(owner) {
    	this._start();
    },

    _onGahshomarVanished: function(oldOwner) {
    	this._stop();
    },

    _onTimer: function() {
        if (! this._alive)
        {
            return false;
        }
        this._update()
        return this._alive;
    },

    _update: function() {
        text = this._proxy.GetDaySync()[0]
        if (text[0] == '۰') {
            text = text.slice(1);
        }
        this.label.set_text(text)
        text = this._proxy.GetDateSync()[0]
        this.popopMenuItemDate.label.set_text(text)
        // text = this._proxy.GetQuitStringSync()[0]
        this.popopMenuItemQuit.label.set_text(_('Quit'))
        // this.popopMenuItemQuit.label.set_text(gahshomarUserExtensionLocalePath)
    },

    _onDestroy: function() 
    {
		this._stop();
		this._destroy();
    },

    _destroy: function() {
		this._proxy = null;
        this.actor.destroy();
    },

    _onDatePressed: function() {
        if (! this._alive)
        {
            return false;
        }
        else
        {
            this._app_proxy.ActivateSync({})
        }
    },

    _onQuitPressed: function() {
    	this._actions_proxy.ActivateSync('quit', [], {})
    },
});

let _indicator;

function init(extensionMeta) {
  // gahshomarUserExtensionLocalePath = extensionMeta.path + '/locale';
  gahshomarUserExtensionLocalePath = '${prefix}/share/locale';
}

function enable() {
  Gettext.bindtextdomain("gahshomar", '');
  Gettext.textdomain("gahshomar");
  _indicator = new Gahshomar;
  Main.panel.addToStatusArea('gahshomar-applet', _indicator);
}

function disable() {
  _indicator.destroy();
}
