%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:              fwbackups
Version:           1.43.5
Release:           1%{?dist}
Summary:           A feature-rich user backup program
Group:             Applications/Archiving
License:           GPLv2+
URL:               http://www.diffingo.com/oss/fwbackups/
Source0:           http://downloads.diffingo.com/fwbackups/fwbackups-%{version}.tar.bz2
BuildRoot:         %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:         noarch

BuildRequires:     desktop-file-utils
# Pulls gettext, autotools
BuildRequires:     intltool
BuildRequires:     glib2-devel
BuildRequires:     python-devel >= 2.4

Requires:          /usr/bin/crontab
Requires:          tar, rsync
Requires:          notify-python
Requires:          pygtk2, pygtk2-libglade
Requires:          python >= 2.4
Requires:          python-paramiko

%description
fwbackups is a feature-rich user backup program that allows users (including
but not limited to root) to backup their files on demand or periodically via
backup sets. Each set may have different settings meaning users can backup
groups of files and folders to different destinations at different times.
Restores can be performed at any time using an existing backup from fwbackups
or from the contents of an external folder or archive.


%prep
%setup -q -n %{name}-%{version}

%build
%configure
# We don't implement this yet: make %{?_smp_mflags}
make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

desktop-file-install \
    --dir ${RPM_BUILD_ROOT}%{_datadir}/applications\
    --delete-original \
    ${RPM_BUILD_ROOT}%{_datadir}/applications/%{name}.desktop

# No translations yet
#find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

#files -f %{name}.lang
%files
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING README TODO
%{_bindir}/*
%{_datadir}/%{name}/
%{_datadir}/pixmaps/*
%{_datadir}/applications/*.desktop
%{python_sitelib}/%{name}/

%changelog
* Sat Dec 26 2015 Stewart Adam <s.adam at diffingo.com> - 1.43.5-1
- Update to 1.43.5

* Sun Dec 19 2010 Stewart Adam <s.adam at diffingo.com> 1.43.4-1
- Update to 1.43.4

* Sun Nov 28 2010 Stewart Adam <s.adam at diffingo.com> 1.43.3-1
- Update to 1.43.3

* Thu Oct 28 2010 Stewart Adam <s.adam at diffingo.com> 1.43.3-0.1.rc6
- Update to 1.43.3rc6

* Thu Jul 1 2010 Stewart Adam <s.adam at diffingo.com> 1.43.3-0.1.rc5
- Update to 1.43.3rc5

* Sat Aug 22 2009 Stewart Adam <s.adam at diffingo.com> 1.43.3-0.1.rc4
- Update to 1.43.3rc4 (fixes #518690)

* Tue Aug 4 2009 Stewart Adam <s.adam at diffingo.com> 1.43.3-0.1.rc3
- Update to 1.43.3rc3

* Thu May 28 2009 Stewart Adam <s.adam at diffingo.com> 1.43.3-0.1.rc2
- Update to 1.43.3rc2 (fixes #495604, #495605)

* Sun Mar 22 2009 Stewart Adam <s.adam at diffingo.com> 1.43.3-0.1.rc1
- Update to 1.43.3rc1 (fixes #489034, #489040, #491469, #491472)

* Wed Oct 1 2008 Stewart Adam <s.adam at diffingo.com> 1.43.2-1
- Update to 1.43.2 final
- BR: gnome-doc-utils

* Fri Jul 18 2008 Stewart Adam <s.adam at diffingo.com> 1.43.2-0.1.rc3
- Update to 1.43.2rc3

* Sat May 31 2008 Stewart Adam <s.adam at diffingo.com> 1.43.2-0.1.rc2
- Update to 1.43.2rc2

* Sat Apr 12 2008 Stewart Adam <s.adam at diffingo.com> 1.43.2-0.1.rc1
- Update to 1.43.2rc1

* Thu Jan 17 2008 Stewart Adam <s.adam at diffingo.com> 1.43.2-0.1.beta3
- Update to beta3 (not finished work yet)
- BR: libxml2
- Remove useless python >= 2.4 BR
- Remove scrollkeeper scriptlets; Only need that for .omf files
- Don't require vixie-cron, but do require /usr/bin/crontab

* Wed Oct 31 2007 Stewart Adam <s.adam at diffingo.com> 1.43.2-0.1.beta1
- Update to 1.43.2 beta1

* Mon Oct 22 2007 Stewart Adam <s.adam at diffingo.com> 1.43.2-0.1
- 1.42.3 spec using autotools/automake
- Remove Manual fields patch

* Sat Sep 1 2007 Stewart Adam <s.adam at diffingo.com> 1.43.1-5
- Add BR python-devel

* Thu Aug 16 2007 Stewart Adam <s.adam at diffingo.com> 1.43.1-4
- Add Requires vixie-rcron

* Mon Aug 13 2007 Stewart Adam <s.adam at diffingo.com> 1.43.1-3
- Update license field

* Wed Jul 25 2007 Stewart Adam <s.adam at diffingo.com> 1.43.1-2
- Add Manual fields patch (bz #249592)

* Sun Jul 22 2007 Stewart Adam <s.adam at diffingo.com> 1.43.1-1
- Change get_python_lib() to get_python_lib(1) for x86_64
- Add new Requires and Post(un) scripts because of new documentation
- Switch all instances of fwbackups to %%{name} for consistency
- Update to 1.43.1 (see CHANGELOG file for details on version changes)

* Sun Jul 8 2007 Stewart Adam <s.adam at diffingo.com> 1.43.0-1
- Add BuildRequires python 2.4, gettext
- Add Requires python 2.4, notify-python
- No longer requires redhat-artwork and usermode
- New description
- Update to 1.43.0 (see CHANGELOG file for details on version changes)

* Sat Apr 14 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.43.0-0.1.beta3
- Update to 1.43.0 Beta3

* Mon Mar 26 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.43.0-0.1.beta2
- Update to 1.43.0 Beta2

* Sun Mar 18 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.43.0-0.1.beta1
- Make release a Beta1 so the upgrade to final upgrade goes smoothly...

* Fri Mar 16 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.43.0-3
- Minor changes to package again

* Wed Mar 14 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.43.0-2
- Minor changes

* Mon Feb 12 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.43.0-1
- Update to version 1.43

* Sun Jan 28 2007 Stewart Adam <s.adam AT diffingo DOT com> 1.42.2-1
- Update to version 1.42.2 (see CHANGELOG file for details on version changes)

* Sat Sep 30 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42.1-3
- Clean up spec for final submission to Fedora Extras

* Sat Sep 30 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42.1-2
- Match upstream md5sum
- Fix capitals in %%Source0 tag

* Tue Sep 26 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42.1-1
- Clean up %%install section
- Don't install fwbackups.conf twice
- Make tarball match upstream
- Add the default configuration file to %%doc, and make it replaceable
- Update to version 1.42.1 (see CHANGELOG file for details on version changes)

* Thu Sep 21 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42-5
- Add %%requires: pygtk2-libglade

* Wed Sep 13 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42-4
- Fix the python_sitearch macro
- Update file paths
- Fix URL tag

* Wed Sep 06 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42-3
- Made pam use 'include' statements and not the old pam_stack
- Use relative symlinks

* Sun Sep 03 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42-2
- Added CHANGELOG file for detailed information on changes between versions
- Made this .spec and package files suitable for Fedora Extras submission

* Thu Aug 29 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42-1
- Fixed errors when removing symbolic links
- Make listing files in RemoveOldBackups list files and directory names, not their contents

* Thu Aug 15 2006 Stewart Adam <s.adam AT diffingo DOT com> 1.42-0
- Rebuild using sample .spec file from Fedora Extras
- Update to version 1.42 (see CHANGELOG file for details on version changes)

