// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2004 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

#include "TerrainModProperty.h"

#include "LocatedEntity.h"
#include "TerrainModTranslator.h"
#include "TerrainProperty.h"
#include "Domain.h"

#include "common/debug.h"

#include "modules/TerrainContext.h"

#include <Atlas/Objects/RootEntity.h>
#include <Atlas/Objects/Operation.h>

static const bool debug_flag = false;

using Atlas::Message::Element;
using Atlas::Message::MapType;
using Atlas::Message::ListType;
using Atlas::Message::FloatType;
using Atlas::Objects::Entity::RootEntity;
using Atlas::Objects::Root;

const std::string TerrainModProperty::property_name = "terrainmod";
const std::string TerrainModProperty::property_atlastype = "map";

/// \brief TerrainModProperty constructor
///
TerrainModProperty::TerrainModProperty() :
        m_translator(nullptr)
{
}

TerrainModProperty::~TerrainModProperty()
{
    // TODO remove the mod from the terrain
    // This is already covered from the Delete op handler when
    // the entity is deleted
    delete m_translator;
}

TerrainModProperty * TerrainModProperty::copy() const
{
    // This is for instantiation of a class property.
    // This is complex here, as is it not yet clear if this
    // class can be a class property.
    return new TerrainModProperty(*this);
}

void TerrainModProperty::install(LocatedEntity * owner, const std::string & name)
{
}

void TerrainModProperty::remove(LocatedEntity *owner, const std::string & name)
{
}

void TerrainModProperty::apply(LocatedEntity * owner)
{
    delete m_translator;

    m_translator = new TerrainModTranslator(m_data);

}

HandlerResult TerrainModProperty::operation(LocatedEntity * ent, const Operation & op, OpVector & res)
{

    return OPERATION_IGNORED;
}

void TerrainModProperty::move(LocatedEntity* owner)
{
}

void TerrainModProperty::remove(LocatedEntity * owner)
{
}

Mercator::TerrainMod * TerrainModProperty::parseModData(const WFMath::Point<3>& pos, const WFMath::Quaternion& orientation) const
{
    if (m_translator) {
        return m_translator->parseData(pos, orientation);
    }
    return nullptr;
}

int TerrainModProperty::getAttr(const std::string & name, Element & val)
{
    MapType::const_iterator I = m_data.find(name);
    if (I != m_data.end()) {
        val = I->second;
        return 0;
    }
    return -1;
}

void TerrainModProperty::setAttr(const std::string & name, const Element & val)
{
    m_data[name] = val;
}

HandlerResult TerrainModProperty::move_handler(LocatedEntity * e, const Operation & op, OpVector & res)
{
//    // FIXME Force instantiation of a class property?
//
//    // Check the validity of the operation.
//    const std::vector<Root> & args = op->getArgs();
//    if (args.empty()) {
//        return OPERATION_IGNORED;
//    }
//    RootEntity ent = Atlas::Objects::smart_dynamic_cast<RootEntity>(args.front());
//    if (!ent.isValid()) {
//        return OPERATION_IGNORED;
//    }
//    if (e->getId() != ent->getId()) {
//        return OPERATION_IGNORED;
//    }
//
//    // Update the modifier
//    move(e);
    return OPERATION_IGNORED;
}

HandlerResult TerrainModProperty::delete_handler(LocatedEntity * e, const Operation & op, OpVector & res)
{
//    remove(e);

    return OPERATION_IGNORED;
}

