// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2000,2001 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA


#ifndef RULESETS_CREATOR_H
#define RULESETS_CREATOR_H

#include "Character.h"

/// \brief This is a class for an in-game entity used by administrators
/// and world builders to manipulate the world
/// \ingroup EntityClasses
class Creator : public Character {
  public:
    explicit Creator(const std::string & id, long intId);
    virtual ~Creator();

    virtual void operation(const Operation & op, OpVector &);
    virtual void externalOperation(const Operation & op, Link &);

    virtual void mindLookOperation(const Operation & op, OpVector &);

    /// \brief Filter a Set operation coming from the mind
    ///
    /// For the creator any set operation is permitted.
    /// @param op The operation to be filtered.
    /// @param res The filtered result is returned here.
    virtual void mindSetOperation(const Operation &, OpVector &);

  protected:
    /**
     * \brief Relays an operation to an entity, expecting a response.
     *
     * This will relay the operation to the entity, making it appear to come from the entity itself.
     * Any response from the entity, using the serial number as reference, will be relayed back to
     * this entity and then sent on to the controlling mind. The operation sent back will have the same
     * refno as the initial serialno.
     * Any client therefore must make sure to handle those operations it receives with special care, as they
     * are "unsafe", being generated by an external mind.
     *
     * \param op The operation to relay.
     * \param to The entity to which the operation will be relayed.
     */
    void relayOperationTo(const Operation & op, LocatedEntity& to);
};

#endif // RULESETS_CREATOR_H
