// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2000,2001 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA


#ifndef COMMON_ENTITY_KIT_H
#define COMMON_ENTITY_KIT_H

#include <Atlas/Objects/ObjectsFwd.h>

#include <set>
#include <map>
#include <string>

namespace Atlas {
    namespace Message {
        class Element;
        typedef std::map<std::string, Element> MapType;
    }
}

class LocatedEntity;
class TypeNode;

template<class T>
class ScriptKit;

/// \brief Abstract factory for creating in-game entity objects.
///
/// An Entity consists of an instance of one of a number of C++ classes
/// optionally with a script. Stores information about default attributes,
/// script language and class name.
class EntityKit {
  protected:
    EntityKit();
  public:
    /// Inheritance type of this class.
    TypeNode * m_type;
    /// Number of times this factory has created an entity
    int m_createdCount;

    virtual ~EntityKit();

    /// \brief Create a new Entity and make it persistent.
    ///
    /// @param id a string giving the identifier of the Entity.
    /// @param intId an integer giving the identifier of the Entity.
    /// @param attributes custom attributes set for the new instance
    /// @param attributes the location of the entity
    virtual LocatedEntity * newEntity(const std::string & id,
                                      long intId,
                                      const Atlas::Objects::Entity::RootEntity & attributes,
                                      LocatedEntity* location) = 0;

    virtual void addProperties() = 0;

    virtual void updateProperties() = 0;

};

#endif // COMMON_ENTITY_KIT_H
