// Eris Online RPG Protocol Library
// Copyright (C) 2011 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id$

#ifdef NDEBUG
#undef NDEBUG
#endif
#ifndef DEBUG
#define DEBUG
#endif

#include <Eris/Account.h>
#include <Eris/Connection.h>
#include <Eris/Exceptions.h>
#include <Eris/EventService.h>
#include <Eris/View.h>
#include <Eris/IGRouter.h>
#include <Eris/WaitFreeQueue.h>



int main() {
	// Constructor
	{
		boost::asio::io_service io_service;
		Eris::EventService eventService(io_service);
		Eris::Connection* c = new Eris::Connection(io_service, eventService, "", "", 0);
		new Eris::Account(*c);
	}

	// Destructor
	{
		boost::asio::io_service io_service;
		Eris::EventService eventService(io_service);
		Eris::Connection* c = new Eris::Connection(io_service, eventService, "", "", 0);
		Eris::Account* ac = new Eris::Account(*c);
		delete ac;
	}

	return 0;
}

