/*
 Copyright (C) 2009 Erik Ogenvik <erik@ogenvik.org>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software Foundation,
 Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef WORLDATTACHMENT_H_
#define WORLDATTACHMENT_H_

#include "domain/IEntityAttachment.h"

namespace Ogre
{
class SceneNode;
}

namespace Ember
{
class EmberEntity;
struct IGraphicalRepresentation;
namespace OgreView
{

namespace Terrain
{
class TerrainManager;
}

class Scene;

class WorldAttachment: public IEntityAttachment
{
public:
	WorldAttachment(EmberEntity& worldEntity, Ogre::SceneNode* worldNode, Scene& scene);
	~WorldAttachment() override;

	IGraphicalRepresentation* getGraphicalRepresentation() const override;

	EmberEntity& getAttachedEntity() const override;

	EmberEntity* getParentEntity() const override;

	std::unique_ptr<IEntityAttachment> attachEntity(EmberEntity& entity) override;

	void updateScale() override;

	void updatePosition() override;

	void getOffsetForContainedNode(const IEntityAttachment& attachment, const WFMath::Point<3>& localPosition, WFMath::Vector<3>& offset) override;

	void setControlDelegate(IEntityControlDelegate* controllerDelegate) override;

	IEntityControlDelegate* getControlDelegate() const override;

	/**
	 * General method for turning on and off debug visualizations. Subclasses might support more types of visualizations than the ones defined here.
	 * @param visualization The type of visualization. Currently supports "OgreBBox".
	 * @param visualize Whether to visualize or not.
	 */
	void setVisualize(const std::string& visualization, bool visualize) override;

	/**
	 * @brief Gets whether a certain visualization is turned on or off.
	 * @param visualization The type of visualization. Currently supports "OgreBBox".
	 * @return true if visualization is turned on, else false
	 */
	bool getVisualize(const std::string& visualization) const override;
protected:

	EmberEntity& mWorldEntity;
	Ogre::SceneNode* mWorldNode;
	Scene& mScene;
};

}
}
#endif /* WORLDATTACHMENT_H_ */
