/*
 Copyright (C) 2018 Erik Ogenvik

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CYPHESIS_CYPY_ROOT_H
#define CYPHESIS_CYPY_ROOT_H

#include "WrapperBase.h"

#include <Atlas/Objects/Root.h>
#include <Atlas/Objects/SmartPtr.h>

/**
 * \ingroup PythonWrappers
 */
class CyPy_Root: public WrapperBase<Atlas::Objects::Root, CyPy_Root>
{
    public:
        CyPy_Root(Py::PythonClassInstance* self, Py::Tuple& args, Py::Dict& kwds);

        CyPy_Root(Py::PythonClassInstance* self, Atlas::Objects::Root value);

        static void init_type();

        Py::Object mapping_subscript(const Py::Object&) override;

        int sequence_contains(const Py::Object&) override;

        int mapping_ass_subscript(const Py::Object&, const Py::Object&) override;

        Py::Object get_name();

        PYCXX_NOARGS_METHOD_DECL(CyPy_Root, get_name)

    protected:


        Py::Object getattro(const Py::String& name) override;

        int setattro(const Py::String& name, const Py::Object& attr) override;
};


#endif //CYPHESIS_CYPY_ROOT_H
