'From Pharo1.4 of 18 April 2012 [Latest update: #14457] on 17 January 2013 at 7:04:52 pm'!
Object subclass: #StartScript
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Image-Launch'!
!StartScript commentStamp: 'NorbertHartl 10/18/2012 17:00' prior: 0!
todo:

- pharo1.x has only single - options but with long names
- pharo2.x hast short option with single - and long options with --
- short options are of format -o arg
- long options are of format --ooo=arg
--> need to define a compat mode for both versions

- maybe it is a good idea to split classes for pharo1x and 2x. Filing in more then one class shouldn't be a big problem!


"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

StartScript class
	instanceVariableNames: 'stdout'!

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 4/19/2012 17:55'!
beVerbose
	stdout := StandardFileStream stdout.! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 1/17/2013 19:02'!
cmdLine
	^ CommandLine uniqueInstance! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 10/18/2012 16:22'!
executeScript: aString 
	| methodNode method |
	methodNode := Compiler new
		compileNoPattern: aString readStream
		in: self  
		context: nil
		notifying: nil
		ifFail: [ ^ nil ].
	method := methodNode generate.
	self class addSelectorSilently: #doit withMethod: method.
	 ^ self doit.! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 1/17/2013 19:03'!
fileNamesIn: aDirectoryPath
	^ (FileDirectory on: aDirectoryPath) entries collect: [:each| each fullName]! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 1/17/2013 19:03'!
hasCmdLineOption: aString
	^ self cmdLine hasOption: '-', aString! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 10/18/2012 15:50'!
loadFilesIn: aDirectoryPath
	(self fileNamesIn: aDirectoryPath )sorted do: [:each|
		(each asFileReference isDirectory) ifFalse: [
			self loadScriptFileNamed: each]]! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 4/19/2012 18:00'!
loadScriptFileNamed: aString
	^ self 
		executeScript: (StandardFileStream readOnlyFileNamed: aString) contentsOfEntireFile ! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 4/19/2012 17:55'!
log: aString
	stdout ifNotNil: [
		stdout
			nextPutAll: aString;
			nextPutAll: String crlf ]! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 4/20/2012 10:04'!
numberOptionAt: aString ifPresent: aBlock
	^ self optionAt: aString ifPresent: aBlock convertUsing: [:val| Number readFrom: val ] ! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 1/17/2013 19:03'!
optionAt: aString
	^ (self cmdLine allArgumentsAtOption: '-',aString) first! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 4/20/2012 10:04'!
optionAt: aString ifPresent: aBlock
	self optionAt: aString ifPresent: aBlock convertUsing: [:val| val ]! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 1/17/2013 19:04'!
optionAt: aString ifPresent: aBlock convertUsing: aConversionBlock
	(self hasCmdLineOption: aString) ifTrue: [
		aBlock value: (
			aConversionBlock value: (
				(self cmdLine allArgumentsAtOption: '-',aString)
					ifNotNil: [:args| args first]
					ifNil: [ nil ] ))]! !

!StartScript class methodsFor: 'as yet unclassified' stamp: 'NorbertHartl 1/17/2013 19:01'!
start: aPathString
	| startPath |
	self optionAt: 'verbose' ifPresent: [:v|
		self  beVerbose.
		self log: 'verbose on' ].

	startPath := aPathString.
	self optionAt: 'image-launchdir' ifPresent: [:dir|
		startPath := dir ].
	self log: 'loading scripts from ',startPath.

	"load all files in directory"
	self  loadFilesIn: startPath ! !
