/****************************************************************************

Copyright (c) 2000 - 2010 Novell, Inc.
All Rights Reserved.

This program is free software; you can redistribute it and/or
modify it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, contact Novell, Inc.

To contact Novell about this file by physical or electronic mail,
you may find current contact information at www.novell.com

****************************************************************************


  File:		YCP_UI_Exception.h

  Author:     	Stefan Hundhammer <sh@suse.de>

/-*/

#ifndef YCP_UI_Exception_h
#define YCP_UI_Exception_h


#include <ycp/YCPValue.h>
#include <yui/YUIException.h>


/**
 * Exception class for "YCP dialog term syntax error"
 **/
class YCPDialogSyntaxErrorException: public YUIException
{
public:
    YCPDialogSyntaxErrorException( const string & msg )
	: YUIException( string( "Syntax Error:" ) + msg )
	{}

    YCPDialogSyntaxErrorException( const string   & expected,
				   const YCPValue & seen )
	: YUIException( string( "Syntax Error: " )
			+ expected
			+ string( ", seen: " ) +
			seen->toString() )
	{}

    virtual ~YCPDialogSyntaxErrorException() throw()
	{}
};


#endif // YCP_UI_Exception_h
