# encoding: utf-8

module Yast
  class DefaultDesktopClient < Client
    def main
      # testedfiles: DefaultDesktop
      Yast.include self, "testsuite.rb"

      @READ = {
        "target" => {
          "size"   => 55452,
          "stat"   => { "size" => 55452 },
          "tmpdir" => "/tmp/"
        },
        "xml"    => {
          "software" => {
            # desktop selected by default
            "default_desktop"    => "kde",
            # all available desktops
            "supported_desktops" => [
              {
                "cursor"   => "DMZ",
                "desktop"  => "gnome",
                "icon"     => "pattern-gnome",
                "label_id" => "desktop_gnome",
                "logon"    => "gdm",
                "name"     => "gnome",
                "order"    => 1,
                "packages" => "gdm branding-openSUSE",
                "patterns" => "gnome x11 base"
              },
              {
                "cursor"   => "DMZ",
                "desktop"  => "kde4",
                "icon"     => "pattern-kde4",
                "label_id" => "desktop_kde",
                "logon"    => "kdm",
                "name"     => "kde",
                "order"    => 1,
                "packages" => "kdm branding-openSUSE",
                "patterns" => "kde x11 base"
              },
              {
                "cursor"   => "DMZ",
                "desktop"  => "xfce",
                "icon"     => "pattern-xfce",
                "label_id" => "desktop_xfce",
                "logon"    => "lightdm",
                "name"     => "xfce",
                "order"    => 4,
                "packages" => "lightdm branding-openSUSE",
                "patterns" => "xfce x11 base"
              },
              {
                "cursor"   => "DMZ",
                "desktop"  => "lxde",
                "icon"     => "pattern-lxde",
                "label_id" => "desktop_lxde",
                "logon"    => "lxdm",
                "name"     => "lxde",
                "order"    => 5,
                "packages" => "lxde-common branding-openSUSE",
                "patterns" => "lxde x11 base"
              },
              {
                "cursor"   => "DMZ",
                "desktop"  => "twm",
                "icon"     => "yast-x11",
                "label_id" => "desktop_min_x",
                "logon"    => "xdm",
                "name"     => "min_x",
                "order"    => 6,
                "packages" => "xorg-x11 branding-openSUSE",
                "patterns" => "x11 base"
              },
              {
                "cursor"   => "DMZ",
                "desktop"  => "twm",
                "icon"     => "yast-sshd",
                "label_id" => "desktop_textmode",
                "logon"    => "xdm",
                "name"     => "textmode",
                "order"    => 8,
                "packages" => "branding-openSUSE",
                "patterns" => "minimal_base minimal_base-conflicts"
              }
            ]
          },
          # names for desktops
          "texts"    => {
            "desktop_gnome"    => { "label" => "GNOME Desktop" },
            "desktop_kde"      => { "label" => "KDE Desktop" },
            "desktop_lxde"     => { "label" => "LXDE Desktop" },
            "desktop_min_x"    => { "label" => "Minimal X Window" },
            "desktop_textmode" => {
              "label" => "Minimal Server Selection (Text Mode)"
            },
            "desktop_xfce"     => { "label" => "XFCE Desktop" }
          }
        }
      }
      @WRITE = {}
      @EXEC = {}

      TESTSUITE_INIT([@READ, @WRITE, @EXEC], nil)

      Yast.import "DefaultDesktop"

      DUMP(" --- All desktops --- ")
      TEST(lambda { DefaultDesktop.GetAllDesktopsMap }, [@READ, {}, @EXEC], nil)

      # Using the default
      DUMP(" --- KDE selected by default --- ")
      TEST(lambda { DefaultDesktop.Desktop }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.SelectedPatterns }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.SelectedPackages }, [@READ, {}, @EXEC], nil)

      # Adjusting new variable
      DUMP(" --- Selecting GNOME --- ")
      TEST(lambda { DefaultDesktop.SetDesktop("gnome") }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.Desktop }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.SelectedPatterns }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.SelectedPackages }, [@READ, {}, @EXEC], nil)

      # Back to the default
      DUMP(" --- Reset --- ")
      TEST(lambda { DefaultDesktop.ForceReinit }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.Desktop }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.SelectedPatterns }, [@READ, {}, @EXEC], nil)
      TEST(lambda { DefaultDesktop.SelectedPackages }, [@READ, {}, @EXEC], nil)

      nil
    end
  end
end

Yast::DefaultDesktopClient.new.main
