# encoding: utf-8

# ***************************************************************************
#
# Copyright (c) 2000 - 2012 Novell, Inc.
# All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, contact Novell, Inc.
#
# To contact Novell about this file by physical or electronic mail,
# you may find current contact information at www.novell.com
#
# ***************************************************************************
# File:        testsuite/tests/Inetd.ycp
# Package:     Configuration of inetd
# Summary:     Testsuite for Reading and Writing (x)inetd configuration
# Authors:     Martin Vidner <mvidner@suse.cz>
#              Petr Hadraba <phadraba@suse.cz>
#
# $Id$
#
# This is testsuite for Inetd.ycp source file.
# These tests are checking reading and writing
# of inetd or xinetd services.
module Yast
  class InetdR2Client < Client
    def main
      # testedfiles: Inetd.ycp Service.ycp Testsuite.ycp

      Yast.include self, "testsuite.rb"
      Yast.import "Inetd"
      Yast.import "Report"

      Report.DisplayErrors(false, 0)

      @SYSTEM_CONF = [
        {
          "iid"         => "whatever",
          "comment"     => "My service",
          "enabled"     => true,
          "service"     => "finger",
          "socket_type" => "stream",
          "protocol"    => "tcp",
          "wait"        => false,
          "user"        => "nobody",
          "server"      => "/usr/sbin/tcpd",
          "server_args" => "in.fingerd -w"
        },
        {
          "iid"         => "whatever2",
          "comment"     => "new service",
          "enabled"     => false,
          "service"     => "ns",
          "socket_type" => "stream",
          "protocol"    => "tcp",
          "wait"        => false,
          "user"        => "nobody",
          "server"      => "/usr/sbin/newservice",
          "server_args" => "none"
        }
      ]

      @PROFILE_CONF = [
        {
          "iid"         => "whatever",
          "comment"     => "My service",
          "enabled"     => true,
          "service"     => "finger",
          "socket_type" => "stream",
          "protocol"    => "tcp",
          "wait"        => false,
          "user"        => "nobody",
          "server"      => "/usr/sbin/tcpd",
          "server_args" => "in.fingerd -w"
        },
        #"server_args": "none",
        {
          "iid"      => "inst1",
          #"comment": "new service",
          "enabled"  => true,
          "service"  => "ns",
          #"socket_type": "stream",
          "protocol" => "tcp",
          #"wait": false,
          #"user": "nobody",
          "server"   => "newservice"
        }
      ]

      # In normal mode, the new installed service has no entry
      # in netd_conf.
      @EDITED_CONF = [
        {
          "iid"         => "whatever",
          "comment"     => "My service",
          "enabled"     => true,
          "service"     => "finger",
          "socket_type" => "stream",
          "protocol"    => "tcp",
          "wait"        => false,
          "user"        => "nobody",
          "server"      => "/usr/sbin/tcpd",
          "server_args" => "in.fingerd -w"
        }
      ]

      DUMP("\nDefault (full) configuration\n")
      DUMP(@SYSTEM_CONF)

      DUMP("\nNew package installed in normal mode\n")
      DUMP(Inetd.MergeEditedWithSystem(@SYSTEM_CONF, @EDITED_CONF))
      DUMP("\n---\n")

      Inetd.auto_mode = true

      DUMP("\nNew package installed in autoinstall mode\n")
      DUMP(Inetd.mergeAfterInstall(@SYSTEM_CONF, @PROFILE_CONF))
      DUMP("\n---\n")

      DUMP("\nNo packages was installed --- configuration is the same\n")
      DUMP(Inetd.mergeAfterInstall(@SYSTEM_CONF, @SYSTEM_CONF))
      DUMP("\n---\n")

      nil
    end
  end
end

Yast::InetdR2Client.new.main
