#! /bin/bash
# $Id$
# required: pdb-commandline.rpm
#

# See doc/README.maintainer

# generate default_conf_{inet,xinetd}.ycp, as required by
# http://w3.suse.de/~kkaempf/yast2/planning/descr/improvement_24.html
# by
# - querying PDB for all config files
# - extracting them all
# - running the agent (for inetd, xinetd)
# - for each program, quering the PDB which RPM it is in

SX=default_conf

# $1: package name
# $2: file (wildcard) to extract
function extract() {
    echo "$1" >&2
    # rpm3: etc/foo, rpm4: ./etc/foo
    rpm2cpio /work/CDs/all/full-head-i586/suse/*/$1.rpm \
    | cpio -idm --no-absolute-filenames "./$2" "$2" 2> /dev/null
}

# $1: file name
function add_header() {
    mv "$1" "$1"~
    MAINTAINER=$(head -1 $(dirname $0)/../MAINTAINER)
    # do not let CVS or bash expand the keyword
    cat - "$1"~ <<EOF > "$1"
// This file is generated by inetd/src/all-services.sh - DO NOT EDIT! --
// Maintainer: $MAINTAINER
// \$Id\$
{

textdomain "inetd";
import "XVersion";

string GetBinPath () {
    string bin_path = XVersion::binPath();
    if (bin_path == nil) {
	y2error("XVersion::binPath() is nil!");
	bin_path = "";
    }
    return bin_path;
}

string x_bin_path = GetBinPath();


global services_t default_conf =
EOF
    echo ";
}" >> "$1"
}

function change_X11_paths() {
    mv "$1" "$1"~

    # VNC is part of X11. X11 binaries were moved from one directory to another,
    # XVersion::binPath() takes care about it
    sed 's/[ \t]\+:[ \t]\+".*\/\(Xvnc\|vnc_inetd_httpd\)"/ : x_bin_path + "\/\1"/' $1~ > $1
}

# Checking for the required commandline tool
if [ ! -x /usr/bin/pdb ]; then
    echo "Please install package 'pdb-commandline'"
    exit 5
fi

# Removing the old configuration
rm -rf etc

if [ ! -d etc ]; then
extract xinetd etc/xinetd.conf

# no leading slash
DIR=etc/xinetd.d
pdb query --release stable-i386 --filter "rpmdir:/$DIR" --attribs packname > $SX-pkgs

sort $SX-pkgs | while read pkg; do
    extract $pkg "$DIR/*"
done
fi

# use the current agent
ln -snf ../agents servers_non_y2

echo Proceeding in YCP
Y2DIR=. /sbin/yast2 ./${SX}_create.ycp

echo Converting Xpaths
change_X11_paths ./${SX}_xinetd.ycp

# appease check_ycp
add_header ./${SX}_xinetd.ycp
