#! /bin/bash

# Run test on one ycp file
# Michal Svec <msvec@suse.cz>
#
# $1 = script.ycp
# $2 = stdout
# $3 = stderr
#
# These arguments may be preceded by options that will be passed to y2base

while [ $# -gt 3 ]; do
    OPTIONS="$OPTIONS $1"
    shift
done

unset LANG
unset LC_CTYPE
unset LC_NUMERIC
unset LC_TIME
unset LC_COLLATE
unset LC_MONETARY
unset LC_MESSAGES
unset LC_PAPER
unset LC_NAME
unset LC_ADDRESS
unset LC_TELEPHONE
unset LC_MEASUREMENT
unset LC_IDENTIFICATION
unset LC_ALL

unset Y2DEBUG
unset Y2DEBUGALL
# export Y2DEBUG=1
# export Y2DEBUGALL=1
export Y2ALLGLOBAL=1

ybindir=`pkg-config  --print-errors --variable=ybindir  yast2-devtools`
yast2dir=`pkg-config --print-errors --variable=yast2dir yast2-devtools`
Y2BASE=$ybindir/y2base
logconf="$yast2dir/data/testsuite/log.conf"

if [ ! -f "$logconf" ]; then
  logconf="../skel/log.conf"
fi

DUMMY_LOG_STRING="LOGTHIS_SECRET_314 "

files="$(grep '^[#/*[:space:]]*testedfiles:' "$1"|sed 's/.*testedfiles:[[:space:]]*//g')"
if [ "$files" ]; then
  echo "$files" >> testsuite.log
  regex="[ /](testsuite\.ycp|Testsuite\.ycp|$(echo "$files"|sed 's|\.|\\.|g'|sed 's| |\||g')):"
fi
regex=${regex//.ycp/.(ycp|rb)}
regex=${regex//.yh/.(yh|rb)}
echo "$regex" >> testsuite.log

parse() {
  file="`mktemp /tmp/yast2-test.XXXXXX`"
  cat >"$file"
  if [ -z "$Y2TESTSUITE" ]; then
    # errors are OK if they come from YCP (or Perl, #41448),
    # mark them for output
    sed1="s/ <[2-5]> [^ ]\+ \[\(YCP\|Perl\|Ruby\)\] \([^ ]\+\) / <0> host [YCP] \2 ${DUMMY_LOG_STRING}Log	/"
    # leave only essential info
    sed2="s/^.*$DUMMY_LOG_STRING//g"
    ycp="\[YCP\].*$DUMMY_LOG_STRING"
    components="(agent-dummy|YCP|Ruby)"
    cat "$file" | sed "$sed1" | grep -E "<[012]>[^]]*$components.*$regex.*$DUMMY_LOG_STRING" | sed "$sed2" # | cut -d" " -f7-
    # Y2PMrc: #38235
    cat "$file" | grep "<[345]>" | grep -v "\[\(YCP\|Perl\|Ruby\|Y2PMrc\)\]" >&2
  else
    echo "Y2TESTSUITE set to \"$Y2TESTSUITE\""
    echo
    cat "$file"
  fi
  rm -f "$file"
}

# Set a good default value so the testsuite can use the local modules
# instead of the system ones.
if [ -z "${Y2DIR+x}" ] && [ -d ../src ]; then
	Y2DIR="../src"
fi

( Y2DIR=$Y2DIR:$Y2BASE_Y2DIR LD_LIBRARY_PATH=$Y2BASE_LD_LIBRARY_PATH $Y2BASE -l - -c "$logconf" $Y2BASEFLAGS $OPTIONS "$1" UI 2>&1 ) | tee "raw.$3" | parse >"$2" 2>"$3"

retcode="$PIPESTATUS"
if [ "$retcode" -gt 0 ]; then
  if [ "$retcode" -ge 128 ]; then
    sig=$[$retcode-128]
    echo -ne "\nCommand terminated on signal '$sig'"
    echo -e '!\n'
  else
    echo -e "\nReturn code: '$retcode'.\n"
  fi
fi

exit "$retcode"
# EOF
