/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.SVNUtil;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.types.ExternalItem;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class UtilTests
extends SVNTests {
    private static final String NL = System.getProperty("line.separator");
    public static final String testName = "util_test";
    private final byte[] fileContentsPrefix = "1\n2\n3\n4\n".getBytes();
    private final byte[] fileContentsSuffix = "N-3\nN-2\nN-1\nN\n".getBytes();
    private static List<ExternalItem> externals = null;
    private static final byte[] externals_propval;
    private static List<ExternalItem> old_externals;
    private static final byte[] old_externals_propval;
    private static final String util_cred_hash = "4d7de6b1e103fbfc5e61565223ca23be";
    private static final String util_cred_username = "K 8\nusername\nV 5\nmungo\nK 15\nsvn:realmstring\nV 27\nhttps://svn.example.com:443\nEND\n";
    private static final String util_cred_simple = "K 8\npasstype\nV 10\njavahltest\nK 8\nusername\nV 5\nmungo\nK 8\npassword\nV 6\nsecret\nK 15\nsvn:realmstring\nV 27\nhttps://svn.example.com:443\nEND\n";
    private static final String util_cred_ssl_server = "K 10\nascii_cert\nV 1616\nMIIEtzCCA5+gAwIBAgIQWGBOrapkezd+BWVsAtmtmTANBgkqhkiG9w0BAQsFADA8MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMVGhhd3RlLCBJbmMuMRYwFAYDVQQDEw1UaGF3dGUgU1NMIENBMB4XDTE0MDQxMTAwMDAwMFoXDTE2MDQwNzIzNTk1OVowgYsxCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhNYXJ5bGFuZDEUMBIGA1UEBxQLRm9yZXN0IEhpbGwxIzAhBgNVBAoUGkFwYWNoZSBTb2Z0d2FyZSBGb3VuZGF0aW9uMRcwFQYDVQQLFA5JbmZyYXN0cnVjdHVyZTEVMBMGA1UEAxQMKi5hcGFjaGUub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA+Tq4mH+stRoxe4xth8tUCgLt+P4LD/JWZz4a2IecaaAk57vIlTxEyP16fUShUfxVJnD0KV11zv2qaEUXNaA6hKd4H/oBu2OyGev+quRM+aFCjWqASkXt7fLGsIkHAwP3XwBVBpARbcXJeCjCBxqaYrQqS8LTwfPUD9eYncGlQ+ixb3Bosy7TmkWKeLsRdS90cAO/rdgQ8OI7kLT/1tr5GpF9RmXoRnVqMP+U0zGd/BNNSneg7emb7TxLzxeMKZ7QbF4MZi8RRN11spvx8/f92CiYrGGuy67VdOGPaomYc+VZ2syLwduHGK40ADrEK3+MQpsRFB0dM08j9bhpr5A44wIDAQABo4IBYzCCAV8wFwYDVR0RBBAwDoIMKi5hcGFjaGUub3JnMAkGA1UdEwQCMAAwQgYDVR0gBDswOTA3BgpghkgBhvhFAQc2MCkwJwYIKwYBBQUHAgEWG2h0dHBzOi8vd3d3LnRoYXd0ZS5jb20vY3BzLzAOBgNVHQ8BAf8EBAMCBaAwHwYDVR0jBBgwFoAUp6KDuzRFQD381TBPErk+oQGf9tswOgYDVR0fBDMwMTAvoC2gK4YpaHR0cDovL3N2ci1vdi1jcmwudGhhd3RlLmNvbS9UaGF3dGVPVi5jcmwwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMGkGCCsGAQUFBwEBBF0wWzAiBggrBgEFBQcwAYYWaHR0cDovL29jc3AudGhhd3RlLmNvbTA1BggrBgEFBQcwAoYpaHR0cDovL3N2ci1vdi1haWEudGhhd3RlLmNvbS9UaGF3dGVPVi5jZXIwDQYJKoZIhvcNAQELBQADggEBAF52BLvlx5or9/aO7+cPhxuPxwiNRgbvHdCakD7n8vzjNyct9fKp6/XxB6GQiTZ0nZPJOyIuPi1QDLKOXvaPeLKDBilL/+mrn/ev3s/aRQSrUsieKDoQnqtmlxEHc/T3+Ni/RZobPD4GzPuNKpK3BIc0fk/95T8R1DjBSQ5/clvkzOKtcl3VffAwnHiE9TZx9js7kZwOb9nOKX8DFao3EpQcS7qn63Ibzbq5A6ry8ZNRQSIJK/xlCAWoyUd1uxnqGFnus8wb9RVZJQe8YvyytBjgbE3QjnfPOxoEJA3twupnPmH+OCTM6V3TZqpRZj/sZ5rtIQ++hI5FdJWUWVSgnSw=\nK 8\nfailures\nV 1\n8\nK 15\nsvn:realmstring\nV 26\nhttps://svn.apache.org:443\nEND\n";
    private static final String util_cred_ssl_client_passphrase = "K 8\npasstype\nV 10\njavahltest\nK 10\npassphrase\nV 24\nsecret with spaces in it\nK 15\nsvn:realmstring\nV 27\nhttps://svn.example.com:443\nEND\n";

    public UtilTests() {
        this.init();
    }

    public UtilTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    private void writeFileContents(File file, String string) throws Throwable {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(this.fileContentsPrefix);
        fileOutputStream.write(string.getBytes());
        fileOutputStream.write(this.fileContentsSuffix);
        fileOutputStream.close();
    }

    public void testFileDiff() throws Throwable {
        File file = File.createTempFile("merge", ".original", this.localTmp);
        File file2 = File.createTempFile("merge", ".modified", this.localTmp);
        this.writeFileContents(file, "\noriginal\n\n");
        this.writeFileContents(file2, "\nmodified\n\n");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = SVNUtil.fileDiff(file.getAbsolutePath(), file2.getAbsolutePath(), null, "original", "modified", "UTF-8", null, byteArrayOutputStream);
        UtilTests.assertTrue((boolean)bl);
        byte[] byArray = ("--- original" + NL + "+++ modified" + NL + "@@ -3,7 +3,7 @@" + NL + " 3\n 4\n \n" + "-original\n" + "+modified\n" + " \n N-3\n N-2\n").getBytes();
        UtilTests.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    public void testFileMerge() throws Throwable {
        File file = File.createTempFile("merge", ".original", this.localTmp);
        File file2 = File.createTempFile("merge", ".modified", this.localTmp);
        File file3 = File.createTempFile("merge", ".latest", this.localTmp);
        this.writeFileContents(file, "\noriginal\n\n");
        this.writeFileContents(file2, "\nmodified\n\n");
        this.writeFileContents(file3, "\nlatest\n\n");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = SVNUtil.fileMerge(file.getAbsolutePath(), file2.getAbsolutePath(), file3.getAbsolutePath(), null, "||||||| base", "<<<<<<< branch", ">>>>>>> local", "=======", SVNUtil.ConflictDisplayStyle.modified_original_latest, byteArrayOutputStream);
        UtilTests.assertTrue((boolean)bl);
        byte[] byArray = "1\n2\n3\n4\n\n<<<<<<< branch\nmodified\n||||||| base\noriginal\n=======\nlatest\n>>>>>>> local\n\nN-3\nN-2\nN-1\nN\n".getBytes();
        UtilTests.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    public void testValidateProp() throws Throwable {
        File file = File.createTempFile("propcheck", ".file", this.localTmp);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write("normal text\n".getBytes());
        fileOutputStream.close();
        byte[] byArray = SVNUtil.canonicalizeNodeProperty("svn:eol-style", "  native".getBytes(), "propcheck.file", NodeKind.file, "text/plain");
        UtilTests.assertEquals((String)"native", (String)new String(byArray));
        byArray = SVNUtil.canonicalizeNodeProperty("svn:eol-style", " native  ".getBytes(), "propcheck.file", NodeKind.file, "text/plain", new FileInputStream(file));
        UtilTests.assertEquals((String)"native", (String)new String(byArray));
        boolean bl = false;
        try {
            byArray = SVNUtil.canonicalizeNodeProperty("svn:eol-style", " weird  ".getBytes(), "propcheck.file", NodeKind.file, "text/plain");
        }
        catch (ClientException clientException) {
            UtilTests.assertEquals((String)"Unrecognized line ending style", (String)clientException.getAllMessages().get(0).getMessage());
            bl = true;
        }
        UtilTests.assertTrue((boolean)bl);
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write("inconsistent\r\ntext\n".getBytes());
        fileOutputStream.close();
        bl = false;
        try {
            byArray = SVNUtil.canonicalizeNodeProperty("svn:eol-style", " native  ".getBytes(), "propcheck.file", NodeKind.file, "text/plain", new FileInputStream(file));
        }
        catch (ClientException clientException) {
            UtilTests.assertEquals((String)"Inconsistent line ending style", (String)clientException.getAllMessages().get(2).getMessage());
            bl = true;
        }
        UtilTests.assertTrue((boolean)bl);
    }

    private static void compare_item_lists(List<ExternalItem> list, List<ExternalItem> list2, String string) {
        int n = list.size();
        UtilTests.assertEquals((int)n, (int)list2.size());
        for (int i = 0; i < n; ++i) {
            UtilTests.assertTrue((String)("Items in " + string + " at index " + i + " differ"), (boolean)list.get(i).equals(list2.get(i)));
        }
    }

    public void testParseExternals() throws Throwable {
        List<ExternalItem> list = SVNUtil.parseExternals(externals_propval, "dirname", false);
        UtilTests.compare_item_lists(list, externals, "externals");
        list = SVNUtil.parseExternals(old_externals_propval, "dirname", false);
        UtilTests.compare_item_lists(list, old_externals, "old_externals");
    }

    public void testUnparseExternals() throws Throwable {
        byte[] byArray = SVNUtil.unparseExternals(externals, "dirname");
        UtilTests.assertTrue((boolean)Arrays.equals(externals_propval, byArray));
    }

    public void testUnparseExternalsOldstyle() throws Throwable {
        byte[] byArray = SVNUtil.unparseExternalsForAncientUnsupportedClients(old_externals, "dirname");
        UtilTests.assertTrue((boolean)Arrays.equals(old_externals_propval, byArray));
        boolean bl = false;
        try {
            byArray = SVNUtil.unparseExternalsForAncientUnsupportedClients(externals, "dirname");
        }
        catch (SubversionException subversionException) {
            bl = true;
        }
        UtilTests.assertTrue((boolean)bl);
    }

    public void testResolveExternalsUrl() throws Throwable {
        UtilTests.assertEquals((String)"http://a/b/c", (String)SVNUtil.resolveExternalsUrl(new ExternalItem("x", "http://a/b/c/", null, null), "http://a", "http://a/b"));
        UtilTests.assertEquals((String)"http://a/b/c", (String)SVNUtil.resolveExternalsUrl(new ExternalItem("x", "^/b/c", null, null), "http://a", "http://a/b"));
        UtilTests.assertEquals((String)"http://a/b/c", (String)SVNUtil.resolveExternalsUrl(new ExternalItem("x", "../b/c", null, null), "http://a", "http://a/b"));
        UtilTests.assertEquals((String)"http://a/b/c", (String)SVNUtil.resolveExternalsUrl(new ExternalItem("x", "/b/c", null, null), "http://a", "http://a/b"));
        UtilTests.assertEquals((String)"http://a/b/c", (String)SVNUtil.resolveExternalsUrl(new ExternalItem("x", "//a/b/c", null, null), "http://a", "http://a/b"));
    }

    public void testBuildKeywords() throws Throwable {
        byte[] byArray = "Id TEST=%H%_%b%_%u".getBytes();
        Map<String, byte[]> map = SVNUtil.buildKeywords(byArray, -1L, null, null, null, null);
        UtilTests.assertEquals((String)"   ", (String)new String(map.get("Id")));
        UtilTests.assertEquals((String)"     ", (String)new String(map.get("TEST")));
        map = SVNUtil.buildKeywords(byArray, 42L, "http://a/b/c", "http://a", new Date(1L), "X");
        UtilTests.assertEquals((String)"c 42 1970-01-01 00:00:00Z X", (String)new String(map.get("Id")));
        UtilTests.assertEquals((String)"b/c 42 1970-01-01 00:00:00Z X c http://a/b/c", (String)new String(map.get("TEST")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTranslateStream() throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream;
        int n;
        byte[] byArray = "Id TEST=%H%_%b%_%u".getBytes();
        byte[] byArray2 = "$Id$\n$TEST$\n".getBytes();
        byte[] byArray3 = "$Id: c 42 1970-01-01 00:00:00Z X $\r$TEST: b/c 42 1970-01-01 00:00:00Z X c http://a/b/c $\r".getBytes();
        Map<String, byte[]> map = SVNUtil.buildKeywords(byArray, 42L, "http://a/b/c", "http://a", new Date(1L), "X");
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        byte[] byArray4 = new byte[1024];
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), null);
        }
        Object object = null;
        try {
            object = SVNUtil.translateStream(new ByteArrayInputStream(byArray2), SVNUtil.EOL_CR, true, map, true);
            n = ((InputStream)object).read(byArray4);
            ((InputStream)object).close();
            object = null;
            UtilTests.assertEquals((String)"expand InputStream with concrete keywords", (String)new String(byArray3), (String)new String(byArray4, 0, n));
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
                object = null;
            }
        }
        try {
            object = SVNUtil.translateStream(new ByteArrayInputStream(byArray2), SVNUtil.EOL_CR, true, true, byArray, 42L, "http://a/b/c", "http://a", new Date(1L), "X");
            n = ((InputStream)object).read(byArray4);
            ((InputStream)object).close();
            object = null;
            UtilTests.assertEquals((String)"expand InputStream with implied keywords", (String)new String(byArray3), (String)new String(byArray4, 0, n));
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
                object = null;
            }
        }
        try {
            object = SVNUtil.translateStream(new ByteArrayInputStream(byArray3), SVNUtil.EOL_LF, true, hashMap, false);
            n = ((InputStream)object).read(byArray4);
            ((InputStream)object).close();
            object = null;
            UtilTests.assertEquals((String)"contract InputStream with concrete keywords", (String)new String(byArray2), (String)new String(byArray4, 0, n));
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
                object = null;
            }
        }
        try {
            object = SVNUtil.translateStream(new ByteArrayInputStream(byArray3), SVNUtil.EOL_LF, true, false, byArray, 0L, "", "", new Date(1L), "");
            n = ((InputStream)object).read(byArray4);
            ((InputStream)object).close();
            object = null;
            UtilTests.assertEquals((String)"contract InputStream with implied keywords", (String)new String(byArray2), (String)new String(byArray4, 0, n));
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
                object = null;
            }
        }
        OutputStream outputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = SVNUtil.translateStream(byteArrayOutputStream, SVNUtil.EOL_CR, true, map, true);
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            UtilTests.assertEquals((String)"expand OutputStream with concrete keywords", (String)new String(byArray3), (String)byteArrayOutputStream.toString());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = SVNUtil.translateStream(byteArrayOutputStream, SVNUtil.EOL_CR, true, true, byArray, 42L, "http://a/b/c", "http://a", new Date(1L), "X");
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            UtilTests.assertEquals((String)"expand OutputStream with implied keywords", (String)new String(byArray3), (String)byteArrayOutputStream.toString());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = SVNUtil.translateStream(byteArrayOutputStream, SVNUtil.EOL_LF, true, hashMap, false);
            outputStream.write(byArray3);
            outputStream.close();
            outputStream = null;
            UtilTests.assertEquals((String)"contract OutputStream with concrete keywords", (String)new String(byArray2), (String)byteArrayOutputStream.toString());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = SVNUtil.translateStream(byteArrayOutputStream, SVNUtil.EOL_LF, true, false, byArray, 0L, "", "", new Date(1L), "");
            outputStream.write(byArray3);
            outputStream.close();
            outputStream = null;
            UtilTests.assertEquals((String)"contract OutputStream with implied keywords", (String)new String(byArray2), (String)byteArrayOutputStream.toString());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
        }
    }

    private void initCredentials() throws Throwable {
        File file = new File(this.conf, "auth");
        if (file.exists()) {
            UtilTests.removeDirOrFile(file);
        }
        file.mkdirs();
        File file2 = new File(file, "svn.username");
        file2.mkdir();
        FileWriter fileWriter = new FileWriter(new File(file2, util_cred_hash));
        fileWriter.write(util_cred_username);
        fileWriter.close();
        file2 = new File(file, "svn.simple");
        file2.mkdir();
        fileWriter = new FileWriter(new File(file2, util_cred_hash));
        fileWriter.write(util_cred_simple);
        fileWriter.close();
        file2 = new File(file, "svn.ssl.server");
        file2.mkdir();
        fileWriter = new FileWriter(new File(file2, util_cred_hash));
        fileWriter.write(util_cred_ssl_server);
        fileWriter.close();
        file2 = new File(file, "svn.ssl.client-passphrase");
        file2.mkdir();
        fileWriter = new FileWriter(new File(file2, util_cred_hash));
        fileWriter.write(util_cred_ssl_client_passphrase);
        fileWriter.close();
    }

    public void testCredentials() throws Throwable {
        this.initCredentials();
        String string = this.conf.getAbsolutePath();
        SVNUtil.Credential credential = SVNUtil.getCredential(string, SVNUtil.Credential.Kind.username, "https://svn.example.com:443");
        UtilTests.assertNotNull((Object)credential);
        UtilTests.assertEquals((String)credential.getUsername(), (String)"mungo");
        credential = SVNUtil.getCredential(string, SVNUtil.Credential.Kind.simple, "https://svn.example.com:443");
        UtilTests.assertNotNull((Object)credential);
        UtilTests.assertEquals((String)credential.getUsername(), (String)"mungo");
        UtilTests.assertEquals((String)credential.getPassword(), (String)"secret");
        UtilTests.assertEquals((String)credential.getSecureStore(), (String)"javahltest");
        credential = SVNUtil.getCredential(string, SVNUtil.Credential.Kind.sslServer, "https://svn.apache.org:443");
        UtilTests.assertNotNull((Object)credential);
        UtilTests.assertEquals((String)credential.getServerCertInfo().getSubject(), (String)"C=US, ST=Maryland, L=Forest Hill, O=Apache Software Foundation, OU=Infrastructure, CN=*.apache.org");
        credential = SVNUtil.getCredential(string, SVNUtil.Credential.Kind.sslClientPassphrase, "https://svn.example.com:443");
        UtilTests.assertNotNull((Object)credential);
        UtilTests.assertEquals((String)credential.getClientCertPassphrase(), (String)"secret with spaces in it");
        UtilTests.assertEquals((String)credential.getSecureStore(), (String)"javahltest");
        List<SVNUtil.Credential> list = SVNUtil.searchCredentials(string, null, null, null, null, null);
        UtilTests.assertNull(list);
        list = SVNUtil.searchCredentials(string, SVNUtil.Credential.Kind.sslServer, null, null, null, "*java*");
        UtilTests.assertNull(list);
        list = SVNUtil.searchCredentials(string, null, null, "*java*", null, null);
        UtilTests.assertNull(list);
        list = SVNUtil.searchCredentials(string, SVNUtil.Credential.Kind.sslServer, "*", null, null, null);
        UtilTests.assertNotNull(list);
        UtilTests.assertEquals((int)list.size(), (int)1);
        list = SVNUtil.searchCredentials(string, null, null, null, null, "*java*");
        UtilTests.assertNotNull(list);
        UtilTests.assertEquals((int)list.size(), (int)2);
        list = SVNUtil.searchCredentials(string, null, null, "mungo", null, null);
        UtilTests.assertNotNull(list);
        UtilTests.assertEquals((int)list.size(), (int)2);
        list = SVNUtil.searchCredentials(string, null, null, null, "\\*.apache.org", null);
        UtilTests.assertNotNull(list);
        UtilTests.assertEquals((int)list.size(), (int)1);
        list = SVNUtil.searchCredentials(string, null, "*example*", null, null, null);
        UtilTests.assertNotNull(list);
        UtilTests.assertEquals((int)list.size(), (int)3);
    }

    static {
        try {
            externals = new ArrayList<ExternalItem>(25);
            externals.add(new ExternalItem("a", "http://server/repo/path", null, null));
            externals.add(new ExternalItem("b", "//server/repo/path", null, null));
            externals.add(new ExternalItem("c", "/repo/path", null, null));
            externals.add(new ExternalItem("d", "^/path", null, null));
            externals.add(new ExternalItem("e", "^/../oper/path", null, null));
            externals.add(new ExternalItem("f", "http://server/repo/path", Revision.getInstance(42L), null));
            externals.add(new ExternalItem("g", "//server/repo/path", Revision.getInstance(42L), null));
            externals.add(new ExternalItem("h", "/repo/path", Revision.getInstance(42L), null));
            externals.add(new ExternalItem("j", "^/path", Revision.getInstance(42L), null));
            externals.add(new ExternalItem("j", "^/../oper/path", Revision.getInstance(42L), null));
            externals.add(new ExternalItem("k", "http://server/repo/path", null, Revision.getInstance(42L)));
            externals.add(new ExternalItem("l", "//server/repo/path", null, Revision.getInstance(42L)));
            externals.add(new ExternalItem("m", "/repo/path", null, Revision.getInstance(42L)));
            externals.add(new ExternalItem("n", "^/path", null, Revision.getInstance(42L)));
            externals.add(new ExternalItem("o", "^/../oper/path", null, Revision.getInstance(42L)));
            externals.add(new ExternalItem("p", "http://server/repo/path", Revision.getInstance(69L), Revision.getInstance(71L)));
            externals.add(new ExternalItem("q", "//server/repo/path", Revision.getInstance(69L), Revision.getInstance(71L)));
            externals.add(new ExternalItem("r", "/repo/path", Revision.getInstance(69L), Revision.getInstance(71L)));
            externals.add(new ExternalItem("s", "^/path", Revision.getInstance(69L), Revision.getInstance(71L)));
            externals.add(new ExternalItem("t", "^/../oper/path", Revision.getInstance(69L), Revision.getInstance(71L)));
            externals.add(new ExternalItem("u", "http://server/repo/path", Revision.getInstance(42L), Revision.getInstance(42L)));
            externals.add(new ExternalItem("v", "//server/repo/path", Revision.getInstance(42L), Revision.getInstance(42L)));
            externals.add(new ExternalItem("w", "/repo/path", Revision.getInstance(42L), Revision.getInstance(42L)));
            externals.add(new ExternalItem("x", "^/path", Revision.getInstance(42L), Revision.getInstance(42L)));
            externals.add(new ExternalItem("y", "^/../oper/path", Revision.getInstance(42L), Revision.getInstance(42L)));
        }
        catch (SubversionException subversionException) {
            externals = null;
            throw new RuntimeException(subversionException);
        }
        externals_propval = "http://server/repo/path a\n//server/repo/path b\n/repo/path c\n^/path d\n^/../oper/path e\n-r42 http://server/repo/path f\n-r42 //server/repo/path g\n-r42 /repo/path h\n-r42 ^/path j\n-r42 ^/../oper/path j\nhttp://server/repo/path@42 k\n//server/repo/path@42 l\n/repo/path@42 m\n^/path@42 n\n^/../oper/path@42 o\n-r69 http://server/repo/path@71 p\n-r69 //server/repo/path@71 q\n-r69 /repo/path@71 r\n-r69 ^/path@71 s\n-r69 ^/../oper/path@71 t\nhttp://server/repo/path@42 u\n//server/repo/path@42 v\n/repo/path@42 w\n^/path@42 x\n^/../oper/path@42 y\n".getBytes();
        old_externals = null;
        try {
            old_externals = new ArrayList<ExternalItem>(3);
            old_externals.add(new ExternalItem("X", "http://server/repo/path", null, null));
            old_externals.add(new ExternalItem("Y", "http://server/repo/path", null, Revision.getInstance(42L)));
            old_externals.add(new ExternalItem("Z", "http://server/repo/path", null, Revision.getInstance(new Date(0L))));
        }
        catch (SubversionException subversionException) {
            old_externals = null;
            throw new RuntimeException(subversionException);
        }
        old_externals_propval = "X http://server/repo/path\nY -r42 http://server/repo/path\nZ -r{1970-01-01T00:00:00.000000Z} http://server/repo/path\n".getBytes();
    }
}

