unit OTFEConsts_U;

interface

uses
  SysUtils; // Required for exceptions

const
  OTFE_ERR_SUCCESS                   = $00; // No error
  OTFE_ERR_NOT_ACTIVE                = $01;
  OTFE_ERR_DRIVER_FAILURE            = $02;
  OTFE_ERR_USER_CANCEL               = $03;
  OTFE_ERR_WRONG_PASSWORD            = $04;
  OTFE_ERR_VOLUME_FILE_NOT_FOUND     = $05;
  OTFE_ERR_INVALID_DRIVE             = $06;
  OTFE_ERR_MOUNT_FAILURE             = $07; // Generic error; may be one of the other more specific ones
  OTFE_ERR_DISMOUNT_FAILURE          = $08; // Generic error; may be one of the other more specific ones
  OTFE_ERR_FILES_OPEN                = $09;
  OTFE_ERR_STREAMING_DATA            = $0A; // Similar to OTFE_ERR_FILES_OPEN, used with ScramDisk NT
  OTFE_ERR_FILE_NOT_ENCRYPTED_VOLUME = $0B;
  OTFE_ERR_UNABLE_TO_LOCATE_FILE     = $0C;
  OTFE_ERR_DISMOUNT_RECURSIVE        = $0D; // You've attempted to dismount a
                                            // volume that contains a volume
                                            // file that is currently mounted
  OTFE_ERR_INSUFFICENT_RIGHTS        = $0E; // You don't have sufficient rights
                                            // to perform the required operation
                                            // e.g. when using ScramDisk NT v3,
                                            // attempting to load the ScramDisk
                                            // driver with insufficient rights
  OTFE_ERR_NOT_W9X                   = $0F; // Operation not available under
                                            // Windows 95/98/Me
  OTFE_ERR_NOT_WNT                   = $10; // Operation not available under
                                            // Windows NT/2000
  OTFE_ERR_NO_FREE_DRIVE_LETTERS     = $11;

  // BestCrypt
  OTFE_ERR_UNKNOWN_ALGORITHM         = $20;
  OTFE_ERR_UNKNOWN_KEYGEN            = $21;

  // ScramDisk
  OTFE_ERR_UNABLE_MOUNT_COMPRESSED   = $30; // User tried to mount a volume
                                            // file that was compressed with
                                            // Windows NT/2000 compression

  // PANIC!
  OTFE_ERR_UNKNOWN_ERROR             = $FF;




  OTFE_EXCPT_NOT_ACTIVE = 'OTFE component not connected - set Active to TRUE first';
  OTFE_EXCPT_NOT_W9X = 'Operation not available under Windows 95/98/Me';
  OTFE_EXCPT_NOT_WNT = 'Operation not available under Windows NT/2000';

type
  EOTFEException = Exception;

implementation

END.


