use install_steps_interactive;
package install_steps_interactive;
log::l("PATCHING");


undef *generateAutoInstFloppy;
*generateAutoInstFloppy = sub($) {
    my ($o) = @_;

    $::expert || $::g_auto_install or return;

    my ($floppy) = detect_devices::floppies();

    $o->ask_yesorno('', 
"Do you want to generate an auto install floppy for linux replication?", $floppy) or return;

    $o->ask_warn('', _("Insert a blank floppy in drive %s", $floppy));

    my $dev = devices::make($floppy);

    my $image = $o->{pcmcia} ? "pcmcia" :
      ${{ hd => 'hd', cdrom => 'cdrom', ftp => 'network', nfs => 'network', http => 'network' }}{$o->{method}};

    {
	my $w = $o->wait_message('', _("Creating auto install floppy"));
	install_any::getAndSaveFile("$image.img", $dev) or log::l("failed to write $dev"), return;
    }
    fs::mount($dev, "/floppy", "vfat", 0);
    substInFile { s/timeout.*//; s/^(\s*append)/$1 kickstart=floppy/ } "/floppy/syslinux.cfg";

    unlink "/floppy/help.msg";
    output "/floppy/ks.cfg", install_any::generate_ks_cfg($o);
    output "/floppy/boot.msg", "\n0c",
"!! If you press enter, an auto-install is going to start.
   All data on this computer is going to be lost !!
", "07\n";

    local $o->{partitioning}{clearall} = 1;
    install_any::g_auto_install("/floppy/auto_inst.cfg");

    fs::umount("/floppy");
}
