#include <newt.h>
#include <popt.h>

#include "hints.h"
#include "intl.h"
#include "kickstart.h"
#include "lilo.h"

static void parseLilo(struct hints * hints) {
    char * location = NULL;
    int linear = 0;
    char ** argv;
    int argc, rc;
    poptContext optCon;
    struct poptOption ksOptions[] = {
	    { "append", '\0', POPT_ARG_STRING, &hints->bootloader.options, 0 },
#ifdef __i386__
	    { "linear", '\0', 0, &linear, 0 },
	    { "location", '\0', POPT_ARG_STRING, 
			&location, 0 },
#endif
	    { 0, 0, 0, 0, 0 }
    };

    hints->bootloader.options = NULL;

    if (!ksGetCommand(KS_CMD_LILO, NULL, &argc, &argv)) {
	optCon = poptGetContext(NULL, argc, argv, ksOptions, 0);

	if ((rc = poptGetNextOpt(optCon)) < -1) {
	    newtWinMessage(_("lilo command"),  _("Ok"),
		       _("bad argument to kickstart lilo command %s: %s"),
		       poptBadOption(optCon, POPT_BADOPTION_NOALIAS), 
		       poptStrerror(rc));
	}

	poptFreeContext(optCon);
    }

    hints->bootloader.flags = LILO_USE_OPTIONS;

    if (!location || !strcmp(location, "mbr"))
	hints->bootloader.flags |= LILO_ON_MBR;
    else if (!strcmp(location, "partition"))
	hints->bootloader.flags |= LILO_ON_PARTITION;
    else if (!strcmp(location, "none")) {
	hints->flags |= HINT_SKIPBOOTLOADER;
	return;
    }

    if (linear)
	hints->bootloader.flags |= LILO_USE_LINEAR;

    return;
}

void ksToHints(struct hints * hints) {
    char ** argv;
    int argc;

    parseLilo(hints);

    if (!ksGetCommand(KS_CMD_REBOOT, NULL, &argc, &argv)) {
	hints->flags |= HINT_REBOOT;
    }
}
