#ifndef H_HD
#define H_HD

#include "devices.h"

#define PART_EXT2	(1 << 0)
#define PART_SWAP	(1 << 1)
#define PART_DOS	(1 << 2)
#define PART_HPFS	(1 << 3)
#define PART_NFS	(1 << 4)
#define PART_FAT32	(1 << 5)
#define PART_UFS        (1 << 6)
#define PART_OTHER	(1 << 7)
#define PART_IGNORE	(1 << 8)
#define PART_HFS	(1 << 9)

struct partition {
    char device[20];
    int size;				/* in 1k blocks */
    unsigned int type;
    int begin;
    int end;
    char tagName[25];
    char * bootLabel;
    int defaultBoot;
} ;

struct partitionTable {
    struct partition * parts;
    int count;
};

int findAllPartitions(struct deviceInfo * devices, 
		      struct partitionTable * table);
int partitionDrives(void);
int getDriveList(char *** drives, int * num);
void needReboot(void);

extern char *default_boot_hd;

#endif
