#include <fcntl.h>
#include <newt.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <zlib.h>

#include "cpio.h"
#include "log.h"
#include "install.h"

int installCpioFile(FD_t fd, char * cpioName, char * outName, int inWin) {
    struct cpioFileMapping map;
    int rc;
    char * failedFile;
    CFD_t cfdbuf, *cfd = &cfdbuf;

    if (outName) {
	map.archivePath = cpioName;
	map.fsPath = outName;
	map.mapFlags = CPIO_MAP_PATH;
    }

    cfd->cpioIoType = cpioIoTypeGzFd;
    cfd->cpioGzFd = gzdFdopen(fdDup(fdFileno(fd)), "r");
    
    rc = cpioInstallArchive(cfd, outName ? &map : NULL, 1, NULL, NULL, 
			    &failedFile);
    gzdClose(cfd->cpioGzFd);

    if (rc || access(outName, R_OK)) {
	if (rc) {
	    if (inWin)
		newtWinMessage("Error", "Ok",
			       "Cannot find archive member %s: %s\n", 
			       cpioName, cpioStrerror(rc));
	    else
		logMessage("Cannot find archive member %s: %s\n", cpioName, cpioStrerror(rc));
	} else {
	    if (inWin)
		newtWinMessage("Error", "Ok",
			       "Cannot find archive member %s: File does not "
			       "exist in archive\n",cpioName);
	    else
		logMessage("Cannot find archive member %s: file does not exist in archive\n", cpioName);
	}
	return INST_ERROR;
    }

    return 0;
}
