// Mandrake Autorun.exe for Windows
// Copyright  2003
//
// This Programm is free software, you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation
//
// This programm is WITHOUT ANY WARRANTY
// You can get a copy of the GPL from:
// Free Software Foundation, Inc, 59 Temple Place, Suite 330
// Boston, MA 02111-1307 USA



unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,  shellapi, Buttons, ComCtrls, jpeg, IniFiles, Registry,
  ExtCtrls, HashAlgMD5_U, HashAlg_U, dd;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton13Click(Sender: TObject);
    procedure SpeedButton14Click(Sender: TObject);
    procedure Label1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label1Click(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label7Click(Sender: TObject);
    procedure Label8Click(Sender: TObject);
    procedure Label9Click(Sender: TObject);
    procedure Label10Click(Sender: TObject);
    procedure Label11Click(Sender: TObject);
    procedure Label12Click(Sender: TObject);
    procedure Label2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label3MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label4MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label5MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label6MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label8MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label9MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label10MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label11MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label12MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label7MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  private

  { Private-Deklarationen}

  public

  { Public-Deklarationen}

  Buffer : array[0..MAX_PATH] of char;
  PathDoc1 : string;
  PathDoc2 : string;
  Request_To_Insert_3RD_CD : string;
  MandrakeEdition: string;
  MessageBeforeReboot: string;
  end;

var
  Form1: TForm1;

implementation

uses Unit2, Unit3, Unit4, Unit5;



{$R *.DFM}
// Get Button Captions from autorun.conf
function SetLanguage(lang : string) : boolean;
var
caption : string;
AppIni: TIniFile;
begin
  caption:=lang;
  if FileExists('dosutils\lang\autorun.conf') then
  AppIni := TIniFile.Create('dosutils\lang\autorun.conf')
  else if FileExists('lang\autorun.conf')  then
  AppIni := TIniFile.Create('lang\autorun.conf')
  else
  begin
  ShowMessage('Config file not found, please make sure there is a autorun.conf in Drive:\dosutils\lang directory');
  exit;
  end;
  Form1.Label1.Caption  := AppIni.ReadString(caption,'Button1', 'Missing Entry');
  Form1.Label2.Caption  := AppIni.ReadString(caption,'Button2', 'Missing Entry');
  Form1.Label3.Caption  := AppIni.ReadString(caption,'Button3', 'Missing Entry');
  Form1.Label4.Caption  := AppIni.ReadString(caption,'Button4', 'Missing Entry');
  Form1.Label5.Caption  := AppIni.ReadString(caption,'Button5', 'Missing Entry');
  Form1.Label6.Caption  := AppIni.ReadString(caption,'Button6', 'Missing Entry');
  Form1.Label7.Caption  := AppIni.ReadString(caption,'Button7', 'Missing Entry');
  Form1.Label8.Caption  := AppIni.ReadString(caption,'Button8', 'Missing Entry');
  Form1.Label9.Caption  := AppIni.ReadString(caption,'Button9', 'Missing Entry');
  Form1.Label10.Caption := AppIni.ReadString(caption,'Button10', 'Missing Entry');
  Form1.Label11.Caption := AppIni.ReadString(caption,'Button11', 'Missing Entry');
  Form1.Label12.Caption := AppIni.ReadString(caption,'Button12', 'Missing Entry');
  Form1.Request_To_Insert_3RD_CD:=AppIni.ReadString(caption,'Request_To_Insert_3RD_CD', 'Insert CD 3 and press OK');
  Form1.MessageBeforeReboot := AppIni.ReadString(caption,'Message_Before_Reboot', 'Missing Entry');
  AppIni.Free;
end;


procedure TForm1.Label10Click(Sender: TObject);
begin
// Set German Language
SetLanguage('German');
end;

procedure TForm1.Label11Click(Sender: TObject);
begin
// Set Spanish Language
SetLanguage('Spanish');
end;

procedure TForm1.Label12Click(Sender: TObject);
begin
// Set Italian Language
SetLanguage('Italian');

end;

procedure TForm1.Label9Click(Sender: TObject);
begin
// Set French Language
SetLanguage('French');
end;


procedure TForm1.FormCreate(Sender: TObject);
var
Title : string;
CurrentPath : String;
AppIni: TIniFile;
begin
   // Open autorun.conf
  if FileExists('dosutils\lang\autorun.conf') then
  AppIni := TIniFile.Create('dosutils\lang\autorun.conf')
  else if FileExists('lang\autorun.conf')  then
  AppIni := TIniFile.Create('lang\autorun.conf')
  else
  begin
  ShowMessage('Config file not found, please make sure there is a autorun.conf in Drive:\dosutils\lang directory');
  exit;
  end;

   // Set Forms Label
  Title:= '  ' + AppIni.ReadString('Options','Title', 'Mandrake');
  Form1.Caption := Title;

  // Get current Drivelabel
  CurrentPath:=paramstr(0);

  // Complete Path to documentation
  PathDoc1:=CurrentPath[1] + ':' + AppIni.ReadString ('Options', 'LinkDocButton3', 'Error in config');
  PathDoc2:=CurrentPath[1] + ':' + AppIni.ReadString ('Options', 'LinkDocButton6', 'Error in config');

  {Get Locale Setting, this feature will come later again
  GetLocaleInfo(LOCALE_SYSTEM_DEFAULT, LOCALE_SLANGUAGE or LOCALE_NOUSEROVERRIDE, Buffer, SizeOf(Buffer)); }

  // MandrakeEdition = 1 --> DVD  MandrakeEdition = 0 --> NO DVD
  MandrakeEdition:= AppIni.ReadString('Options','DVD-Edition', 'Mandrake');

  // Load English language
  SetLanguage('English');

  AppIni.Free;

end;

procedure TForm1.SpeedButton13Click(Sender: TObject);
begin
 ShowMessage(PathDoc1);
 ShowMessage(PathDoc2);
 //ShowMessage(Buffer);
 ShowMessage('Contact Linux-phased: linux-phased@mandrakesoft.com in case of problems');

end;

procedure TForm1.SpeedButton14Click(Sender: TObject);
var myHash : THashAlgMD5;
hash : THashArray;
begin
myHash:=THashAlgMD5.create(self);
myHash.HashFile('d:\test.img', hash);
showmessage(myHash.HashToDisplay(hash));
//ShowMessage('This feature will come later');
end;

procedure TForm1.Label1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label1.Font.Color:=clYellow;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label1.Font.Color:=clwhite;
Label2.Font.Color:=clwhite;
Label3.Font.Color:=clwhite;
Label4.Font.Color:=clwhite;
Label5.Font.Color:=clwhite;
Label6.Font.Color:=clwhite;
Label7.Font.Color:=clwhite;
Label8.Font.Color:=clwhite;
Label9.Font.Color:=clwhite;
Label10.Font.Color:=clwhite;
Label11.Font.Color:=clwhite;
Label12.Font.Color:=clwhite

end;

procedure TForm1.Label1Click(Sender: TObject);
begin
Form5.show;
Form5.Label1.Caption := MessageBeforeReboot;

end;

procedure TForm1.Label2Click(Sender: TObject);
begin
if FileExists('dosutils\rawwritewin.exe') then
 ShellExecute(Application.MainForm.handle, nil, Pchar('dosutils\rawwritewin.exe'),nil , nil, sw_shownormal);
if FileExists('rawwritewin.exe') then
 ShellExecute(Application.MainForm.handle, nil, Pchar('rawwritewin.exe'),nil , nil, sw_shownormal);
end;

procedure TForm1.Label3Click(Sender: TObject);
var
check : integer;
begin
check:=StrToInt(MandrakeEdition);
if check = 1 then
begin
ShellExecute(Application.MainForm.handle, nil, Pchar(PathDoc1),nil , nil, sw_shownormal);
end
else
Form2.show;
Form2.Label1.Caption :=Request_To_Insert_3RD_CD;
end;

procedure TForm1.Label4Click(Sender: TObject);
begin
ShellExecute(Application.MainForm.handle, nil, Pchar('http://www.mandrakestore.com'),nil , nil, sw_shownormal);
end;

procedure TForm1.Label5Click(Sender: TObject);
begin
ShellExecute(Application.MainForm.handle, nil, Pchar('http://www.mandrakeexpert.com'),nil , nil, sw_shownormal);
end;

procedure TForm1.Label6Click(Sender: TObject);
var
check : integer;
begin
check:=StrToInt(MandrakeEdition);
if check=1 then
begin
ShellExecute(Application.MainForm.handle, nil, Pchar(PathDoc2),nil , nil, sw_shownormal);
end
else
Form3.show;
Form3.Label1.Caption :=Request_To_Insert_3RD_CD;
end;

procedure TForm1.Label7Click(Sender: TObject);
begin
Form1.close;
end;

procedure TForm1.Label8Click(Sender: TObject);

begin
// Language English
SetLanguage('English');
end;

procedure TForm1.Label2MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label2.Font.Color:=clYellow;
end;

procedure TForm1.Label3MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label3.Font.Color:=clYellow;
end;

procedure TForm1.Label4MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label4.Font.Color:=clYellow;
end;

procedure TForm1.Label5MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label5.Font.Color:=clYellow;
end;

procedure TForm1.Label6MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label6.Font.Color:=clYellow;
end;

procedure TForm1.Label8MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label8.Font.Color:=clYellow;
end;

procedure TForm1.Label9MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label9.Font.Color:=clYellow;
end;

procedure TForm1.Label10MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label10.Font.Color:=clYellow;
end;

procedure TForm1.Label11MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label11.Font.Color:=clYellow;
end;

procedure TForm1.Label12MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label12.Font.Color:=clYellow;
end;

procedure TForm1.Label7MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
Label7.Font.Color:=clblue;
end;

function GetDrive(path:String):String;
var i:integer;
begin
GetDrive:=copy(path,0,2);
end;




procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Hash:THashArray;
myHash : THashAlgMD5;
begin
if (ssLeft in Shift) and (ssCtrl in Shift) and (ssShift in Shift) then
  begin
    myHash:=THashAlgMD5.Create(nil);
    generateMD5('\\.\'+GetDrive(Application.ExeName),hash);
    showmessage('Your MD5SUM is ' + myHash.HashToDisplay(hash));
    myHash.Destroy();
  end;
end;

end.
