/* speedup.c
 * Speed up IDE drives by doing an equivalent to
 * hdparm -c1 -d1 -m16 -A1
 *
 * (c) 1999 by Bernhard Rosenkrnzer <bero@mandrakesoft.com>
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/hdreg.h>
#include <linux/kdev_t.h>

/* devices:
	hda = 3,0
	hdb = 3,64
	hdc = 22,0
	hdd = 22,64
	hde = 33,0
	hdf = 33,64
	hdg = 34,0
	hdh = 34,64
*/
/*
   This is equivalent to calling
   hdparm -c1 -m16 -d1 -A1 
   on all disks...
*/

void speeddisks()
{
	int fd;
	const char *devname="/tmphdd";
	static dev_t disks[] = { makedev(3,0), makedev(3,64), makedev(22,0), makedev(22,64),
				 makedev(33,0), makedev(33,64), makedev(34,0), makedev(34,64), 0};
	unsigned short disk;
	unsigned char lookahead[4] = { WIN_SETFEATURES, 0, 0, 0 };
	int i=0;
	
	lookahead[2]=0xaa;
	unlink(devname);
	for(disk = disks[0] ; disk != 0 ; disk=disks[++i]) {
		mknod(devname, 0666 | S_IFBLK, disk);

		fd = open (devname, O_RDONLY | O_NONBLOCK);
		if (fd < 0)
			continue;

		if(ioctl(fd, HDIO_DRIVE_CMD, NULL)==0) {
			// HDIO_DRIVE_CMD, NULL = wait for completion.
			// if it fails, there's probably no disk, so we
			// don't go on.
			ioctl(fd, HDIO_SET_32BIT, 1);
			ioctl(fd, HDIO_DRIVE_CMD, NULL);
			ioctl(fd, HDIO_SET_MULTCOUNT, 16);
			ioctl(fd, HDIO_DRIVE_CMD, NULL);
			ioctl(fd, HDIO_SET_DMA, 1);
			ioctl(fd, HDIO_DRIVE_CMD, NULL);
			ioctl(fd, HDIO_DRIVE_CMD, &lookahead);
			ioctl(fd, HDIO_DRIVE_CMD, NULL);
		}
		close(fd);
		unlink(devname);
	}
}
