/*
 *  smbmount.c
 *
 *  Copyright (C) 1995, 1996 by Paal-Kr. Engstad and Volker Lendecke
 *
 *  Hacked by msf@redhat.com
 *
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/types.h>
/* #include <sys/wait.h> */  /* generates a warning here */
extern pid_t waitpid(pid_t, int *, int);
#include <sys/errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <mntent.h>
#include <newt.h>

#include "log.h"
#include "intl.h"
#include "install.h"
#include "dns.h"
#include "smb_mount.h"

#ifndef MS_MGC_VAL
#define MS_MGC_VAL 0xC0ED0000
#endif

#define SMB_PORT 139

int smbGetSetup(char ** finalHostptr, char ** finalDirptr, 
		char ** finalAcctptr, char ** finalPwptr) {
    char * host = *finalHostptr;
    char * dir = *finalDirptr;
    char * acct = *finalAcctptr;
    char * pass = *finalPwptr;
    int result;
    struct newtWinEntry entries[] = {
	{ NULL, &host, NEWT_ENTRY_SCROLL },
	{ NULL, &dir, NEWT_ENTRY_SCROLL },
	{ NULL, &acct, NEWT_ENTRY_SCROLL },
	{ NULL, &pass, NEWT_ENTRY_SCROLL },
	{ NULL, NULL, 0 } };

    entries[0].text = _("SMB server name  :");
    entries[1].text = _("Share volume     :");
    entries[2].text = _("Account name     :");
    entries[3].text = _("Password         :");

    result = newtWinEntries(_("SMB Setup"), 
		_("Please enter the following information:\n"
		  "\n"
		  "    o the name or IP number of your SMB server\n"
		  "    o the volume to share which contains\n"
		  "      Linux Mandrake for your architecture"),
		50, 5, 5, 24, entries, _("Ok"), _("Cancel"), NULL);

    if (result == 2) {
        free(host);
        free(dir);
        free(acct);
        free(pass);
	
	return INST_CANCEL;
    }

    if (*finalHostptr) free(*finalHostptr);
    if (*finalDirptr) free(*finalDirptr);
    if (*finalAcctptr) free(*finalAcctptr);
    if (*finalPwptr) free(*finalPwptr);

    *finalHostptr = host;
    *finalDirptr = dir;
    *finalAcctptr = acct;
    *finalPwptr = pass;

    return 0;
}


/****************************************
 Mount smb filesystem


   server is name of SMB server - should NOT have domain name, etc 
                                  as this is a NetBIOS name. For
                                  machines running samba, is normally
                                  the same as the hostname (sans domain)

   share is the name of the SMB share we are trying to mount

   user is the user to login as on SMB server.

   password is corresponding password.

   client is the NetBIOS name of machine attempting the mount. Just
                 strip the hostname of domain to get this.

   mount_point - self explanatory

Way I'd do this - look at printtool (new one of course) and add a SMB printer.
                  Ask for stuff just like I do.

End of docs 
*****************************************/

int 
smbmount(char *server, char *share, char *user, char *password, char *client, char *mount_point)
{
        struct smb_mount_data data;
	char hostname[MAXHOSTNAMELEN + 1];
	char share_name[256];
	
        int um;
	unsigned int flags;

	/*        
	struct stat st;
	unsigned int flags;
	*/

	memset(&data, 0, sizeof(struct smb_mount_data));

	memset(hostname, '\0', MAXHOSTNAMELEN+1);
	gethostname(hostname, MAXHOSTNAMELEN);

	data.version = SMB_MOUNT_VERSION;

        data.mounted_uid = getuid();

        data.uid = getuid();
        data.gid = getgid();
        um = umask(0);
        umask(um);
        data.file_mode = (S_IRWXU|S_IRWXG|S_IRWXO) & ~um;
        data.dir_mode  = 0;

        if (data.dir_mode == 0) {
                data.dir_mode = data.file_mode;
                if ((data.dir_mode & S_IRUSR) != 0)
                        data.dir_mode |= S_IXUSR;
                if ((data.dir_mode & S_IRGRP) != 0)
                        data.dir_mode |= S_IXGRP;
                if ((data.dir_mode & S_IROTH) != 0)
                        data.dir_mode |= S_IXOTH;
        }

	snprintf(share_name, sizeof(share_name), "\\\\%s\\%s", server, share);

	flags = MS_MGC_VAL;

	if (mount(share_name, mount_point, "smbfs", flags, (char *)&data) < 0)
	{
		logMessage("smb mount error: %s", strerror(errno));
		return -1;
	}

	return 0;
}	
