#ifndef PCI_PROBE_H
#define PCI_PROBE_H


/* these are the types of devices we can probe */
enum pciClass {PCI_ETHERNET, PCI_SCSI, PCI_VIDEO, PCI_OTHER, PCI_AUDIO, PCI_UNSET};

/* these define's define what the kernel message is for each class */
#define CLASS_ETHERNET    "Ethernet controller"
#define CLASS_NETWORK     "Network controller"
#define CLASS_SCSI        "SCSI storage controller"
#define CLASS_VIDEO       "VGA compatible"
#define CLASS_VIDEO_OTHER "Display controller"
#define CLASS_AUDIO	  "Multimedia audio controller"
#define CLASS_NONE        "Non-VGA device"
#define CLASS_MASS_STORAGE "mass storage controller"

struct pciDevice {
    enum pciClass      class;      /* type */
    int                nhits;      /* number of matches in vendor/dev id db */
    char              **name;      /* array of names of PCI cards - malloc! */
    char            **module;      /* array of modules to try - malloc! */
};

void pciFreeDevice( struct pciDevice *p );
int pciProbeDevice(enum pciClass type, struct pciDevice ***devs);

#endif
