#include <stdio.h>

#include "fs.h"
#include "windows.h"
#include "install.h"
#include "smp.h"

int writeMiloConf(char *prefix, struct fstab fstab, char *kernelVersion)
{
    char filename[100];
    char *rootdev;
    int i;
    int issmp;
    FILE *f;
    static int firsttime = 1;
    char part;

    if (firsttime) {
	rename("/mnt/etc/milo.conf", "/mnt/etc/milo.conf.rpmsave");
	rename("/mnt/etc/aboot.conf", "/mnt/etc/aboot.conf.rpmsave");
    }
    
    for (i = 0; i < fstab.numEntries; i++) {
	if (!strcmp(fstab.entries[i].mntpoint, "/")) break;
    }

    rootdev = fstab.entries[i].device;

    sprintf(filename, "%s/etc/milo.conf", prefix);
    
    f = fopen(filename, "w");
    if (!f) {
	errorWindow("cannot create milo config file: %s");
	return INST_ERROR;
    }
    if ((issmp = detectSMP()) == 1) {
	fprintf(f, "image=/boot/vmlinuz-%ssmp\n", kernelVersion);
	fprintf(f, "\tlabel=linux\n");
	fprintf(f, "\troot=/dev/%s\n", rootdev);
    }
    fprintf(f, "image=/boot/vmlinuz-%s\n", kernelVersion);
    if (issmp)
	fprintf(f, "\tlabel=linux-up\n");
    else
	fprintf(f, "\tlabel=linux\n");
    fprintf(f, "\troot=/dev/%s\n", rootdev);

    fclose(f);

    /* now for the aboot.conf */
    sprintf(filename, "%s/etc/aboot.conf", prefix);

    i = 0;
    part = rootdev[strlen(rootdev) - 1];
    f = fopen(filename, "w");
    if (detectSMP() == 1) {
	fprintf(f, "%d:%c/boot/vmlinuz-%ssmp root=/dev/%s\n",
		i++, part, kernelVersion, rootdev);
    }
    fprintf(f, "%d:%c/boot/vmlinuz-%s root=/dev/%s\n",
	    i, part, kernelVersion, rootdev);

    fclose(f);
    
    firsttime = 0;

    return INST_OKAY;
}
