#define NULL 0

#define open lib_open
#define ioctl lib_ioctl
#define __KERNEL__
#define __LIBRARY__
#define	_STRING_H
#include <sys/un.h>
#include <sys/types.h>
#include <sys/syscall.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#undef __KERNEL__
#undef __LIBRARY__
#undef open
#undef ioctl
#include <linux/net.h>
#include <stdarg.h>

char ** _environ = NULL;
int errno = 0;

#ifdef __alpha__

#define __NR_getpid __NR_getxpid

#else

_syscall2(int,socketcall,int,code,unsigned long *, args)

#endif

#ifdef __sparc__
/* Nonstandard fork calling convention :( */
int fork(void) {
  int __res;
  __asm__ __volatile__ (
    "mov %0, %%g1\n\t"
    "t 0x10\n\t"
    "bcc 1f\n\t"
    "dec %%o1\n\t"
    "sethi %%hi(%2), %%g1\n\t"
    "st %%o0, [%%g1 + %%lo(%2)]\n\t"
    "b 2f\n\t"
    "mov -1, %0\n\t"
    "1:\n\t"
    "and %%o0, %%o1, %0\n\t"
    "2:\n\t"
    : "=r" (__res)
    : "0" (__NR_fork), "i" (&errno)
    : "g1", "o0", "cc");
  return __res;
}
#else
_syscall0(int,fork)
#endif

#ifdef __i386__
#undef __NR_select
#define __NR_select __NR__newselect
#endif

_syscall0(pid_t,setsid)
_syscall0(int,sync)
_syscall0(int,getpid)
_syscall1(int,close,int,fd)
_syscall1(int,umount,const char *,dir)
_syscall1(int,swapoff,const char *,file)
_syscall2(int,dup2,int,one,int,two)
_syscall2(int,chmod,const char * ,path,mode_t,mode)
_syscall2(int,sethostname,const char *,name,int,len)
_syscall2(int,setdomainname,const char *,name,int,len)
_syscall2(int,kill,pid_t,pid,int,sig)
_syscall3(int,write,int,fd,const char *,buf,unsigned long,count)
_syscall3(int,open,const char *,fn,int,flags,mode_t,mode)
_syscall3(int,syslog,int,type,char*,bufp,int,len);
_syscall3(int,read,int,fd,const char *,buf,unsigned long,count)
_syscall3(int,ioctl,int,fd,int,request,void *,argp)
_syscall3(int,reboot,int,magic,int,magic_too,int,flag)
_syscall3(int,execve,const char *,fn,void *,argv,void *,envp)
_syscall4(int,wait4,pid_t,pid,int *,status,int,opts,void *,rusage)
_syscall5(int,select,int,n,fd_set *,rd,fd_set *,wr,fd_set *,ex,struct timeval *,timeval);
_syscall5(int,mount,const char *,spec,const char *,dir,const char *,type,unsigned long,rwflag,const void *,data);

void exit() {}
void _fini() {}
void _init() {}
void __libc_init_first() {}
int atexit (void (*__func) (void)) { return 0; }

int __libc_start_main (int (*main) (int, char **, char **), int argc,
                   char **argv, void (*init) (void), void (*fini) (void),
                   void (*rtld_fini) (void), void *stack_end)
{
    main(argc, argv, NULL);
    return 0;
}


#ifndef __alpha__

inline int socket(int a, int b, int c) {
    unsigned long args[] = { a, b, c };

    return socketcall(SYS_SOCKET, args);
}

inline int bind(int a, void * b, int c) {
    unsigned long args[] = { a, (long) b, c };

    return socketcall(SYS_BIND, args);
}

inline int listen(int a, int b) {
    unsigned long args[] = { a, b, 0 };

    return socketcall(SYS_LISTEN, args);
}

inline int accept(int a, void * addr, void * addr2) {
    unsigned long args[] = { a, (long) addr, (long) addr2 };

    return socketcall(SYS_ACCEPT, args);
}
#else

_syscall3(int,socket,int,domain,int,type,int,protocol)
_syscall3(int,bind,int,sockfd,void *,my_addr,int,addrlen)
_syscall2(int,listen,int,s,int,backlog)
_syscall3(int,accept,int,s,void *,addr,int *,addrlen)

#endif

size_t strlen(const char * string) {
    int i = 0;

    while (*string++) i++;

    return i;
}

char * strncpy(char * dst, const char * src, size_t len) {
    char * chptr = dst;
    int i = 0;

    while (*src && i < len) *dst++ = *src++, i++;
    if (i < len) *dst = '\0';

    return chptr;
}

char * strcpy(char * dst, const char * src) {
    char * chptr = dst;

    while (*src) *dst++ = *src++;
    *dst = '\0';

    return chptr;
}

void * memcpy(void * dst, const void * src, size_t count) {
    char * a = dst;
    const char * b = src;

    while (count--)
	*a++ = *b++;

    return dst;
}

void sleep(int secs) {
    struct timeval tv;

    tv.tv_sec = secs;
    tv.tv_usec = 0;

    select(0, NULL, NULL, NULL, &tv);
}

int strcmp(const char * a, const char * b) {
    int i, j;  

    i = strlen(a); j = strlen(b);
    if (i < j)
	return -1;
    else if (j < i)
	return 1;

    while (*a && (*a == *b)) a++, b++;

    if (!*a) return 0;

    if (*a < *b)
	return -1;
    else
	return 1;
}

int strncmp(const char * a, const char * b, size_t len) {
    char buf1[1000], buf2[1000];

    strncpy(buf1, a, len);
    strncpy(buf2, b, len);
    buf1[len] = '\0';
    buf2[len] = '\0';

    return strcmp(buf1, buf2);
}

void printstr(char *string) { write(1, string, strlen(string)); }

void printint(int i) {
    char buf[10];
    char * chptr = buf + 9;
    int j = 0;

    if (i < 0) {
        printstr("-");
        i = -1 * i;
    }

    while (i) {
	*chptr-- = '0' + (i % 10);
	j++;
	i = i / 10;
    }

    write(1, chptr + 1, j);
}

char * strchr(const char * str, int ch) {
    const char * chptr;

    chptr = str;
    while (*chptr) {
	if (*chptr == ch) return (char*)chptr;
	chptr++;
    }

    return NULL;
}

void printf(char * fmt, ...) {
    char buf[2048];
    char * start = buf;
    char * chptr = buf;
    va_list args;
    char * strarg;
    int numarg;

    strcpy(buf, fmt);
    va_start(args, fmt);

    while (start) {
	while (*chptr != '%' && *chptr) chptr++;

	if (*chptr == '%') {
	    *chptr++ = '\0';
	    printstr(start);

	    switch (*chptr++) {
	      case 's': 
		strarg = va_arg(args, char *);
		printstr(strarg);
		break;

	      case 'd':
		numarg = va_arg(args, int);
		printint(numarg);
		break;
	    }

	    start = chptr;
	} else {
	    printstr(start);
	    start = NULL;
	}
    }
}
