unit FileList_U;
// Description: Main Unit, Dialog
// By Sarah Dean
//
// -----------------------------------------------------------------------------
// Version history:
// 2.1.0 - 8th July 1999
//        Initial release
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TFileList_F = class(TForm)
    pbOK: TButton;
    lblTitle: TLabel;
    pnlPlaceholder: TPanel;
    lbFiles: TListBox;
    reReport: TRichEdit;
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FileList_F: TFileList_F;

implementation

{$R *.DFM}

uses SDUGeneral;


procedure TFileList_F.FormShow(Sender: TObject);
var
  i: integer;
begin
  pnlPlaceholder.BevelOuter := bvNone;
  lbFiles.align := alClient;
  reReport.align := alClient;

  for i:=0 to (lbFiles.items.count-1) do
    begin
    lbFiles.items[i] := SDUConvertSFNToLFN(lbFiles.items[i]);
    end;

end;

END.

