print '
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <gtk/gtk.h>

typedef GtkWidget *DrakXGtk__Widget;

/*################################################################################*/
GdkWindow *gtkroot(void) {
  gtk_init(NULL,NULL); /* just in case */
  gdk_window_foreign_new(GDK_ROOT_WINDOW());
}

void my_text_set(GtkWidget *self, const char *val) {
  GtkText *text = (GtkText *) self;
  gtk_text_freeze(text);
  gtk_text_backward_delete(text, gtk_text_get_length(text));
  gtk_text_insert(text, NULL, NULL, NULL, val, g_strlen(val)); /* TODO?: needs \n otherwise in case of one line text the beginning is not shown (even with the vadj->set_value) */
  gtk_text_set_word_wrap(text, 1);
  gtk_text_thaw(text);
}


void generic_handler(GtkObject *object, gpointer data, guint nparams, GtkArg *args) {
  dSP;
  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  PUTBACK;
  perl_call_sv(*av_fetch((AV *) data, 0, 0), G_SCALAR);

  FREETMPS;
  LEAVE;
}

void marshal_signal(GtkObject *object, gpointer data, guint nparams, GtkArg *args, GtkType *arg_types, GtkType return_type) {
  AV *perlargs = (AV*)data;
  SV *perlhandler = *av_fetch(perlargs, 0, 0);
  gint event_type = SvIV(*av_fetch(perlargs, 1, 0));
  
  dSP;
  ENTER;
  SAVETMPS;

{ int i; for (i = 0; i < nparams; i++) {
   printf(">> %d %d\n", i, args[i].type);
   if (args[i].type == 38926) {
      GdkEventKey *p = GTK_VALUE_POINTER(args[i]);
       printf(">>>> pointer %p\n", p);
      if (p) printf(">>>>> keyval is %d\n", p->keyval);
  }
}}

  printf("marshal_signal %d %d\n", perlhandler, event_type);

  PUSHMARK(sp);
  PUTBACK;

  perl_call_sv(perlhandler, G_SCALAR);

/*  
  SPAGAIN;
  PUTBACK;
*/
  FREETMPS;
  LEAVE;
}


void destroy_handler(gpointer data) { 
  printf("destroy_handler\n");
  SvREFCNT_dec((AV*)data); 
}


/*################################################################################*/
MODULE = DrakXGtk::DrakXGtk	PACKAGE = DrakXGtk::DrakXGtk		PREFIX = gtk_

void
init()
  CODE:
  gtk_init(NULL, NULL);
  gtk_signal_set_funcs(marshal_signal, destroy_handler);

void
gtk_main()

void
gtk_main_quit()

void
gtk_timeout_remove(tag)
  int tag

void
flush()
  CODE:
  while (gtk_events_pending()) gtk_main_iteration();

void
set_mousecursor()
  CODE:
  gdk_window_set_cursor(gtkroot(), gdk_cursor_new(GDK_LEFT_PTR));

void
set_background(r, g, b)
  int r
  int g
  int b
  CODE:
{
  GdkWindow *root = gtkroot();
  GdkGC *gc = gdk_gc_new(root);
  GdkColor color;
  gint h, w;

  color.red   = r;
  color.green = g;
  color.blue  = b;  

  gdk_color_alloc(gdk_window_get_colormap(root), &color);
  gdk_gc_set_foreground(gc, &color);
  gdk_window_set_background(root, &color);

  gdk_window_get_size(root, &w, &h);
  gdk_draw_rectangle(root, gc, 1, 0, 0, w, h);
}

int
timeout_add(interval, handler)
  int interval
  SV *handler
  CODE:
{
  AV *args = newAV();
  RETVAL = gtk_timeout_add_full(interval, 0, generic_handler, (gpointer)args, destroy_handler);

  /* create list (handler) */
  av_push(args, newSVsv(handler));
}
  OUTPUT:
  RETVAL


################################################################################
# Miscellaneous widgets

DrakXGtk::Widget
window_new(title)
  char *title
  CODE:
  RETVAL = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title((GtkWindow *) RETVAL, title);
  OUTPUT:
  RETVAL

DrakXGtk::Widget
button_new(label=0)
  char *label
  CODE:
  RETVAL = label ? gtk_button_new_with_label(label) : gtk_button_new();
  OUTPUT:
  RETVAL

DrakXGtk::Widget
gtk_label_new(label)
  char *label

DrakXGtk::Widget
gtk_hseparator_new()

DrakXGtk::Widget
gtk_notebook_new()

DrakXGtk::Widget
gtk_vbox_new(homogeneous, spacing)
  int homogeneous
  int spacing

DrakXGtk::Widget
gtk_hbox_new(homogeneous, spacing)
  int homogeneous
  int spacing

DrakXGtk::Widget
text_new(text)
  char *text
  CODE:
  RETVAL = gtk_text_new(NULL, NULL);
  my_text_set(RETVAL, text);
  OUTPUT:
  RETVAL

DrakXGtk::Widget
vbutton_box_new()
  CODE:
  RETVAL = gtk_vbutton_box_new();
  gtk_button_box_set_layout((GtkButtonBox *) RETVAL, GTK_BUTTONBOX_SPREAD);
  OUTPUT:
  RETVAL

DrakXGtk::Widget
hbutton_box_new()
  CODE:
  RETVAL = gtk_hbutton_box_new();
  gtk_button_box_set_layout((GtkButtonBox *) RETVAL, GTK_BUTTONBOX_SPREAD);
  OUTPUT:
  RETVAL

DrakXGtk::Widget
frame_new(label)
  char *label
  CODE:
  RETVAL = gtk_frame_new(label && label[0] ? label : NULL);
  OUTPUT:
  RETVAL

DrakXGtk::Widget
gtk_clist_new(columns)
  int columns

DrakXGtk::Widget
scrolled_window_new(widget)
  DrakXGtk::Widget widget
  CODE:
  RETVAL = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy((GtkScrolledWindow *) RETVAL, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  if (GTK_IS_CONTAINER(widget))
    gtk_container_add((GtkContainer *) RETVAL, widget);
  else
    gtk_scrolled_window_add_with_viewport((GtkScrolledWindow *) RETVAL, widget);

################################################################################
# file_selection
DrakXGtk::Widget
gtk_file_selection_new(title)
  char *title

void
hide_fileop_buttons(self)
  DrakXGtk::Widget self
  CODE:
  gtk_file_selection_hide_fileop_buttons((GtkFileSelection *) self);

################################################################################
MODULE = DrakXGtk::DrakXGtk	PACKAGE = DrakXGtk::DrakXGtk::Widget	PREFIX = gtk_

void
gtk_grab_remove(self)
  DrakXGtk::Widget self

void
gtk_grab_add(self)
  DrakXGtk::Widget self

void
clist_append(self, val)
  DrakXGtk::Widget self
  char *val
  CODE:
  char *vals[] = { val, NULL };
  gtk_clist_append((GtkCList *) self, vals);

void
clist_super_select_row(self, row)
  DrakXGtk::Widget self
  int row
  CODE:
  GtkCList *w = (GtkCList *) self;
  w->focus_row = row;
  gtk_clist_select_row(w, row, 0);
  gtk_clist_moveto(w, row, 0, 0.5, 0);

void
add(self, widget, ...)
  DrakXGtk::Widget self
  DrakXGtk::Widget widget	
  CODE:
  int i;
  for(i = 1; i < items; i++) 
     gtk_container_add((GtkContainer *) self, (GtkWidget *) SvIV((SV*)SvRV(ST(i))));

void
pack_start(self, widget, expand)
  DrakXGtk::Widget self
  DrakXGtk::Widget widget	
  int expand
  CODE:
  gtk_box_pack_start((GtkBox *) self, widget, expand, 1, 0);

void
set_selection_mode(self, mode)
  DrakXGtk::Widget self
  int mode
  CODE:
  if (GTK_IS_CLIST(self)) gtk_clist_set_selection_mode((GtkCList *) self, mode);

void
set_column_auto_resize(self, column, auto_resize)
  DrakXGtk::Widget self
  int column
  int auto_resize
  CODE:
  gtk_clist_set_column_auto_resize((GtkCList *) self, column, auto_resize);

void
set(self, val)
  DrakXGtk::Widget self
  char *val
  CODE:
  my_text_set(self, val);

void
signal_connect(self, event, handler)
  DrakXGtk::Widget self
  char *event
  SV *handler
  CODE:
{
  guint type = gtk_signal_lookup(event, GTK_WIDGET_TYPE(self));

  AV *args = newAV();
  int i = gtk_signal_connect(GTK_OBJECT(self), event, NULL, (void*)args);

  /* create list (handler, event_num) */
  av_push(args, newSVsv(handler));
  av_push(args, newSViv(type));
}


################################################################################
MODULE = DrakXGtk::DrakXGtk	PACKAGE = DrakXGtk::DrakXGtk::Widget	PREFIX = gtk_widget_

void
gtk_widget_show(self)
  DrakXGtk::Widget self

void
gtk_widget_show_all(self)
  DrakXGtk::Widget self

void
gtk_widget_destroy(self)
  DrakXGtk::Widget self
  CODE:
  printf("destroying %p\n", self);
  gtk_widget_destroy(self);

void
gtk_widget_grab_focus(self)
  DrakXGtk::Widget self

void
gtk_widget_set_usize(self, width, height)
  DrakXGtk::Widget self
  int width
  int height

void
gtk_widget_set_name(self, name)
  DrakXGtk::Widget self
  char *name

';

my %struct_access = (
  FILE_SELECTION => ["DrakXGtk::Widget", "ok_button", "DrakXGtk::Widget", "cancel_button" ],
  BIN => ["DrakXGtk::Widget", "child" ],
);

while (my ($i_type, $v) = each %struct_access) {
  while (@$v) {
    my $o_type  = shift @$v;
    my $field = shift @$v;
    print qq{
$o_type
$field(self)
  DrakXGtk::Widget self
  CODE:
  if (!GTK_IS_$i_type(self)) croak("self must be of type %s", "$i_type");
  RETVAL = GTK_$i_type(self)->$field;
  OUTPUT:
  RETVAL

};
  }
}
