#!/usr/bin/perl

use strict;

undef $/;
my $f = <STDIN>;

my @anim = qw(94, 113);

my ($width, $height, $nbcolors) = unpack "x18 V V x20 V", $f;

my $s = $nbcolors * 4;
my ($palette, $image) = unpack "x54 a$s a*", $f;
my @palette = unpack("C3x" x $nbcolors, $palette);

for (my $i = 0; $i < 3 * $nbcolors; $i += 3) {
    ($palette[$i], $palette[$i + 2]) = ($palette[$i + 2], $palette[$i]);
}

print "\x0e\x04";
print pack "v v C C" . "C3" x $nbcolors . "C" x @anim, $width, $height, $nbcolors, int @anim, @palette, @anim;
#print pack "v v v" . "C3" x $nbcolors, $width, $height, $nbcolors, @palette, @anim;

my $width_ = 4 * int (($width + 3) / 4);
my ($oldv, $nb);
my $v = vec $image, 0, 8;
print pack "C", $v;
for (my $i = 0; $i < $height; $i++) { for (my $j = 0; $j < $width; $j++) {
    
    my $v = vec $image, ($height - $i - 1) * $width_ + $j, 8;
    $v >= 128 and die;
#    print pack "C", $v; next;

    if ($v == $oldv) {
	if ($nb - 1 < 128) {
	    $nb++;
	} else {
	    print pack "C", 0xFF;
	    $nb = 1;
	}
    } else {
	if ($nb > 128 && $nb % 129 == 2) {
	    print pack "CC", 0xFF, $v;
	} elsif ($nb > 1) {
	    print pack "C", (0x80 | ($nb - 2));
	} elsif ($nb == 1) {
	    print pack "C", $oldv;
	}
	print pack "C", $v;
	$oldv = $v;
	$nb = 0
    }
}
}
#if ($nb > 1) {
#    print pack "C", (0x80 | ($nb - 2));
#} elsif ($nb == 1) {
#    print pack "C", $oldv;
#}


1;
