#ifndef H_METHOD
#define H_METHOD

#include "hd.h"
#include "fs.h"
#include "net.h"

struct installMethod {
    char * name;
    char * abbrev;
    int rmFiles;
    enum { LOCAL, NETWORK } type;
    int (*prepareImage)(struct installMethod * method, struct netInfo * netc,
		        struct intfInfo * intf,
			struct driversLoaded ** dl);
    int (*prepareRoot)(struct installMethod * method, 
		       struct partitionTable table, struct netInfo * netc,
		       struct intfInfo * intf, struct driversLoaded ** dl);
    int (*getFile)(struct installMethod * method, char * name, 
			char ** realName);
    int (*prepareMedia)(struct installMethod * method, struct fstab * fstab);
    void * data;		/* isn't saved between early and late */
};

struct hdinfo {
    char * device;
    char * type;
    char * dir;
};

int chooseInstallMethod(int isHd, int isCdrom, int isNfs, int isFtp,
			struct installMethod ** method, 
			struct netInfo * netc, struct intfInfo * intf, 
			struct driversLoaded ** dl);
struct installMethod * findInstallMethod(char * argptr);
#endif
