#ifndef H_MTAB
#define H_MTAB

#include "hd.h"
#include "net.h"
#include "newt.h"

struct fstabEntry {
    char * device;		/* malloced! */
    char * netHost;		/* malloced! */
    char * netPath;		/* malloced! */
    char * mntpoint;		/* malloced! */
    char * tagName;
    int size;
    unsigned int type;
    int isMounted;
    int doFormat;
}; 

struct fstab {
    struct fstabEntry * entries;
    int numEntries;
};

struct nfsMountCallbackInfo {
    newtComponent server, mntpoint, netpath;
    char * serverVal, * netpathVal, * mntpointVal;
} ;
void nfsMountCallback(newtComponent co, void * arg);

char * nstrdup(const char * foo);
int queryFormatFilesystems(struct fstab * fstab);
int formatFilesystems(struct fstab * fstab);
int mountFilesystems(struct fstab * fstab);
int editNetMountPoint(struct fstabEntry * item);
int doMount(char * dev, char * where, char * fs, int rdonly, int istty);
int doPwMount(char * dev, char * where, char * fs, int rdonly, int istty,
		char * acct, char * pw);
int umountFilesystems(struct fstab * fstab);
int writeFstab(struct fstab * fstab);
int readMountTable(struct partitionTable table, struct fstab * finalFstab);
int  addFstabEntry(struct fstab * fstab, struct fstabEntry entry);
void initFstabEntry(struct fstabEntry * e);
void freeFstabEntry(struct fstabEntry * e);
void freeFstab(struct fstab fstab);
void fstabSort(struct fstab * fstab);
struct fstab copyFstab(struct fstab * fstab);
void addPartitionListbox(struct partitionTable table, int maxHeight, int type, 
			 int (*filter)(struct partition * part),
			 int * numItems, newtGrid * gridPtr, 
			 newtComponent * listboxPtr);

#endif
