
#define PCI_REVISION_ID         0x08    /* Revision ID */

struct pci_module_map {
	unsigned short	vendor;     /* PCI vendor id */
	unsigned short	device;     /* PCI device id */
	const char      *name;      /* PCI human readable name */
	const char      *module;    /* module to load */
};


struct pci_module_map eth_pci_ids[] = {
	{0x125b  , 0x1400  , ( "ASIX|AX88140" ), ( "tulip" )} ,
	{0x1385  , 0x620a  , ( "Netgear|GA620" ), ( "acenic" )} ,
	{0x10ec  , 0x8029  , ( "Realtek|RTL-8029(AS)" ), ( "ne2k-pci" )} ,
	{0x1317  , 0x0981  , ( "ADMtek|AN981 Comet" ), ( "tulip" )} ,
	{0x11f6  , 0x0112  , ( "Compex|ENet100VG4" ), ( "hp100" )} ,
	{0x10b7  , 0x9800  , ( "3Com Corporation|3c980-TX [Fast Etherlink XL Server Adapter]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9805  , ( "3Com Corporation|3c980-TX [Fast Etherlink XL Server Adapter]" ), ( "3c90x" )} ,
	{0x10a9  , 0x0009  , ( "Silicon Graphics|Alteon Gigabit Ethernet" ), ( "acenic" )} ,
	{0x108d  , 0x0012  , ( "Olicom|OC-2325" ), ( "tlan" )} ,
	{0x108d  , 0x0013  , ( "Olicom|OC-2183/2185" ), ( "tlan" )} ,
	{0x108d  , 0x0014  , ( "Olicom|OC-2326" ), ( "tlan" )} ,
	{0x0e11  , 0xb011  , ( "Compaq|Integrated Netelligent 10/100" ), ( "tlan" )} ,
	{0x0e11  , 0xb012  , ( "Compaq|Netelligent 10 T/2" ), ( "tlan" )} ,
	{0x0e11  , 0xb030  , ( "Compaq|Netelligent WS 5100" ), ( "tlan" )} ,
	{0x0e11  , 0xf150  , ( "Compaq|NetFlex-3/P ThunderLAN 2.3" ), ( "tlan" )} ,
	{0x1106  , 0x0926  , ( "VIA Technologies|VT82C926 [Amazon]" ), ( "ne2k-pci" )} ,
	{0x1259  , 0x2560  , ( "Allied Telesyn International|AT-2560 Fast Ethernet Adapter (i82557B)" ), ( "eepro100" )} ,
	{0x11f6  , 0x2201  , ( "Compex|ReadyLink 100TX (Winbond W89C840)" ), ( "ne2k-pci" )} ,
	{0x1282  , 0x9100  , ( "Davicom|DM9100" ), ( "dmfe" )} ,
	{0x1050  , 0x0000  , ( "Winbond Electronics Corp|NE2000" ), ( "ne2k-pci" )} ,
	{0x1282  , 0x9102  , ( "Davicom|Ethernet 100/10 MBit DM9102" ), ( "dmfe" )} ,
	{0x10b8  , 0x0005  , ( "Standard Microsystems Corp [SMC]|83C170QF" ), ( "epic100" )} ,
	{0x10b8  , 0x0006  , ( "Standard Microsystems Corp [SMC]|LANEPIC" ), ( "epic100" )} ,
	{0x10bd  , 0x0e34  , ( "Surecom Technology|NE-34PCI LAN" ), ( "ne2k-pci" )} ,
	{0x10b7  , 0x7646  , ( "3Com Corporation|3cSOHO100-TX [Hurricane]" ), ( "3c59x" )} ,
	{0x10c3  , 0x1100  , ( "Samsung Semiconductors, Inc.|Smartether100 SC1100 LAN Adapter (i82557B)" ), ( "eepro100" )} ,
	{0x11f6  , 0x1401  , ( "Compex|ReadyLink 2000" ), ( "ne2k-pci" )} ,
	{0x10b7  , 0x9000  , ( "3Com Corporation|3c900 10BaseT [Boomerang]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9001  , ( "3Com Corporation|3c900 Combo [Boomerang]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9004  , ( "3Com Corporation|3c900B-TPO [Etherlink XL TPO]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9005  , ( "3Com Corporation|3c900B-Combo [Etherlink XL Combo]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9006  , ( "3Com Corporation|3c900B-TPC [Etherlink XL TPC]" ), ( "3c59x" )} ,
	{0x10b7  , 0x900a  , ( "3Com Corporation|3c900B-FL [Etherlink XL FL]" ), ( "3c59x" )} ,
	{0x103c  , 0x1030  , ( "HP|J2585A" ), ( "hp100" )} ,
	{0x103c  , 0x1031  , ( "HP|J2585B" ), ( "hp100" )} ,
	{0x1186  , 0x0100  , ( "D-Link System Inc|DC21041" ), ( "tulip" )} ,
	{0x10b7  , 0x9050  , ( "3Com Corporation|3c905 100BaseTX [Boomerang]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9051  , ( "3Com Corporation|3c905 100BaseT4" ), ( "3c59x" )} ,
	{0x12ae  , 0x0001  , ( "Alteon Networks Inc.|AceNIC Gigabit Ethernet" ), ( "acenic" )} ,
	{0x10b7  , 0x9055  , ( "3Com Corporation|3c905B 100BaseTX [Cyclone]" ), ( "3c59x" )} ,
	{0x10b7  , 0x9058  , ( "3Com Corporation|3c905B-Combo [Deluxe Etherlink XL 10/100]" ), ( "3c59x" )} ,
	{0x10b7  , 0x905a  , ( "3Com Corporation|3c905B-FX [Fast Etherlink XL FX 10/100]" ), ( "3c59x" )} ,
	{0x8e2e  , 0x3000  , ( "KTI|ET32P2" ), ( "ne2k-pci" )} ,
	{0x10b7  , 0x5900  , ( "3Com Corporation|3c590 10BaseT [Vortex]" ), ( "3c59x" )} ,
	{0x8086  , 0x1227  , ( "Intel Corporation|82865 [Ether Express Pro 100]" ), ( "eepro100" )} ,
	{0x8086  , 0x1228  , ( "Intel Corporation|82556 [Ether Express Pro 100 Smart]" ), ( "eepro100" )} ,
	{0x8086  , 0x1229  , ( "Intel Corporation|82557 [Ethernet Pro 100]" ), ( "eepro100" )} ,
	{0x1148  , 0x4300  , ( "Syskonnect (Schneider & Koch)|Gigabit Ethernet" ), ( "sk98lin" )} ,
	{0x8086  , 0x5200  , ( "Intel Corporation|EtherExpress PRO/100" ), ( "eepro100" )} ,
	{0x8086  , 0x5201  , ( "Intel Corporation|EtherExpress PRO/100" ), ( "eepro100" )} ,
	{0x1266  , 0x0001  , ( "Microdyne Corporation|NE10/100 Adapter (i82557B)" ), ( "eepro100" )} ,
	{0x1050  , 0x0940  , ( "Winbond Electronics Corp|W89C940" ), ( "ne2k-pci" )} ,
	{0x1039  , 0x7016  , ( "Silicon Integrated Systems [SiS]|SiS900 10/100 Ethernet" ), ( "sis900" )} ,
	{0x11f6  , 0x9881  , ( "Compex|RL100TX" ), ( "tulip" )} ,
	{0x4a14  , 0x5000  , ( "NetVin|NV5000SC" ), ( "ne2k-pci" )} ,
	{0x1000  , 0x0701  , ( "Symbios|83C885 gigabit ethernet" ), ( "yellowfin" )} ,
	{0x11ad  , 0x0002  , ( "Lite-On|LNE100TX" ), ( "tulip" )} ,
	{0x1000  , 0x0702  , ( "Symbios|Yellowfin G-NIC gigabit ethernet" ), ( "yellowfin" )} ,
	{0x1106  , 0x3043  , ( "VIA Technologies|VT86C100A [Rhine 10/100]" ), ( "via-rhine" )} ,
	{0x1022  , 0x2000  , ( "Advanced Micro Devices [AMD]|79c970 [PCnet LANCE]" ), ( "pcnet32" )} ,
	{0x1022  , 0x2001  , ( "Advanced Micro Devices [AMD]|79c978 [HomePNA]" ), ( "pcnet32" )} ,
	{0x10b7  , 0x9200  , ( "3Com Corporation|3c905C-TX [Fast Etherlink]" ), ( "3c59x" )} ,
	{0x10b7  , 0x5950  , ( "3Com Corporation|3c595 100BaseTX [Vortex]" ), ( "3c59x" )} ,
	{0x10b7  , 0x5951  , ( "3Com Corporation|3c595 100BaseT4 [Vortex]" ), ( "3c59x" )} ,
	{0x1148  , 0x4200  , ( "Syskonnect (Schneider & Koch)|Token ring adaptor" ), ( "sktr" )} ,
	{0x10b7  , 0x5952  , ( "3Com Corporation|3c595 100Base-MII [Vortex]" ), ( "3c59x" )} ,
	{0x101a  , 0x0005  , ( "AT&T GIS (NCR)|100VG ethernet" ), ( "hp100" )} ,
	{0x1014  , 0x003e  , ( "IBM|16/4 Token ring UTP/STP controller" ), ( "olympic" )} ,
	{0x11ad  , 0xc115  , ( "Lite-On|LC82C115 PNIC-II" ), ( "tulip" )} ,
	{0x1039  , 0x0900  , ( "Silicon Integrated Systems [SiS]|SiS900 10/100 Ethernet" ), ( "sis900" )} ,
	{0x1186  , 0x1100  , ( "D-Link Inc|Fast Ethernet Adapter" ), ( "tulip" )} ,
	{0x1014  , 0x005c  , ( "IBM|i82557B 10/100 PCI Ethernet Adapter" ), ( "eepro100" )} ,
	{0x1106  , 0x6100  , ( "VIA Technologies|VT85C100A [Rhine II]" ), ( "via-rhine" )} ,
	{0x0e11  , 0xae32  , ( "Compaq|Netelligent 10/100" ), ( "tlan" )} ,
	{0x0e11  , 0xae34  , ( "Compaq|Netelligent 10" ), ( "tlan" )} ,
	{0x0e11  , 0xae35  , ( "Compaq|Integrated NetFlex-3/P" ), ( "tlan" )} ,
	{0x0e11  , 0xae40  , ( "Compaq|Netelligent 10/100 Dual" ), ( "tlan" )} ,
	{0x0e11  , 0xae43  , ( "Compaq|ProLiant Integrated Netelligent 10/100" ), ( "tlan" )} ,
	{0x114f  , 0x0003  , ( "Digi International|RightSwitch SE-6" ), ( "dgrs" )} ,
	{0x10ec  , 0x8129  , ( "Realtek|RTL-8129" ), ( "rtl8139" )} ,
	{0x10d9  , 0x0512  , ( "Macronix, Inc. [MXIC]|MX98713" ), ( "tulip" )} ,
	{0x10ec  , 0x8138  , ( "Realtek|RT8139 (B/C) Cardbus Fast Ethernet Adapter" ), ( "rtl8139" )} ,
	{0x10ec  , 0x8139  , ( "Realtek|RTL-8139" ), ( "rtl8139" )} ,
	{0x1011  , 0x0002  , ( "DEC|DECchip 21040 [Tulip]" ), ( "de4x5" )} ,
	{0x1011  , 0x0009  , ( "DEC|DECchip 21140 [FasterNet]" ), ( "old_tulip" )} ,
	{0x1011  , 0x0014  , ( "DEC|DECchip 21041 [Tulip Pass 3]" ), ( "de4x5" )} ,
	{0x0e11  , 0xf130  , ( "Compaq|NetFlex-3/P ThunderLAN 1.0" ), ( "tlan" )} ,
	{0x10d9  , 0x0531  , ( "Macronix, Inc. [MXIC]|MX987x5" ), ( "tulip" )} ,
	{0x1011  , 0x0019  , ( "DEC|DECchip 21142/43" ), ( "de4x5" )} ,
	{0x1011  , 0x001a  , ( "Farallon|PN9000SX" ), ( "acenic" )} ,
	{0x10b7  , 0x0001  , ( "3Com Corporation|3c985 1000BaseSX" ), ( "acenic" )} ,
	{0x1113  , 0x1211  , ( "Accton|SMC2-1211TX" ), ( "rtl8139" )} ,
	{0x8086  , 0x0039  , ( "Intel Corporation|21145" ), ( "tulip" )} ,
	{0x0e11  , 0x0508  , ( "Compaq|Netelligent 4/16 Token Ring" ), ( "sktr" )} ,

};
int eth_num_ids=sizeof(eth_pci_ids)/sizeof(struct pci_module_map);

struct pci_module_map audio_pci_ids[] = {

};
int audio_num_ids=sizeof(audio_pci_ids)/sizeof(struct pci_module_map);

struct pci_module_map scsi_pci_ids[] = {
	{0x9004  , 0x7778  , ( "Adaptec|AIC-787x" ), ( "aic7xxx" )} ,
	{0x1101  , 0x9400  , ( "Initio Corporation|INI-940" ), ( "initio" )} ,
	{0x1101  , 0x9401  , ( "Initio Corporation|INI-950" ), ( "initio" )} ,
	{0x9004  , 0x8578  , ( "Adaptec|AHA-3944U / AHA-3944UWD / 7885" ), ( "aic7xxx" )} ,
	{0x9004  , 0x8178  , ( "Adaptec|AIC-7881U" ), ( "aic7xxx" )} ,
	{0x9004  , 0x8878  , ( "Adaptec|7888" ), ( "aic7xxx" )} ,
	{0x1077  , 0x2100  , ( "Q Logic|ISP2100" ), ( "qlogicfc" )} ,
	{0x9004  , 0x6378  , ( "Adaptec|AIC-7860" ), ( "aic7xxx" )} ,
	{0x1191  , 0x8002  , ( "Artop Electronic Corp|AEC6710 SCSI-2 Host Adapter" ), ( "atp870u" )} ,
	{0x1d44  , 0xa400  , ( "DPT|PM2x24/PM3224" ), ( "eata" )} ,
	{0x1191  , 0x8010  , ( "Artop Electronic Corp|AEC6712UW SCSI" ), ( "atp870u" )} ,
	{0x1191  , 0x8020  , ( "Artop Electronic Corp|AEC6712U SCSI" ), ( "atp870u" )} ,
	{0x9004  , 0x6678  , ( "Adaptec|AIC-786" ), ( "aic7xxx" )} ,
	{0x1101  , 0x1060  , ( "Initio Corporation|INI-A100U2W" ), ( "initio" )} ,
	{0x1101  , 0x134a  , ( "Initio Corporation|Ultra SCSI Adapter" ), ( "initio" )} ,
	{0x9004  , 0x7078  , ( "Adaptec|AHA-294x / AIC-7870" ), ( "aic7xxx" )} ,
	{0x134a  , 0x0001  , ( "DTC Technology Corp.|Domex 536" ), ( "dtc" )} ,
	{0x134a  , 0x0002  , ( "DTC Technology Corp.|Domex DMX3194UP SCSI Adapter" ), ( "dtc" )} ,
	{0x1101  , 0x9700  , ( "Initio Corp|Fast Wide SCSI Controller" ), ( "initio" )} ,
	{0x9004  , 0x5575  , ( "Adaptec|AVA-2930" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5578  , ( "Adaptec|AIC-7855" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7378  , ( "Adaptec|AHA-3985 / AIC-7873" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7678  , ( "Adaptec|AHA-4944W/UW / 7876" ), ( "aic7xxx" )} ,
	{0x9004  , 0x1078  , ( "Adaptec|AIC-7810" ), ( "aic7xxx" )} ,
	{0x9004  , 0x8478  , ( "Adaptec|AHA-294x / AIC-7884U" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5475  , ( "Adaptec|AIC-2930" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5478  , ( "Adaptec|AIC-7850" ), ( "aic7xxx" )} ,
	{0x1191  , 0x8030  , ( "Artop Electronic Corp|AEC6712S SCSI" ), ( "atp870u" )} ,
	{0x1119  , 0x0210  , ( "ICP Vortex|GDT 6x19RD" ), ( "gdth" )} ,
	{0x1119  , 0x0211  , ( "ICP Vortex|GDT 6x29RD" ), ( "gdth" )} ,
	{0x9004  , 0x6278  , ( "Adaptec|AIC-7860" ), ( "aic7xxx" )} ,
	{0x1191  , 0x8040  , ( "Artop Electronic Corp|AEC6712D SCSI" ), ( "atp870u" )} ,
	{0x9004  , 0x7810  , ( "Adaptec|AIC-7810" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7815  , ( "Adaptec|AIC-7815 RAID+Memory Controller IC" ), ( "aic7xxx" )} ,
	{0x1191  , 0x8050  , ( "Artop Electronic Corp|AEC6712SUW SCSI" ), ( "atp870u" )} ,
	{0x9004  , 0x3860  , ( "Adaptec|AHA-2930CU" ), ( "aic7xxx" )} ,
	{0x104b  , 0x8130  , ( "BusLogic|Flashpoint LT" ), ( "BusLogic" )} ,
	{0x1119  , 0x0260  , ( "ICP Vortex|GDT 7x19RN" ), ( "gdth" )} ,
	{0x1119  , 0x0261  , ( "ICP Vortex|GDT 7x29RN" ), ( "gdth" )} ,
	{0x1077  , 0x1020  , ( "Q Logic|ISP1020" ), ( "qlogicisp" )} ,
	{0x9004  , 0x8778  , ( "Adaptec|AIC-788x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x2178  , ( "Adaptec|AIC-7821" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5175  , ( "Adaptec|AIC-755x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5178  , ( "Adaptec|AIC-7851" ), ( "aic7xxx" )} ,
	{0x1077  , 0x1022  , ( "Q Logic|ISP1022" ), ( "qlogicisp" )} ,
	{0x9004  , 0xec78  , ( "Adaptec|AHA-4944W/UW" ), ( "aic7xxx" )} ,
	{0x1036  , 0x0000  , ( "Future Domain|TMC-18C30 [36C70]" ), ( "fdomain" )} ,
	{0x10cd  , 0x1300  , ( "Advanced System Products|ABP940-U / ABP960-U" ), ( "advansys" )} ,
	{0x1044  , 0xa400  , ( "Distributed Tech|SmartCache/Raid I-IV Controller" ), ( "eata" )} ,
	{0x9005  , 0x0010  , ( "Adaptec|AHA-2940U2/W" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0011  , ( "Adaptec|2930U2" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0013  , ( "Adaptec|78902" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7278  , ( "Adaptec|AHA-3940 / AIC-7872" ), ( "aic7xxx" )} ,
	{0x9005  , 0x001f  , ( "Adaptec|AHA-2940U2/W / 7890" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0020  , ( "Adaptec|AIC-7890" ), ( "aic7xxx" )} ,
	{0x9004  , 0x8078  , ( "Adaptec|AIC-7880U" ), ( "aic7xxx" )} ,
	{0x9005  , 0x002f  , ( "Adaptec|AIC-7890" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0030  , ( "Adaptec|AIC-7890" ), ( "aic7xxx" )} ,
	{0x9005  , 0x003f  , ( "Adaptec|AIC-7890" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5075  , ( "Adaptec|AIC-755x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5078  , ( "Adaptec|AHA-7850" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5775  , ( "Adaptec|AIC-755x" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0050  , ( "Adaptec|3940U2" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0051  , ( "Adaptec|3950U2D" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0053  , ( "Adaptec|AIC-7896 SCSI Controller" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5778  , ( "Adaptec|AIC-7850" ), ( "aic7xxx" )} ,
	{0x9005  , 0x005f  , ( "Adaptec|7896" ), ( "aic7xxx" )} ,
	{0x1119  , 0x0100  , ( "ICP Vortex|GDT 6117RP/6517RP" ), ( "gdth" )} ,
	{0x1119  , 0x0101  , ( "ICP Vortex|GDT 6127RP/6527RP" ), ( "gdth" )} ,
	{0x9004  , 0x6578  , ( "Adaptec|AIC-786x" ), ( "aic7xxx" )} ,
	{0x8086  , 0x1960  , ( "Intel Corporation|80960RP [i960RP Microprocessor]" ), ( "megaraid" )} ,
	{0x1119  , 0x0102  , ( "ICP Vortex|GDT 6537RP" ), ( "gdth" )} ,
	{0x1119  , 0x0103  , ( "ICP Vortex|GDT 6557RP" ), ( "gdth" )} ,
	{0x1119  , 0x0104  , ( "ICP Vortex|GDT 6111RP/6511RP" ), ( "gdth" )} ,
	{0x1119  , 0x0105  , ( "ICP Vortex|GDT 6121RP/6521RP" ), ( "gdth" )} ,
	{0x10cd  , 0x1200  , ( "Advanced System Products|ASC1200 [(abp940) Fast SCSI-II]" ), ( "advansys" )} ,
	{0x1119  , 0x0110  , ( "ICP Vortex|GDT 6117RP1/6517RP1" ), ( "gdth" )} ,
	{0x1119  , 0x0111  , ( "ICP Vortex|GDT 6127RP1/6527RP1" ), ( "gdth" )} ,
	{0x1119  , 0x0112  , ( "ICP Vortex|GDT 6537RP1" ), ( "gdth" )} ,
	{0x1119  , 0x0113  , ( "ICP Vortex|GDT 6557RP1" ), ( "gdth" )} ,
	{0x1119  , 0x0114  , ( "ICP Vortex|GDT 6111RP1/6511RP1" ), ( "gdth" )} ,
	{0x1119  , 0x0115  , ( "ICP Vortex|GDT 6121RP1/6521RP1" ), ( "gdth" )} ,
	{0x1119  , 0x0118  , ( "ICP Vortex|GDT 6x18RD" ), ( "gdth" )} ,
	{0x1119  , 0x0119  , ( "ICP Vortex|GDT 6x28RD" ), ( "gdth" )} ,
	{0x1119  , 0x011a  , ( "ICP Vortex|GDT 6x38RD" ), ( "gdth" )} ,
	{0x1119  , 0x011b  , ( "ICP Vortex|GDT 6x58RD" ), ( "gdth" )} ,
	{0x1119  , 0x0120  , ( "ICP Vortex|GDT 6117RP2/6517RP2" ), ( "gdth" )} ,
	{0x1119  , 0x0121  , ( "ICP Vortex|GDT 6127RP2/6527RP2" ), ( "gdth" )} ,
	{0x1119  , 0x0122  , ( "ICP Vortex|GDT 6537RP2" ), ( "gdth" )} ,
	{0x1119  , 0x0123  , ( "ICP Vortex|GDT 6557RP2" ), ( "gdth" )} ,
	{0x1119  , 0x0124  , ( "ICP Vortex|GDT 6111RP2/6511RP2" ), ( "gdth" )} ,
	{0x1119  , 0x0125  , ( "ICP Vortex|GDT 6121RP2/6521RP2" ), ( "gdth" )} ,
	{0x9004  , 0x8378  , ( "Adaptec|AHA-3940U/UW / AIC-7883U" ), ( "aic7xxx" )} ,
	{0x10cd  , 0x2300  , ( "Advanced System Products|ABP940-UW" ), ( "advansys" )} ,
	{0x9004  , 0x8678  , ( "Adaptec|AHA-4944UW / 7886" ), ( "aic7xxx" )} ,
	{0x9004  , 0x6038  , ( "Adaptec|AIC-3860" ), ( "aic7xxx" )} ,
	{0x9004  , 0x6478  , ( "Adaptec|AIC-786" ), ( "aic7xxx" )} ,
	{0x1000  , 0x0001  , ( "Symbios|53c810" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x0002  , ( "Symbios|53c820" ), ( "ncr53c8xx" )} ,
	{0x9004  , 0x7850  , ( "Adaptec|AIC-7850" ), ( "aic7xxx" )} ,
	{0x1000  , 0x0003  , ( "Symbios|53c825" ), ( "ncr53c8xx" )} ,
	{0x9004  , 0x7578  , ( "Adaptec|AHA-3944 / AHA-3944W / 7875" ), ( "aic7xxx" )} ,
	{0x1000  , 0x0004  , ( "Symbios|53c815" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x0005  , ( "Symbios|53c810AP" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x0006  , ( "Symbios|53c860" ), ( "ncr53c8xx" )} ,
	{0x9004  , 0x7855  , ( "Adaptec|AHA-2930" ), ( "aic7xxx" )} ,
	{0x1000  , 0x000a  , ( "Symbios|53c1510" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x000b  , ( "Symbios|53c896" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x000c  , ( "Symbios|53c895" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x000d  , ( "Symbios|53c885" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x000f  , ( "Symbios|53c875" ), ( "ncr53c8xx" )} ,
	{0x1000  , 0x0012  , ( "Symbios|53c895a" ), ( "ncr53c8xx" )} ,
	{0x9004  , 0x7860  , ( "Adaptec|AIC-7860" ), ( "aic7xxx" )} ,
	{0x1101  , 0x0002  , ( "Initio Corporation|Ultra SCSI Adapter" ), ( "initio" )} ,
	{0x9004  , 0x7178  , ( "Adaptec|AHA-294x / AIC-7871" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7870  , ( "Adaptec|AIC-7870" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7871  , ( "Adaptec|AHA-2940" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7872  , ( "Adaptec|AHA-3940" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7873  , ( "Adaptec|AHA-3980" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7874  , ( "Adaptec|AHA-2944" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5375  , ( "Adaptec|AIC-755x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5378  , ( "Adaptec|AIC-7850" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7880  , ( "Adaptec|AIC-7880P" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0080  , ( "Adaptec|7892A" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0081  , ( "Adaptec|7892B" ), ( "aic7xxx" )} ,
	{0x9005  , 0x0083  , ( "Adaptec|7892D" ), ( "aic7xxx" )} ,
	{0x9004  , 0x6178  , ( "Adaptec|AIC-7861" ), ( "aic7xxx" )} ,
	{0x9005  , 0x008f  , ( "Adaptec|7892P" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5675  , ( "Adaptec|AIC-755x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5678  , ( "Adaptec|AIC-7850" ), ( "aic7xxx" )} ,
	{0x1119  , 0x0000  , ( "ICP Vortex|GDT 6000/6020/6050" ), ( "gdth" )} ,
	{0x1119  , 0x0001  , ( "ICP Vortex|GDT 6000b/6010" ), ( "gdth" )} ,
	{0x1119  , 0x0002  , ( "ICP Vortex|GDT 6110/6510" ), ( "gdth" )} ,
	{0x1119  , 0x0003  , ( "ICP Vortex|GDT 6120/6520" ), ( "gdth" )} ,
	{0x1119  , 0x0004  , ( "ICP Vortex|GDT 6530" ), ( "gdth" )} ,
	{0x1119  , 0x0005  , ( "ICP Vortex|GDT 6550" ), ( "gdth" )} ,
	{0x1119  , 0x0006  , ( "ICP Vortex|GDT 6x17" ), ( "gdth" )} ,
	{0x1119  , 0x0007  , ( "ICP Vortex|GDT 6x27" ), ( "gdth" )} ,
	{0x1119  , 0x0008  , ( "ICP Vortex|GDT 6537" ), ( "gdth" )} ,
	{0x104b  , 0x1040  , ( "BusLogic|BT-946C (BA80C30) [MultiMaster 10]" ), ( "BusLogic" )} ,
	{0x1119  , 0x0009  , ( "ICP Vortex|GDT 5557" ), ( "gdth" )} ,
	{0x1119  , 0x000a  , ( "ICP Vortex|GDT 6x15" ), ( "gdth" )} ,
	{0x1119  , 0x000b  , ( "ICP Vortex|GDT 6x25" ), ( "gdth" )} ,
	{0x1119  , 0x000c  , ( "ICP Vortex|GDT 6535" ), ( "gdth" )} ,
	{0x1119  , 0x000d  , ( "ICP Vortex|GDT 6555" ), ( "gdth" )} ,
	{0x9005  , 0x00c0  , ( "Adaptec|7899A" ), ( "aic7xxx" )} ,
	{0x9005  , 0x00c1  , ( "Adaptec|7899B" ), ( "aic7xxx" )} ,
	{0x9005  , 0x00c3  , ( "Adaptec|7899D" ), ( "aic7xxx" )} ,
	{0x9005  , 0x00cf  , ( "Adaptec|7899P" ), ( "aic7xxx" )} ,
	{0x1101  , 0x9500  , ( "Initio Corporation|360P" ), ( "initio" )} ,
	{0x1119  , 0x0168  , ( "ICP Vortex|GDT 7x18RN" ), ( "gdth" )} ,
	{0x1119  , 0x0169  , ( "ICP Vortex|GDT 7x28RN" ), ( "gdth" )} ,
	{0x1119  , 0x016a  , ( "ICP Vortex|GDT 7x38RN" ), ( "gdth" )} ,
	{0x1119  , 0x016b  , ( "ICP Vortex|GDT 7x58RN" ), ( "gdth" )} ,
	{0x9004  , 0x5800  , ( "Adaptec|AIC-5800" ), ( "aic7xxx" )} ,
	{0x9004  , 0x8278  , ( "Adaptec|AHA-3940U/UW / AIC-7882U" ), ( "aic7xxx" )} ,
	{0x1077  , 0x2200  , ( "Q Logic|ISP2200" ), ( "qlogicfc" )} ,
	{0x1014  , 0x002e  , ( "IBM|ServeRAID controller" ), ( "ips" )} ,
	{0x9004  , 0x6075  , ( "Adaptec|AIC-1480 / APA-1480" ), ( "aic7xxx" )} ,
	{0x9004  , 0x6078  , ( "Adaptec|AIC-7860" ), ( "aic7xxx" )} ,
	{0x9004  , 0x6778  , ( "Adaptec|AIC-786x" ), ( "aic7xxx" )} ,
	{0x101e  , 0x9010  , ( "AMI|MegaRAID" ), ( "megaraid" )} ,
	{0x9004  , 0x7890  , ( "Adaptec|AIC-7890" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7891  , ( "Adaptec|AIC-789x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7892  , ( "Adaptec|AIC-789x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7893  , ( "Adaptec|AIC-789x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7894  , ( "Adaptec|AIC-789x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7895  , ( "Adaptec|AHA-2940U/UW / AHA-39xx / AIC-7895" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7478  , ( "Adaptec|AHA-2944 / AIC-7874" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7896  , ( "Adaptec|AIC-789x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x7897  , ( "Adaptec|AIC-789x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5275  , ( "Adaptec|AIC-755x" ), ( "aic7xxx" )} ,
	{0x9004  , 0x5278  , ( "Adaptec|AIC-7852" ), ( "aic7xxx" )} ,
	{0x101e  , 0x9060  , ( "AMI|MegaRAID" ), ( "megaraid" )} ,
	{0x1000  , 0x008f  , ( "Symbios|53c875J" ), ( "ncr53c8xx" )} ,
	{0x104b  , 0x0140  , ( "BusLogic|BT-946C (old) [multimaster 01]" ), ( "BusLogic" )} ,
	{0x1022  , 0x2020  , ( "Advanced Micro Devices [AMD]|53c974 [PCscsi]" ), ( "AM53C974" )} ,
	{0x1101  , 0x9100  , ( "Initio Corporation|INI-9100/9100W" ), ( "initio" )} ,

};
int scsi_num_ids=sizeof(scsi_pci_ids)/sizeof(struct pci_module_map);

struct pci_module_map video_pci_ids[] = {

};
int video_num_ids=sizeof(video_pci_ids)/sizeof(struct pci_module_map);
