;;; DO NOT MODIFY THIS FILE
(if (featurep 'semantic-autoloads) (error "Already loaded"))

;;;### (autoloads (semantic-bovine-debug-parser semantic-bovine-debug-create-frame) "bovine-debug" "bovine/bovine-debug.el")

(autoload 'semantic-bovine-debug-create-frame "bovine-debug" "\
Create one bovine frame.
NONTERM is the name of a rule we are currently parsing.
RULE is the index into the list of rules in NONTERM.
MATCH is the index into the list of matches in RULE.
For example:
  this: that
      | other thing
      | here
      ;
The NONTERM is THIS.
The RULE is for \"thing\" is 1.
The MATCH for \"thing\" is 1.
COLLECTION is a list of `things' that have been matched so far.
LEXTOKEN, is a token returned by the lexer which is being matched." nil nil)

(autoload 'semantic-bovine-debug-parser "bovine-debug" "Represents a parser and its state." nil nil)

;;;***

;;;### (autoloads (bovine-grammar-mode) "bovine-grammar" "bovine/bovine-grammar.el")

(autoload 'bovine-grammar-mode "bovine-grammar" "Major mode for editing Bovine grammars." t nil)

(add-to-list 'auto-mode-alist '("\\.by$" . bovine-grammar-mode))

(eval-after-load "speedbar" '(speedbar-add-supported-extension ".by"))

;;;***

;;;### (autoloads (semantic-bovinate-stream semantic-lambda) "semantic-bovine" "bovine/semantic-bovine.el")

(defvar semantic-bovinate-nonterminal-check-obarray nil "\
Obarray of streams already parsed for nonterminal symbols.
Use this to detect infinite recursion during a parse.")

(autoload 'semantic-lambda "semantic-bovine" "\
Create a lambda expression to return a list including RETURN-VAL.
The return list is a lambda expression to be used in a bovine table." nil 'macro)

(autoload 'semantic-bovinate-stream "semantic-bovine" "\
Bovinate STREAM, starting at the first NONTERMINAL rule.
Use `bovine-toplevel' if NONTERMINAL is not provided.
This is the core routine for converting a stream into a table.
Return the list (STREAM SEMANTIC-STREAM) where STREAM are those
elements of STREAM that have not been used.  SEMANTIC-STREAM is the
list of semantic tokens found." nil nil)

(defalias 'semantic-parse-stream-default 'semantic-bovinate-stream)

;;;***

;;;### (autoloads (semantic-c-add-preprocessor-symbol semantic-default-c-setup) "semantic-c" "bovine/semantic-c.el")

(autoload 'semantic-default-c-setup "semantic-c" "\
Set up a buffer for semantic parsing of the C language." nil nil)

(autoload 'semantic-c-add-preprocessor-symbol "semantic-c" "\
Add a preprocessor symbol SYM with a REPLACEMENT value." t nil)

;;;***

;;;### (autoloads (semantic-default-elisp-setup) "semantic-el" "bovine/semantic-el.el")

(autoload 'semantic-default-elisp-setup "semantic-el" "\
Setup hook function for Emacs Lisp files and Semantic." nil nil)

;;;***

;;;### (autoloads (semantic-default-make-setup) "semantic-make" "bovine/semantic-make.el")

(autoload 'semantic-default-make-setup "semantic-make" "\
Set up a Makefile buffer for parsing with semantic." nil nil)

;;;***

;;;### (autoloads (semantic-default-scheme-setup) "semantic-scm" "bovine/semantic-scm.el")

(autoload 'semantic-default-scheme-setup "semantic-scm" "\
Setup hook function for Emacs Lisp files and Semantic." nil nil)

;;;***

;;;### (autoloads nil "_pkg" "semantic/_pkg.el")

(package-provide 'semantic :version 1.23 :author-version "2.0pre4" :type 'regular)

;;;***

;;;### (autoloads (semantic-adebug-insert-object-button semantic-adebug-insert-object-fields) "semantic-adebug-eieio" "semantic/semantic-adebug-eieio.el")

(autoload 'semantic-adebug-insert-object-fields "semantic-adebug-eieio" "\
Insert all the fields of OBJECT.
PREFIX specifies what to insert at the start of each line." nil nil)

(autoload 'semantic-adebug-insert-object-button "semantic-adebug-eieio" "\
Insert a button representing OBJECT.
PREFIX is the text that preceeds the button.
PREBUTTONTEXT is some text between PREFIX and the object button." nil nil)

;;;***

;;;### (autoloads (semantic-adebug-edebug-expr semantic-adebug-analyze semantic-adebug-searchdb semantic-adebug-bovinate semantic-adebug-new-buffer semantic-adebug-mode semantic-adebug-insert-stuff-list semantic-adebug-insert-property-list) "semantic-adebug" "semantic/semantic-adebug.el")

(autoload 'semantic-adebug-insert-property-list "semantic-adebug" "\
Insert the property list PROPLIST.
Each line starts with PREFIX.
The attributes belong to the tag PARENT." nil nil)

(autoload 'semantic-adebug-insert-stuff-list "semantic-adebug" "\
Insert all the parts of STUFFLIST.
PREFIX specifies what to insert at the start of each line." nil nil)

(autoload 'semantic-adebug-mode "semantic-adebug" "\
Major-mode for the Analyzer debugger.

\\{semantic-adebug-map}" t nil)

(autoload 'semantic-adebug-new-buffer "semantic-adebug" "\
Create a new adebug buffer with NAME." nil nil)

(autoload 'semantic-adebug-bovinate "semantic-adebug" "\
The same as `bovinate'. Display the results in a debug buffer." t nil)

(autoload 'semantic-adebug-searchdb "semantic-adebug" "\
Search the semanticdb for REGEX for the current buffer.
Display the results as a debug list." t nil)

(autoload 'semantic-adebug-analyze "semantic-adebug" "\
Perform `semantic-analyze-current-context'.
Display the results as a debug list." t nil)

(autoload 'semantic-adebug-edebug-expr "semantic-adebug" "\
Dump out the contets of some expression EXPR in edebug with adebug." t nil)

;;;***

;;;### (autoloads nil "semantic-alias" "semantic/semantic-alias.el")
(defalias 'semantic-compile-warn
  (eval-when-compile
    (if (fboundp 'byte-compile-warn)
	'byte-compile-warn
      'message)))
(defun semantic-overload-symbol-from-function (name)
  "Return the symbol for overload used by NAME, the defined symbol."
  (let ((sym-name (symbol-name name)))
    (if (string-match "^semantic-" sym-name)
	(intern (substring sym-name (match-end 0)))
      name)))
(defun semantic-alias-obsolete (oldfnalias newfn)
  "Make OLDFNALIAS an alias for NEWFN.
Mark OLDFNALIAS as obsolete, such that the byte compiler
will throw a warning when it encounters this symbol."
  (defalias oldfnalias newfn)
  (make-obsolete oldfnalias newfn)
  (when (and (function-overload-p newfn)
             (not (overload-obsoleted-by newfn))
             ;; Only throw this warning when byte compiling things.
             (boundp 'byte-compile-current-file)
             byte-compile-current-file
	     (not (string-match "cedet" byte-compile-current-file))
	     )
    (make-obsolete-overload oldfnalias newfn)
    (semantic-compile-warn
     "%s: `%s' obsoletes overload `%s'"
     byte-compile-current-file
     newfn
     (semantic-overload-symbol-from-function oldfnalias))
    ))
(defun semantic-varalias-obsolete (oldvaralias newvar)
   "Make OLDVARALIAS an alias for variable NEWVAR.
 Mark OLDVARALIAS as obsolete, such that the byte compiler
 will throw a warning when it encounters this symbol."
   (make-obsolete-variable oldvaralias newvar)
   (condition-case err
       (defvaralias oldvaralias newvar)
     (error
      ;; Only throw this warning when byte compiling things.
      (when (and (boundp 'byte-compile-current-file)
                 byte-compile-current-file)
        (semantic-compile-warn
         "variable `%s' obsoletes, but isn't alias of `%s'"
         newvar oldvaralias)
      ))))

;;;***

;;;### (autoloads nil "semantic-analyze" "semantic/semantic-analyze.el")

(define-overload semantic-analyze-current-context (&optional position) "Analyze the current context at optional POSITION.\nIf called interactively, display interesting information about POSITION\nin a separate buffer.\nReturns an object based on symbol `semantic-analyze-context'.\n\nThis function can be overriden with the symbol `analyze-context'.\nWhen overriding this function, your override will be called while\ncursor is at POSITION.  In addition, your function will not be called\nif a cached copy of the return object is found." (interactive "d") (if (not position) (setq position (point))) (save-excursion (goto-char position) (let* ((answer (semantic-get-cache-data 'current-context))) (with-syntax-table semantic-lex-syntax-table (when (not answer) (setq answer (:override)) (when (and answer (oref answer bounds)) (with-slots (bounds) answer (semantic-cache-data-to-buffer (current-buffer) (car bounds) (cdr bounds) answer 'current-context 'exit-cache-zone)) (if (interactive-p) (semantic-analyze-pop-to-context answer)))) answer))))

(define-overload semantic-analyze-possible-completions (context) "Return a list of semantic tags which are possible completions.\nCONTEXT is either a position (such as point), or a precalculated\ncontext.  Passing in a context is useful if the caller also needs\nto access parts of the analysis.\nCompletions run through the following filters:\n  * Elements currently in scope\n  * Constants currently in scope\n  * Elements match the :prefix in the CONTEXT.\n  * Type of the completion matches the type of the context.\nContext type matching can identify the following:\n  * No specific type\n  * Assignment into a variable of some type.\n  * Argument to a function with type constraints.\nWhen called interactively, displays the list of possible completions\nin a buffer." (interactive "d") (with-syntax-table semantic-lex-syntax-table (let* ((context (if (semantic-analyze-context-child-p context) context (semantic-analyze-current-context context))) (ans (:override))) (when (interactive-p) (with-output-to-temp-buffer "*Possible Completions*" (semantic-analyze-princ-sequence ans "" (current-buffer))) (shrink-window-if-larger-than-buffer (get-buffer-window "*Possible Completions*"))) ans)))

;;;***

;;;### (autoloads (semantic-bnf-mode) "semantic-bnf" "semantic/semantic-bnf.el")

(defalias 'bnf-mode 'semantic-bnf-mode)

(autoload 'semantic-bnf-mode "semantic-bnf" "\
Initialize a buffer for editing BNF code." t nil)

;;;***

;;;### (autoloads (semantic-cb-speedbar-mode semantic-dot) "semantic-cb" "semantic/semantic-cb.el")

(autoload 'semantic-dot "semantic-cb" "\
Create a DOT graph out of the class browser information.
Argument START specifies the name of the class we are going to start
the graph with." t nil)

(autoload 'semantic-cb-speedbar-mode "semantic-cb" "\
Bring speedbar up, and put it into Class Browser mode.
This will use the Class Browser logic applied to the current Semantic
project database to build the available relations.  The structure of
the class hierarchy can then be navigated using traditional speedbar
interactions." t nil)

;;;***

;;;### (autoloads (semantic-chart-tag-complexity semantic-chart-database-size semantic-chart-tags-by-class) "semantic-chart" "semantic/semantic-chart.el")

(autoload 'semantic-chart-tags-by-class "semantic-chart" "\
Create a bar chart representing the number of tags for a given tag class.
Each bar represents how many toplevel tags in TAGTABLE
exist with a given class.  See `semantic-symbol->name-assoc-list'
for tokens which will be charted.
TAGTABLE is passedto `semantic-something-to-tag-table'." t nil)

(autoload 'semantic-chart-database-size "semantic-chart" "\
Create a bar chart representing the size of each file in semanticdb.
Each bar represents how many toplevel nonterminals in TAGTABLE
exist in each database entry.
TAGTABLE is passedto `semantic-something-to-tag-table'." t nil)

(autoload 'semantic-chart-tag-complexity "semantic-chart" "\
Create a bar chart representing the complexity of some tokens.
Complexity is calculated for tokens with a tag of CLASS.  Each bar
represents the complexity of some nonterminal in TAGTABLE.
Only the most complex items are charted.
TAGTABLE is passedto `semantic-something-to-tag-table'." t nil)

;;;***

;;;### (autoloads (semantic-complete-self-insert semantic-complete-analyze-inline semantic-complete-analyze-and-replace semantic-complete-jump semantic-complete-jump-local semantic-complete-inline-analyzer semantic-complete-inline-analyzer-displayor-class semantic-complete-read-tag-analyzer semantic-complete-read-tag-project semantic-complete-read-tag-buffer-deep semantic-complete-inline-force-display semantic-complete-read-tag-engine) "semantic-complete" "semantic/semantic-complete.el")

(autoload 'semantic-complete-read-tag-engine "semantic-complete" "\
Read a semantic tag, and return a tag for the selection.
Argument COLLECTOR is an object which can be used to to calculate
a list of possible hits.  See `semantic-completion-collector-engine'
for details on COLLECTOR.
Argumeng DISPLAYOR is an object used to display a list of possible
completions for a given prefix.  See`semantic-completion-display-engine'
for details on DISPLAYOR.
PROMPT is a string to prompt with.
DEFAULT-TAG is a semantic tag or string to use as the default value.
If INITIAL-INPUT is non-nil, insert it in the minibuffer initially.
HISTORY is a symbol representing a variable to story the history in." nil nil)

(autoload 'semantic-complete-inline-force-display "semantic-complete" "\
Force the display of whatever the current completions are.
DO NOT CALL THIS IF THE INLINE COMPLETION ENGINE IS NOT ACTIVE." nil nil)

(autoload 'semantic-complete-read-tag-buffer-deep "semantic-complete" "\
Ask for a tag by name from the current buffer.
Available tags are from the current buffer, at any level.
Completion options are presented in a traditional way, with highlighting
to resolve same-name collisions.
PROMPT is a string to prompt with.
DEFAULT-TAG is a semantic tag or string to use as the default value.
If INITIAL-INPUT is non-nil, insert it in the minibuffer initially.
HISTORY is a symbol representing a variable to store the history in." nil nil)

(autoload 'semantic-complete-read-tag-project "semantic-complete" "\
Ask for a tag by name from the current project.
Available tags are from the current project, at the top level.
Completion options are presented in a traditional way, with highlighting
to resolve same-name collisions.
PROMPT is a string to prompt with.
DEFAULT-TAG is a semantic tag or string to use as the default value.
If INITIAL-INPUT is non-nil, insert it in the minibuffer initially.
HISTORY is a symbol representing a variable to store the history in." nil nil)

(autoload 'semantic-complete-read-tag-analyzer "semantic-complete" "\
Ask for a tag by name based on the current context.
The function `semantic-analyze-current-context' is used to
calculate the context.  `semantic-analyze-possible-completions' is used 
to generate the list of possible completions.
PROMPT is the first part of the prompt.  Additional prompt
is added based on the contexts full prefix.
CONTEXT is the semantic analyzer context to start with.
HISTORY is a symbol representing a variable to stor the history in.
usually a default-tag and initial-input are available for completion
prompts.  these are calculated from the CONTEXT variable passed in." nil nil)

(defvar semantic-complete-inline-analyzer-displayor-class 'semantic-displayor-tooltip "\
*Class for displayor to use with inline completion.
Good values are:
  'semantic-displayor-tooltip - show options in a tooltip.
  'semantic-displayor-traditional - In a buffer.")

(autoload 'semantic-complete-inline-analyzer "semantic-complete" "\
Complete a symbol name by name based on the current context.
This is similar to `semantic-complete-read-tag-analyze', except
that the completion interaction is in the buffer where the context
was calculated from.
CONTEXT is the semantic analyzer context to start with.
See `semantic-complete-inline-tag-engine' for details on how
completion works." nil nil)

(autoload 'semantic-complete-jump-local "semantic-complete" "\
Jump to a semantic symbol." t nil)

(autoload 'semantic-complete-jump "semantic-complete" "\
Jump to a semantic symbol." t nil)

(autoload 'semantic-complete-analyze-and-replace "semantic-complete" "\
Perform prompt completion to do in buffer completion.
`semantic-analyze-possible-completions' is used to determine the
possible values.
The minibuffer is used to perform the completion.
The result is inserted as a replacement of the text that was there." t nil)

(autoload 'semantic-complete-analyze-inline "semantic-complete" "\
Perform prompt completion to do in buffer completion.
`semantic-analyze-possible-completions' is used to determine the
possible values.
The function returns immediately, leaving the buffer in a mode that
will perform the completion." t nil)

(autoload 'semantic-complete-self-insert "semantic-complete" "\
Like `self-insert-command', but does completion afterwards.
ARG is passed to `self-insert-command'.  If ARG is nil,
use `semantic-complete-analyze-inline' to complete." t nil)

;;;***

;;;### (autoloads nil "semantic-ctxt" "semantic/semantic-ctxt.el")

(defvar semantic-command-separation-character ";" "\
String which indicates the end of a command.
Used for identifying the end of a single command.")

;;;***

;;;### (autoloads (semantic-debug semantic-debug-break) "semantic-debug" "semantic/semantic-debug.el")

(defvar semantic-debug-parser-source nil "\
For any buffer, the file name (no path) of the parser.
This would be a parser for a specific language, not the source
to one of the parser generators.")

(make-variable-buffer-local 'semantic-debug-parser-source)

(defvar semantic-debug-parser-class nil "\
Class to create when building a debug parser object.")

(make-variable-buffer-local 'semantic-debug-parser-class)

(defvar semantic-debug-enabled nil "\
Non-nil when debugging a parser.")

(autoload 'semantic-debug-break "semantic-debug" "\
Stop parsing now at FRAME.
FRAME is an object that represents the parser's view of the
current state of the world.
This function enters a recursive edit.  It returns
on an `exit-recursive-edit', or if someone uses one
of the `semantic-debug-mode' commands.
It returns the command specified.  Parsers need to take action
on different types of return values." nil nil)

(autoload 'semantic-debug "semantic-debug" "\
Parse the current buffer and run in debug mode." t nil)

;;;***

;;;### (autoloads (semantic-build-decoration-mode-menu semantic-decoration-mode global-semantic-decoration-mode global-semantic-decoration-mode) "semantic-decorate-mode" "semantic/semantic-decorate-mode.el")

(autoload 'global-semantic-decoration-mode "semantic-decorate-mode" "\
Toggle global use of option `semantic-decoration-mode'.
Decoration mode turns on all active decorations as specified
by `semantic-decoration-styles'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(progn (defvar global-semantic-decoration-mode nil "*If non-nil, enable global use of command `semantic-decoration-mode'.\nWhen this mode is activated, decorations specified by\n`semantic-decoration-styles'.") (custom-add-to-group 'semantic 'global-semantic-decoration-mode 'custom-variable) (custom-add-load 'global-semantic-decoration-mode 'semantic-decorate-mode))

(defvar semantic-decoration-mode nil "\
Non-nil if command `semantic-decoration-mode' is enabled.
Use the command `semantic-decoration-mode' to change this variable.")

(autoload 'semantic-decoration-mode "semantic-decorate-mode" "\
Minor mode for decorating tags.
Decorations are specified in `semantic-decoration-styles'.
You can define new decoration styles with
`define-semantic-decoration-style'.
With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled." t nil)

(autoload 'semantic-build-decoration-mode-menu "semantic-decorate-mode" "\
Create a menu listing all the known decorations for toggling.
IGNORE any input arguments." nil nil)

;;;***

;;;### (autoloads (semantic-tag-folded-p semantic-set-tag-folded semantic-tag-delete-secondary-overlay semantic-tag-get-secondary-overlay semantic-tag-create-secondary-overlay semantic-tag-secondary-overlays semantic-tag-read-only-p semantic-set-tag-read-only semantic-tag-intangible-p semantic-set-tag-intangible semantic-tag-invisible-p semantic-set-tag-invisible semantic-set-tag-face semantic-momentary-highlight-tag semantic-unhighlight-tag semantic-highlight-tag) "semantic-decorate" "semantic/semantic-decorate.el")

(autoload 'semantic-highlight-tag "semantic-decorate" "\
Specify that TAG should be highlighted.
Optional FACE specifies the face to use." nil nil)

(autoload 'semantic-unhighlight-tag "semantic-decorate" "\
Unhighlight TAG, restoring it's previous face." nil nil)

(autoload 'semantic-momentary-highlight-tag "semantic-decorate" "\
Highlight TAG, removing highlighting when the user hits a key.
Optional argument FACE is the face to use for highlighting.
If FACE is not specified, then `highlight' will be used." nil nil)

(autoload 'semantic-set-tag-face "semantic-decorate" "\
Specify that TAG should use FACE for display." nil nil)

(autoload 'semantic-set-tag-invisible "semantic-decorate" "\
Enable the text in TAG to be made invisible.
If VISIBLE is non-nil, make the text visible." nil nil)

(autoload 'semantic-tag-invisible-p "semantic-decorate" "\
Return non-nil if TAG is invisible." nil nil)

(autoload 'semantic-set-tag-intangible "semantic-decorate" "\
Enable the text in TAG to be made intangible.
If TANGIBLE is non-nil, make the text visible.
This function does not have meaning in XEmacs because it seems that
the extent 'intangible' property does not exist." nil nil)

(autoload 'semantic-tag-intangible-p "semantic-decorate" "\
Return non-nil if TAG is intangible.
This function does not have meaning in XEmacs because it seems that
the extent 'intangible' property does not exist." nil nil)

(autoload 'semantic-set-tag-read-only "semantic-decorate" "\
Enable the text in TAG to be made read-only.
Optional argument WRITABLE should be non-nil to make the text writable
instead of read-only." nil nil)

(autoload 'semantic-tag-read-only-p "semantic-decorate" "\
Return non-nil if the current TAG is marked read only." nil nil)

(semantic-alias-obsolete 'semantic-highlight-token 'semantic-highlight-tag)

(semantic-alias-obsolete 'semantic-unhighlight-token 'semantic-unhighlight-tag)

(semantic-alias-obsolete 'semantic-momentary-unhighlight-token 'semantic-momentary-unhighlight-tag)

(semantic-alias-obsolete 'semantic-momentary-highlight-token 'semantic-momentary-highlight-tag)

(semantic-alias-obsolete 'semantic-set-token-face 'semantic-set-tag-face)

(semantic-alias-obsolete 'semantic-set-token-invisible 'semantic-set-tag-invisible)

(semantic-alias-obsolete 'semantic-token-invisible-p 'semantic-tag-invisible-p)

(semantic-alias-obsolete 'semantic-set-token-intangible 'semantic-set-tag-intangible)

(semantic-alias-obsolete 'semantic-token-intangible-p 'semantic-tag-intangible-p)

(semantic-alias-obsolete 'semantic-set-token-read-only 'semantic-set-tag-read-only)

(semantic-alias-obsolete 'semantic-token-read-only-p 'semantic-tag-read-only-p)

(autoload 'semantic-tag-secondary-overlays "semantic-decorate" "\
Return a list of secondary overlays active on TAG." nil nil)

(autoload 'semantic-tag-create-secondary-overlay "semantic-decorate" "\
Create a secondary overlay for TAG.
Returns an overlay.  The overlay is also saved in TAG.
LINK-HOOK is a function called whenever TAG is to be linked into
a buffer.  It should take TAG and OVERLAY as arguments.
The LINK-HOOK should be used to position and set properties on the
generated secondary overlay." nil nil)

(autoload 'semantic-tag-get-secondary-overlay "semantic-decorate" "\
Return secondary overlays from TAG with PROPERTY.
PROPERTY is a symbol and all overlays with that symbol are returned.." nil nil)

(autoload 'semantic-tag-delete-secondary-overlay "semantic-decorate" "\
Delete from TAG the secondary overlay OVERLAY-OR-PROPERTY.
If OVERLAY-OR-PROPERTY is an overlay, delete that overlay.
If OVERLAY-OR-PROPERTY is a symbol, find the overlay with that property." nil nil)

(autoload 'semantic-set-tag-folded "semantic-decorate" "\
Fold TAG, such that only the first line of text is shown.
Optional argument FOLDED should be non-nil to fold the tag.
nil implies the tag should be fully shown." nil nil)

(autoload 'semantic-tag-folded-p "semantic-decorate" "\
Non-nil if TAG is currently folded." nil nil)

;;;***

;;;### (autoloads (semantic-dependency-find-file-on-path semantic-reset-system-include semantic-remove-system-include semantic-add-system-include) "semantic-dep" "semantic/semantic-dep.el")

(defvar semantic-dependency-include-path nil "\
Defines the include path used when searching for files.
This should be a list of directories to search which is specific
to the file being included.

If `semantic-dependency-tag-file' is overridden for a given
language, this path is most likely ignored.

The above function, reguardless of being overriden, caches the
located dependency file location in the tag property
`dependency-file'.  If you override this function, you do not
need to implement your own cache.  Each time the buffer is fully
reparsed, the cache will be reset.

TODO: use ffap.el to locate such items?

NOTE: Obsolete this, or use as special user")

(defvar semantic-dependency-system-include-path nil "\
Defines the system include path.
This should be set with either `defvar-mode-local', or with
`semantic-add-system-include'.

When searching for a file associated with a name found in an tag of
class include, this path will be inspected for includes of type
`system'.  Some include tags are agnostic to this setting and will
check both the project and system directories.")

(autoload 'semantic-add-system-include "semantic-dep" "\
Add a system include DIR to path for MODE.
Modifies a mode-local version of
`semantic-dependency-system-include-path'." t nil)

(autoload 'semantic-remove-system-include "semantic-dep" "\
Add a system include DIR to path for MODE.
Modifies a mode-local version of
`semantic-dependency-system-include-path'." t nil)

(autoload 'semantic-reset-system-include "semantic-dep" "\
Reset the system include list to empty for MODE.
Modifies a mode-local version of
`semantic-dependency-system-include-path'." t nil)

(autoload 'semantic-dependency-find-file-on-path "semantic-dep" "\
Return an expanded file name for FILE on available paths.
If SYSTEMP is true, then only search system paths.
If optional argument MODE is non-nil, then derive paths from the
provided mode, not from the current major mode." nil nil)

;;;***

;;;### (autoloads nil "semantic-doc" "semantic/semantic-doc.el")

(define-overload semantic-documentation-for-tag (&optional tag nosnarf) "Find documentation from TAG and return it as a clean string.\nTAG might have DOCUMENTATION set in it already.  If not, there may be\nsome documentation in a comment preceding TAG's definition which we\ncan look for.  When appropriate, this can be overridden by a language specific\nenhancement.\nOptional argument NOSNARF means to only return the lexical analyzer token for it.\nIf nosnarf if 'lex, then only return the lex token." (if (not tag) (setq tag (semantic-current-tag))) (:override (save-excursion (set-buffer (semantic-tag-buffer tag)) (semantic-go-to-tag tag) (or (if (semantic-tag-docstring tag) (if (stringp (semantic-tag-docstring tag)) (semantic-tag-docstring tag) (goto-char (semantic-tag-docstring tag)) (semantic-doc-snarf-comment-for-tag nosnarf))) (semantic-documentation-comment-preceeding-tag tag nosnarf) nil))))

(semantic-alias-obsolete 'semantic-find-documentation 'semantic-documentation-for-tag)

;;;***

;;;### (autoloads (semantic-ede-proj-target-grammar) "semantic-ede-grammar" "semantic/semantic-ede-grammar.el")

(autoload 'semantic-ede-proj-target-grammar "semantic-ede-grammar" "This target consists of a group of grammar files.\nA grammar target consists of grammar files that build Emacs Lisp programs for\nparsing different languages." nil nil)

(autoload 'ede-proj-target-elisp "semantic-ede-proj-target-grammar" "\
Target class for Emacs/Semantic grammar files." nil nil)

(eval-after-load "ede-proj" '(require 'semantic-ede-grammar))

;;;***

;;;### (autoloads (semantic-edits-incremental-parser semantic-edits-flush-changes semantic-edits-change-function-handle-changes semantic-change-function semantic-edits-verbose-flag) "semantic-edit" "semantic/semantic-edit.el")

(defvar semantic-edits-verbose-flag nil "\
Non-nil means the incremental perser is verbose.
If nil, errors are still displayed, but informative messages are not.")

(autoload 'semantic-change-function "semantic-edit" "\
Provide a mechanism for semantic token management.
Argument START, END, and LENGTH specify the bounds of the change." nil nil)

(autoload 'semantic-edits-change-function-handle-changes "semantic-edit" "\
Run whenever a buffer controlled by `semantic-mode' change.
Tracks when and how the buffer is re-parsed.
Argument START, END, and LENGTH specify the bounds of the change." nil nil)

(autoload 'semantic-edits-flush-changes "semantic-edit" "\
Flush the changes in the current buffer." nil nil)

(autoload 'semantic-edits-incremental-parser "semantic-edit" "\
Incrementally reparse the current buffer.
Incremental parser allows semantic to only reparse those sections of
the buffer that have changed.  This function depends on
`semantic-edits-change-function-handle-changes' setting up change
overlays in the current buffer.  Those overlays are analyzed against
the semantic cache to see what needs to be changed." nil nil)

(defalias 'semantic-parse-changes-default 'semantic-edits-incremental-parser)

(add-hook 'semantic-change-hooks (function semantic-edits-change-function-handle-changes))

(add-hook 'semantic-before-toplevel-cache-flush-hook (function semantic-edits-flush-changes))

;;;***

;;;### (autoloads (semantic-brute-find-innermost-tag-by-position semantic-brute-find-tag-by-position semantic-brute-find-first-tag-by-function semantic-brute-find-tag-by-function semantic-brute-find-tag-by-attribute-value semantic-brute-find-tag-by-attribute semantic-brute-find-tag-by-property semantic-brute-find-tag-by-name-regexp semantic-brute-find-tag-by-type-regexp semantic-brute-find-tag-by-type semantic-brute-find-tag-standard semantic-brute-find-tag-by-class semantic-brute-find-first-tag-by-name semantic-deep-find-tags-by-name-regexp semantic-deep-find-tags-for-completion semantic-deep-find-tags-by-name semantic-find-tags-by-scope-protection semantic-find-tags-of-compound-type semantic-find-tags-by-type semantic-find-tags-by-class semantic-find-tags-by-name-regexp semantic-find-tags-for-completion semantic-find-tags-by-name semantic-current-tag-of-class semantic-current-tag-parent semantic-current-tag semantic-find-tag-parent-by-overlay semantic-find-tag-by-overlay-prev semantic-find-tag-by-overlay-next semantic-find-tag-by-overlay-in-region semantic-find-tag-by-overlay) "semantic-find" "semantic/semantic-find.el")

(autoload 'semantic-find-tag-by-overlay "semantic-find" "\
Find all tags covering POSITIONORMARKER by using overlays.
If POSITIONORMARKER is nil, use the current point.
Optional BUFFER is used if POSITIONORMARKER is a number, otherwise the current
buffer is used.  This finds all tags covering the specified position
by checking for all overlays covering the current spot.  They are then sorted
from largest to smallest via the start location." nil nil)

(autoload 'semantic-find-tag-by-overlay-in-region "semantic-find" "\
Find all tags which exist in whole or in part between START and END.
Uses overlays to determine positin.
Optional BUFFER argument specifies the buffer to use." nil nil)

(autoload 'semantic-find-tag-by-overlay-next "semantic-find" "\
Find the next tag after START in BUFFER.
If START is in an overlay, find the tag which starts next,
not the current tag." nil nil)

(autoload 'semantic-find-tag-by-overlay-prev "semantic-find" "\
Find the next tag before START in BUFFER.
If START is in an overlay, find the tag which starts next,
not the current tag." nil nil)

(autoload 'semantic-find-tag-parent-by-overlay "semantic-find" "\
Find the parent of TAG by overlays.
Overlays are a fast way of finding this information for active buffers." nil nil)

(autoload 'semantic-current-tag "semantic-find" "\
Return the current tag in the current buffer.
If there are more than one in the same location, return the
smallest tag.  Return nil if there is no tag here." nil nil)

(autoload 'semantic-current-tag-parent "semantic-find" "\
Return the current tags parent in the current buffer.
A tag's parent would be a containing structure, such as a type
containing a field.  Return nil if there is no parent." nil nil)

(autoload 'semantic-current-tag-of-class "semantic-find" "\
Return the current (smallest) tags of CLASS in the current buffer.
If the smallest tag is not of type CLASS, keep going upwards until one
is found.
Uses `semantic-tag-class' for classification." nil nil)

(defsubst semantic-find-first-tag-by-name (name &optional table) "\
Find the first tag with NAME in TABLE.
NAME is a string.
TABLE is a semantic tags table.  See `semantic-something-to-tag-table'.
This routine uses `assoc' to quickly find the first matching entry." (funcall (if semantic-case-fold 'assoc-ignore-case 'assoc) name (semantic-something-to-tag-table table)))

(autoload 'semantic-find-tags-by-name "semantic-find" "\
Find all tags with NAME in TABLE.
NAME is a string.
TABLE is a tag table.  See `semantic-something-to-tag-table'." nil 'macro)

(autoload 'semantic-find-tags-for-completion "semantic-find" "\
Find all tags whos name begins with PREFIX in TABLE.
PREFIX is a string.
TABLE is a tag table.  See `semantic-something-to-tag-table'.
While it would be nice to use `try-completion' or `all-completions',
those functions do not return the tags, only a string.
Uses `compare-strings' for fast comparison." nil 'macro)

(autoload 'semantic-find-tags-by-name-regexp "semantic-find" "\
Find all tags with name matching REGEXP in TABLE.
REGEXP is a string containing a regular expression,
TABLE is a tag table.  See `semantic-something-to-tag-table'.
Consider using `semantic-find-tags-for-completion' if you are
attempting to do completions." nil 'macro)

(autoload 'semantic-find-tags-by-class "semantic-find" "\
Find all tags of class CLASS in TABLE.
CLASS is a symbol representing the class of the token, such as
'variable, of 'function..
TABLE is a tag table.  See `semantic-something-to-tag-table'." nil 'macro)

(autoload 'semantic-find-tags-by-type "semantic-find" "\
Find all tags of with a type TYPE in TABLE.
TYPE is a string or tag representing a data type as defined in the
language the tags were parsed from, such as \"int\", or perhaps
a tag whose name is that of a struct or class.
TABLE is a tag table.  See `semantic-something-to-tag-table'." nil 'macro)

(autoload 'semantic-find-tags-of-compound-type "semantic-find" "\
Find all tags which are a compound type in TABLE.
Compound types are structures, or other data type which
is not of a primitive nature, such as int or double.
Used in completion." nil 'macro)

(autoload 'semantic-find-tags-by-scope-protection "semantic-find" "\
Find all tags accessable by SCOPEPROTECTION.
SCOPEPROTECTION is a symbol which can be returned by the method
`semantic-tag-protection'.  A hard-coded order is used to determine a match.
PARENT is a tag representing the PARENT slot needed for
`semantic-tag-protection'.
TABLE is a list of tags (a subset of PARENT members) to scan.  If TABLE is nil,
the type members of PARENT are used.
See `semantic-tag-protected-p' for details on which tags are returned." nil nil)

(defsubst semantic-find-tags-included (&optional table) "\
Find all tags in TABLE that are of the 'include class.
TABLE is a tag table.  See `semantic-something-to-tag-table'." (semantic-find-tags-by-class 'include table))

(autoload 'semantic-deep-find-tags-by-name "semantic-find" "\
Find all tags with NAME in TABLE.
Search in top level tags, and their components, in TABLE.
NAME is a string.
TABLE is a tag table.  See `semantic-flatten-tags-table'.
See also `semantic-find-tags-by-name'." nil 'macro)

(autoload 'semantic-deep-find-tags-for-completion "semantic-find" "\
Find all tags whos name begins with PREFIX in TABLE.
Search in top level tags, and their components, in TABLE.
TABLE is a tag table.  See `semantic-flatten-tags-table'.
See also `semantic-find-tags-for-completion'." nil 'macro)

(autoload 'semantic-deep-find-tags-by-name-regexp "semantic-find" "\
Find all tags with name matching REGEXP in TABLE.
Search in top level tags, and their components, in TABLE.
REGEXP is a string containing a regular expression,
TABLE is a tag table.  See `semantic-flatten-tags-table'.
See also `semantic-find-tags-by-name-regexp'.
Consider using `semantic-deep-find-tags-for-completion' if you are
attempting to do completions." nil 'macro)

(autoload 'semantic-brute-find-first-tag-by-name "semantic-find" "\
Find a tag NAME within STREAMORBUFFER.  NAME is a string.
If SEARCH-PARTS is non-nil, search children of tags.
If SEARCH-INCLUDE is non-nil, search include files.

Use `semantic-find-first-tag-by-name' instead." nil nil)

(autoload 'semantic-brute-find-tag-by-class "semantic-find" "\
Find all tags with a class CLASS within STREAMORBUFFER.
CLASS is a symbol representing the class of the tags to find.
See `semantic-tag-class'.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'.

Use `semantic-find-tag-by-class' instead." nil 'macro)

(autoload 'semantic-brute-find-tag-standard "semantic-find" "\
Find all tags in STREAMORBUFFER which define simple class types.
See `semantic-tag-class'.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil 'macro)

(autoload 'semantic-brute-find-tag-by-type "semantic-find" "\
Find all tags with type TYPE within STREAMORBUFFER.
TYPE is a string which is the name of the type of the tags returned.
See `semantic-tag-type'.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil nil)

(autoload 'semantic-brute-find-tag-by-type-regexp "semantic-find" "\
Find all tags with type matching REGEXP within STREAMORBUFFER.
REGEXP is a regular expression  which matches the  name of the type of the
tags returned.  See `semantic-tag-type'.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil nil)

(autoload 'semantic-brute-find-tag-by-name-regexp "semantic-find" "\
Find all tags whose name match REGEX in STREAMORBUFFER.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil nil)

(autoload 'semantic-brute-find-tag-by-property "semantic-find" "\
Find all tags with PROPERTY equal to VALUE in STREAMORBUFFER.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil nil)

(autoload 'semantic-brute-find-tag-by-attribute "semantic-find" "\
Find all tags with a given ATTR in STREAMORBUFFER.
ATTR is a symbol key into the attributes list.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil nil)

(autoload 'semantic-brute-find-tag-by-attribute-value "semantic-find" "\
Find all tags with a given ATTR equal to VALUE in STREAMORBUFFER.
ATTR is a symbol key into the attributes list.
VALUE is the value that ATTR should match.
Optional argument SEARCH-PARTS and SEARCH-INCLUDES are passed to
`semantic-brute-find-tag-by-function'." nil nil)

(autoload 'semantic-brute-find-tag-by-function "semantic-find" "\
Find all tags for which FUNCTION's value is non-nil within STREAMORBUFFER.
FUNCTION must return non-nil if an element of STREAM will be included
in the new list.

If optional argument SEARCH-PARTS is non-nil, all sub-parts of tags
are searched.  The overloadable function `semantic-tag-componenets' is
used for the searching child lists.  If SEARCH-PARTS is the symbol
'positiononly, then only children that have positional information are
searched.

If SEARCH-INCLUDES is non-nil, then all include files are also
searched for matches.  This parameter hasn't be active for a while
and is obsolete." nil nil)

(autoload 'semantic-brute-find-first-tag-by-function "semantic-find" "\
Find the first tag which FUNCTION match within STREAMORBUFFER.
FUNCTION must return non-nil if an element of STREAM will be included
in the new list.

The following parameters were never implemented.

If optional argument SEARCH-PARTS, all sub-parts of tags are searched.
The overloadable function `semantic-tag-components' is used for
searching.
If SEARCH-INCLUDES is non-nil, then all include files are also
searched for matches." nil nil)

(autoload 'semantic-brute-find-tag-by-position "semantic-find" "\
Find a tag covering POSITION within STREAMORBUFFER.
POSITION is a number, or marker.  If NOMEDIAN is non-nil, don't do
the median calculation, and return nil." nil nil)

(autoload 'semantic-brute-find-innermost-tag-by-position "semantic-find" "\
Find a list of tags covering POSITION within STREAMORBUFFER.
POSITION is a number, or marker.  If NOMEDIAN is non-nil, don't do
the median calculation, and return nil.
This function will find the topmost item, and recurse until no more
details are available of findable." nil nil)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-overlay 'semantic-find-tag-by-overlay)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-overlay-in-region 'semantic-find-tag-by-overlay-in-region)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-overlay-next 'semantic-find-tag-by-overlay-next)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-overlay-prev 'semantic-find-tag-by-overlay-prev)

(semantic-alias-obsolete 'semantic-find-nonterminal-parent-by-overlay 'semantic-find-tag-parent-by-overlay)

(semantic-alias-obsolete 'semantic-current-nonterminal 'semantic-current-tag)

(semantic-alias-obsolete 'semantic-current-nonterminal-parent 'semantic-current-tag-parent)

(semantic-alias-obsolete 'semantic-current-nonterminal-of-type 'semantic-current-tag-of-class)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-name 'semantic-brute-find-first-tag-by-name)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-token 'semantic-brute-find-tag-by-class)

(semantic-alias-obsolete 'semantic-find-nonterminal-standard 'semantic-brute-find-tag-standard)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-type 'semantic-brute-find-tag-by-type)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-type-regexp 'semantic-brute-find-tag-by-type-regexp)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-name-regexp 'semantic-brute-find-tag-by-name-regexp)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-property 'semantic-brute-find-tag-by-property)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-extra-spec 'semantic-brute-find-tag-by-attribute)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-extra-spec-value 'semantic-brute-find-tag-by-attribute-value)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-function 'semantic-brute-find-tag-by-function)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-function-first-match 'semantic-brute-find-first-tag-by-function)

(semantic-alias-obsolete 'semantic-find-nonterminal-by-position 'semantic-brute-find-tag-by-position)

(semantic-alias-obsolete 'semantic-find-innermost-nonterminal-by-position 'semantic-brute-find-innermost-tag-by-position)

;;;***

;;;### (autoloads (semantic-format-tag-prin1) "semantic-format" "semantic/semantic-format.el")

(defvar semantic-format-tag-functions '(semantic-format-tag-name semantic-format-tag-canonical-name semantic-format-tag-abbreviate semantic-format-tag-summarize semantic-format-tag-prototype semantic-format-tag-concise-prototype semantic-format-tag-uml-abbreviate semantic-format-tag-uml-prototype semantic-format-tag-uml-concise-prototype semantic-format-tag-prin1) "\
List of functions which convert a tag to text.
Each function must take the parameters TAG &optional PARENT COLOR.
TAG is the tag to convert.
PARENT is a parent tag or name which refers to the structure
or class which contains TAG.  PARENT is NOT a class which a TAG
would claim as a parent.
COLOR indicates that the generated text should be colored using
`font-lock'.")

(semantic-varalias-obsolete 'semantic-token->text-functions 'semantic-format-tag-functions)

(defvar semantic-format-tag-custom-list (append '(radio) (mapcar (lambda (f) (list 'const f)) semantic-format-tag-functions) '(function)) "\
A List used by customizeable variables to choose a tag to text function.
Use this variable in the :type field of a customizable variable.")

(define-overload semantic-format-tag-type (tag color) "Convert the data type of TAG to a string usable in tag formatting.\nIt is presumed that TYPE is a string or semantic tag.")

(autoload 'semantic-format-tag-prin1 "semantic-format" "\
Convert TAG to a string that is the print name for TAG.
PARENT and COLOR are ignored." nil nil)

(define-overload semantic-format-tag-name (tag &optional parent color) "Return the name string describing TAG.\nThe name is the shortest possible representation.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-abbreviate (tag &optional parent color) "Return an abbreviated string describing TAG.\nThe abbreviation is to be short, with possible symbols indicating\nthe type of tag, or other information.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-summarize (tag &optional parent color) "Summarize TAG in a reasonable way.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-prototype (tag &optional parent color) "Return a prototype for TAG.\nThis function should be overloaded, though it need not be used.\nThis is because it can be used to create code by language independent\ntools.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-concise-prototype (tag &optional parent color) "Return a concise prototype for TAG.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-uml-abbreviate (tag &optional parent color) "Return a UML style abbreviation for TAG.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-uml-prototype (tag &optional parent color) "Return a UML style prototype for TAG.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

(define-overload semantic-format-tag-uml-concise-prototype (tag &optional parent color) "Return a UML style concise prototype for TAG.\nOptional argument PARENT is the parent type if TAG is a detail.\nOptional argument COLOR means highlight the prototype with font-lock colors.")

;;;***

;;;### (autoloads (semantic-grammar-batch-build-packages) "semantic-grammar" "semantic/semantic-grammar.el")

(autoload 'semantic-grammar-batch-build-packages "semantic-grammar" "\
Build Lisp packages from grammar files on the command line.
That is, run `semantic-grammar-batch-build-one-package' for each file.
Each file is processed even if an error occurred previously.
Must be used from the command line, with `-batch'.
For example, to process grammar files in current directory, invoke:

  \"emacs -batch -f semantic-grammar-batch-build-packages .\".

See also the variable `semantic-grammar-file-regexp'." nil nil)

;;;***

;;;### (autoloads (semantic-default-html-setup) "semantic-html" "semantic/semantic-html.el")

(autoload 'semantic-default-html-setup "semantic-html" "\
Set up a buffer for parsing of HTML files." nil nil)

(add-hook 'html-mode-hook 'semantic-default-html-setup)

;;;***

;;;### (autoloads (semantic-speedbar-analysis) "semantic-ia-sb" "semantic/semantic-ia-sb.el")

(autoload 'semantic-speedbar-analysis "semantic-ia-sb" "\
Start Speedbar in semantic analysis mode.
The analyzer displays information about the current context, plus a smart
list of possible completions." t nil)

;;;***

;;;### (autoloads (semantic-ia-show-doc semantic-ia-show-summary semantic-ia-complete-tip semantic-ia-complete-symbol-menu semantic-ia-complete-symbol) "semantic-ia" "semantic/semantic-ia.el")

(autoload 'semantic-ia-complete-symbol "semantic-ia" "\
Complete the current symbol at POINT.
Completion options are calculated with `semantic-analyze-possible-completions'." t nil)

(autoload 'semantic-ia-complete-symbol-menu "semantic-ia" "\
Complete the current symbol via a menu based at POINT.
Completion options are calculated with `semantic-analyze-possible-completions'." t nil)

(autoload 'semantic-ia-complete-tip "semantic-ia" "\
Pop up a tooltip for completion at POINT." t nil)

(autoload 'semantic-ia-show-summary "semantic-ia" "\
Display a summary for the symbol under POINT." t nil)

(autoload 'semantic-ia-show-doc "semantic-ia" "\
Display the code-level documentation for the symbol at POINT." t nil)

;;;***

;;;### (autoloads (semantic-idle-scheduler-remove semantic-idle-scheduler-add semantic-idle-scheduler-mode global-semantic-idle-scheduler-mode global-semantic-idle-scheduler-mode) "semantic-idle" "semantic/semantic-idle.el")

(progn (defvar global-semantic-idle-scheduler-mode nil "*If non-nil, enable global use of idle-scheduler mode.") (custom-add-to-group 'semantic 'global-semantic-idle-scheduler-mode 'custom-variable) (custom-add-load 'global-semantic-idle-scheduler-mode 'semantic-idle))

(autoload 'global-semantic-idle-scheduler-mode "semantic-idle" "\
Toggle global use of option `semantic-idle-scheduler-mode'.
The idle scheduler with automatically reparse buffers in idle time,
and then schedule other jobs setup with `semantic-idle-scheduler-add'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(defvar semantic-idle-scheduler-mode nil "\
Non-nil if idle-scheduler minor mode is enabled.
Use the command `semantic-idle-scheduler-mode' to change this variable.")

(autoload 'semantic-idle-scheduler-mode "semantic-idle" "\
Minor mode to auto parse buffer following a change.
When this mode is off, a buffer is only rescanned for tokens when
some command requests the list of available tokens.  When idle-scheduler
is enabled, Emacs periodically checks to see if the buffer is out of
date, and reparses while the user is idle (not typing.)

With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled." t nil)

(autoload 'semantic-idle-scheduler-add "semantic-idle" "\
Schedule FUNCTION to occur during idle time." nil nil)

(autoload 'semantic-idle-scheduler-remove "semantic-idle" "\
Unschedule FUNCTION to occur during idle time." nil nil)

;;;***

;;;### (autoloads (semantic-create-imenu-index semantic-imenu-expand-type-members semantic-imenu-bucketize-file semantic-imenu-summary-function) "semantic-imenu" "semantic/semantic-imenu.el")

(defvar semantic-imenu-summary-function 'semantic-format-tag-abbreviate "\
*Function to use when creating items in Imenu.
Some useful functions are found in `semantic-format-tag-functions'.")

(defvar semantic-imenu-bucketize-file t "\
*Non-nil if tags in a file are to be grouped into buckets.")

(defvar semantic-imenu-expand-type-members t "\
*Non-nil if types should have submenus with members in them.")

(defvar semantic-imenu-expandable-tag-classes '(type) "\
List of expandable tag classes.
Tags of those classes will be given submenu with children.
By default, a `type' has interesting children.  In Texinfo, however, a
`section' has interesting children.")

(autoload 'semantic-create-imenu-index "semantic-imenu" "\
Create an imenu index for any buffer which supports Semantic.
Uses the output of the Semantic parser to create the index.
Optional argument STREAM is an optional stream of tags used to create menus." nil nil)

;;;***

;;;### (autoloads (define-lex-block-analyzer define-lex-simple-regex-analyzer define-lex-regex-analyzer define-lex-analyzer semantic-lex-init define-lex) "semantic-lex" "semantic/semantic-lex.el")

(defvar semantic-lex-analyzer 'semantic-flex "\
The lexical analyzer used for a given buffer.
See `semantic-lex' for documentation.
For compatibility with Semantic 1.x it defaults to `semantic-flex'.")

(autoload 'define-lex "semantic-lex" "\
Create a new lexical analyzer with NAME.
DOC is a documentation string describing this analyzer.
ANALYZERS are small code snippets of analyzers to use when
building the new NAMED analyzer.  Only use analyzers which
are written to be used in `define-lex'.
Each analyzer should be an analyzer created with `define-lex-analyzer'.
Note: The order in which analyzers are listed is important.
If two analyzers can match the same text, it is important to order the
analyzers so that the one you want to match first occurs first.  For
example, it is good to put a numbe analyzer in front of a symbol
analyzer which might mistake a number for as a symbol." nil 'macro)

(autoload 'semantic-lex-init "semantic-lex" "\
Initialize any lexical state for this buffer." nil nil)

(define-overload semantic-lex (start end &optional depth length) "Lexically analyze text in the current buffer between START and END.\nOptional argument DEPTH indicates at what level to scan over entire\nlists.  The last argument, LENGTH specifies that `semantic-lex'\nshould only return LENGTH tokens.  The return value is a token stream.\nEach element is a list, such of the form\n  (symbol start-expression .  end-expression)\nwhere SYMBOL denotes the token type.\nSee `semantic-lex-tokens' variable for details on token types.  END\ndoes not mark the end of the text scanned, only the end of the\nbeginning of text scanned.  Thus, if a string extends past END, the\nend of the return token will be larger than END.  To truly restrict\nscanning, use `narrow-to-region'." (funcall semantic-lex-analyzer start end depth length))

(autoload 'define-lex-analyzer "semantic-lex" "\
Create a single lexical analyzer NAME with DOC.
When an analyzer is called, the current buffer and point are
positioned in a buffer at the location to be analyzed.
CONDITION is an expression which returns t if FORMS should be run.
Within the bounds of CONDITION and FORMS, the use of backquote
can be used to evaluate expressions at compile time.
While forms are running, the following variables will be locally bound:
  `semantic-lex-analysis-bounds' - The bounds of the current analysis.
                  of the form (START . END)
  `semantic-lex-maximum-depth' - The maximum depth of semantic-list
                  for the current analysis.
  `semantic-lex-current-depth' - The current depth of `semantic-list' that has
                  been decended.
  `semantic-lex-end-point' - End Point after match.
                   Analyzers should set this to a buffer location if their
                   match string does not represent the end of the matched text.
  `semantic-lex-token-stream' - The token list being collected.
                   Add new lexical tokens to this list.
Proper action in FORMS is to move the value of `semantic-lex-end-point' to
after the location of the analyzed entry, and to add any discovered tokens
at the beginning of `semantic-lex-token-stream'.
This can be done by using `semantic-lex-push-token'." nil 'macro)

(autoload 'define-lex-regex-analyzer "semantic-lex" "\
Create a lexical analyzer with NAME and DOC that will match REGEXP.
FORMS are evaluated upon a successful match.
See `define-lex-analyzer' for more about analyzers." nil 'macro)

(autoload 'define-lex-simple-regex-analyzer "semantic-lex" "\
Create a lexical analyzer with NAME and DOC that match REGEXP.
TOKSYM is the symbol to use when creating a semantic lexical token.
INDEX is the index into the match that defines the bounds of the token.
Index should be a plain integer, and not specified in the macro as an
expression.
FORMS are evaluated upon a successful match BEFORE the new token is
created.  It is valid to ignore FORMS.
See `define-lex-analyzer' for more about analyzers." nil 'macro)

(autoload 'define-lex-block-analyzer "semantic-lex" "\
Create a lexical analyzer NAME for paired delimiters blocks.
It detects a paired delimiters block or the corresponding open or
close delimiter depending on the value of the variable
`semantic-lex-current-depth'.  DOC is the documentation string of the lexical
analyzer.  SPEC1 and SPECS specify the token symbols and open, close
delimiters used.  Each SPEC has the form:

\(BLOCK-SYM (OPEN-DELIM OPEN-SYM) (CLOSE-DELIM CLOSE-SYM))

where BLOCK-SYM is the symbol returned in a block token.  OPEN-DELIM
and CLOSE-DELIM are respectively the open and close delimiters
identifying a block.  OPEN-SYM and CLOSE-SYM are respectively the
symbols returned in open and close tokens." nil 'macro)

;;;***

;;;### (autoloads (semantic-mru-bookmark-mode global-semantic-mru-bookmark-mode global-semantic-mru-bookmark-mode) "semantic-mru-bookmark" "semantic/semantic-mru-bookmark.el")

(autoload 'global-semantic-mru-bookmark-mode "semantic-mru-bookmark" "\
Toggle global use of option `semantic-mru-bookmark-mode'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(progn (defvar global-semantic-mru-bookmark-mode nil "*If non-nil enable global use of variable `semantic-mru-bookmark-mode'.\nWhen this mode is enabled, changes made to a buffer are highlighted\nuntil the buffer is reparsed.") (custom-add-to-group 'semantic 'global-semantic-mru-bookmark-mode 'custom-variable) (custom-add-load 'global-semantic-mru-bookmark-mode 'semantic-util-modes))

(autoload 'semantic-mru-bookmark-mode "semantic-mru-bookmark" "\
Minor mode for tracking tag-based bookmarks automatically.
Tag based bookmarks a tracked based on editing and viewing habits
and can then be navigated via the MRU bookmark keymap.

\\{semantic-mru-bookmark-mode-map}

With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled." t nil)

;;;***

;;;### (autoloads (semantic-regtest-cmp-results semantic-regtest-create-output semantic-regtest-run-test) "semantic-regtest" "semantic/semantic-regtest.el")

(autoload 'semantic-regtest-run-test "semantic-regtest" nil t nil)

(autoload 'semantic-regtest-create-output "semantic-regtest" "\
Creates the test-output for the current buffer.
The user will be asked for the file-name of the created test-output-file (see
`semantic-regtest-create-output--internal')." t nil)

(autoload 'semantic-regtest-cmp-results "semantic-regtest" "\
Compare two test-outputs and create a suitable formatted result-file.

The user will be asked for four file-names:

   SOURCE-FILE: The underlying source-file for which the test-outputs have
   been created. If current buffer is a semantic-supported buffer then the
   file-name of the current buffer is offered as default.

   TEST-FILE: The regression-testoutput for SOURCE-FILE. It must be an already
   existing file which has been created by `semantic-regtest-create-output' or
   the function `semantic-regtest-create-output--internal'. If a file
   SOURCE-FILE.to exists already in current directory then this file is
   offered as default.

   REF-FILE: The reference testoutput for SOURCE-FILE. TEST-FILE will be
   compared against this file. It must be an already existing file which has
   been created by the command `semantic-regtest-create-output' or the
   function `semantic-regtest-create-output--internal'. If a file
   SOURCE-FILE.ro exists already in current directory then this file is
   offered as default.

   RESULT-FILE: That file will contain the comparisson-result generated by
   `semantic-regtest-cmp-results--internal'. Per default the filename
   SOURCE-FILE.res is offered.

This command calls `semantic-regtest-cmp-results--internal' with that four
file-names. See this function for details about the optional argument
`use-full-path-name' and a description of the format of RESULT-FILE." t nil)

;;;***

;;;### (autoloads (semantic-adopt-external-members semantic-bucketize semantic-flatten-tags-table semantic-unique-tag-table semantic-unique-tag-table-by-name semantic-sort-tags-by-type-decreasing-ci semantic-sort-tags-by-type-increasing-ci semantic-sort-tags-by-name-decreasing-ci semantic-sort-tags-by-name-increasing-ci semantic-sort-tags-by-type-decreasing semantic-sort-tags-by-type-increasing semantic-sort-tags-by-name-decreasing semantic-sort-tags-by-name-increasing) "semantic-sort" "semantic/semantic-sort.el")

(autoload 'semantic-sort-tags-by-name-increasing "semantic-sort" "\
Sort TAGS by name in increasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-name-decreasing "semantic-sort" "\
Sort TAGS by name in decreasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-type-increasing "semantic-sort" "\
Sort TAGS by type in increasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-type-decreasing "semantic-sort" "\
Sort TAGS by type in decreasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-name-increasing-ci "semantic-sort" "\
Sort TAGS by name in increasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-name-decreasing-ci "semantic-sort" "\
Sort TAGS by name in decreasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-type-increasing-ci "semantic-sort" "\
Sort TAGS by type in increasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-sort-tags-by-type-decreasing-ci "semantic-sort" "\
Sort TAGS by type in decreasing order with side effects.
Return the sorted list." nil nil)

(autoload 'semantic-unique-tag-table-by-name "semantic-sort" "\
Scan a list of TAGS, removing duplicate names.
This must first sort the tags by name alphabetically ascending." nil nil)

(autoload 'semantic-unique-tag-table "semantic-sort" "\
Scan a list of TAGS, removing duplicates.
This must first sort the tags by position ascending.
TAGS are removed only if they are equivalent, as can happen when
multiple tag sources are scanned." nil nil)

(autoload 'semantic-flatten-tags-table "semantic-sort" "\
Flatten the tags table TABLE.
All tags in TABLE, and all components of top level tags
in TABLE will appear at the top level of list.
Tags promoted to the top of the list will still appear
unmodified as components of their parent tags." nil nil)

(autoload 'semantic-bucketize "semantic-sort" "\
Sort TAGS into a group of buckets based on tag class.
Unknown classes are placed in a Misc bucket.
Type bucket names are defined by either `semantic-symbol->name-assoc-list'.
If PARENT is specified, then TAGS belong to this PARENT in some way.
This will use `semantic-symbol->name-assoc-list-for-type-parts' to
generate bucket names.
Optional argument FILTER is a filter function to be applied to each bucket.
The filter function will take one argument, which is a list of tokens, and
may re-organize the list with side-effects." nil nil)

(defvar semantic-orphaned-member-metaparent-type "class" "\
In `semantic-adopt-external-members', the type of 'type for metaparents.
A metaparent is a made-up type semantic token used to hold the child list
of orphaned members of a named type.")

(autoload 'semantic-adopt-external-members "semantic-sort" "\
Rebuild TAGS so that externally defined members are regrouped.
Some languages such as C++ and CLOS permit the declaration of member
functions outside the definition of the class.  It is easier to study
the structure of a program when such methods are grouped together
more logically.

This function uses `semantic-tag-external-member-p' to
determine when a potential child is an externally defined member.

Note: Applications which use this function must account for token
types which do not have a position, but have children which *do*
have positions.

Applications should use `semantic-mark-external-member-function'
to modify all tags which are found as externally defined to some
type.  For example, changing the token type for generating extra
buckets with the bucket function." nil nil)

(define-overload semantic-tag-external-member-parent (tag) "Return a parent for TAG when TAG is an external member.\nTAG is an external member if it is defined at a toplevel and\nhas some sort of label defining a parent.  The parent return will\nbe a string.\n\nThe default behavior, if not overridden with\n`tag-member-parent' gets the 'parent extra\nspecifier of TAG.\n\nIf this function is overridden, use\n`semantic-tag-external-member-parent-default' to also\ninclude the default behavior, and merely extend your own.")

(define-overload semantic-tag-external-member-p (parent tag) "Return non-nil if PARENT is the parent of TAG.\nTAG is an external member of PARENT when it is somehow tagged\nas having PARENT as it's parent.\nPARENT and TAG must both be semantic tags.\n\nThe default behavior, if not overridden with\n`tag-external-member-p' is to match :parent attribute in\nthe name of TAG.\n\nIf this function is overridden, use\n`semantic-tag-external-member-children-p-default' to also\ninclude the default behavior, and merely extend your own.")

(define-overload semantic-tag-external-member-children (tag &optional usedb) "Return the list of children which are not *in* TAG.\nIf optional argument USEDB is non-nil, then also search files in\nthe Semantic Database.  If USEDB is a list of databases, search those\ndatabases.\n\nChildren in this case are functions or types which are members of\nTAG, such as the parts of a type, but which are not defined inside\nthe class.  C++ and CLOS both permit methods of a class to be defined\noutside the bounds of the class' definition.\n\nThe default behavior, if not overridden with\n`tag-external-member-children' is to search using\n`semantic-tag-external-member-p' in all top level definitions\nwith a parent of TAG.\n\nIf this function is overridden, use\n`semantic-tag-external-member-children-default' to also\ninclude the default behavior, and merely extend your own.")

(define-overload semantic-tag-external-class (tag) "Return a list of real tags that faux TAG might represent.\n\nIn some languages, a method can be defined on an object which is\nnot in the same file.  In this case,\n`semantic-adopt-external-members' will create a faux-tag.  If it\nis necessary to get the tag from which for faux TAG was most\nlikely derived, then this function is needed." (unless (semantic-tag-faux-p tag) (signal 'wrong-type-argument (list tag 'semantic-tag-faux-p))) (:override))

;;;***

;;;### (autoloads nil "semantic-tag-file" "semantic/semantic-tag-file.el")

(define-overload semantic-go-to-tag (tag &optional parent) "Go to the location of TAG.\nTAG may be a stripped element, in which case PARENT specifies a\nparent tag that has position information.\nDifferent behaviors are provided depending on the type of tag.\nFor example, dependencies (includes) will seek out the file that is\ndepended on (see `semantic-dependency-tag-file'." (:override (unless (and (eq (semantic-tag-class tag) 'include) (let ((f (semantic-dependency-tag-file tag))) (when f (set-buffer (find-file-noselect f)) (point)))) (cond ((semantic-tag-buffer tag) (set-buffer (semantic-tag-buffer tag))) ((semantic-tag-file-name tag) (set-buffer (find-file-noselect (semantic-tag-file-name tag)))) ((and parent (semantic-tag-p parent) (semantic-tag-buffer parent)) (set-buffer (semantic-tag-buffer parent))) ((and parent (semantic-tag-p parent) (semantic-tag-file-name parent)) (set-buffer (find-file-noselect (semantic-tag-file-name parent)))) (t nil)) (cond ((semantic-tag-with-position-p tag) (goto-char (semantic-tag-start tag))) ((semantic-tag-with-position-p parent) (goto-char (semantic-tag-start parent)) (re-search-forward (semantic-tag-name tag) (semantic-tag-end parent) t)) (t (goto-char (point-min)) (re-search-forward (semantic-tag-name tag) nil t))))))

(defvar semantic-dependency-include-path nil "\
Defines the include path used when searching for files.
This should be a list of directories to search which is specific
to the file being included.

If `semantic-dependency-tag-file' is overridden for a given
language, this path is most likely ignored.

This function, reguardless of being overriden, caches the located
dependency file location in the tag property `dependency-file'.
If you override this function, you do not need to implement your
own cache.  Each time the buffer is fully reparsed, the cache
will be reset.

TODO: use ffap.el to locate such items.")

(define-overload semantic-dependency-tag-file (&optional tag) "Find the filename represented from TAG.\nDepends on `semantic-dependency-include-path' for searching.  Always searches\n`.' first, then searches additional paths." (or tag (setq tag (car (semantic-find-tag-by-overlay nil)))) (unless (semantic-tag-of-class-p tag 'include) (signal 'wrong-type-argument (list tag 'include))) (save-excursion (cond ((semantic-tag-buffer tag) (set-buffer (semantic-tag-buffer tag))) ((semantic-tag-file-name tag) (set-buffer (find-file-noselect (semantic-tag-file-name tag))))) (if (and (fboundp 'ede-expand-filename) ede-minor-mode (ede-expand-filename (ede-toplevel) (semantic-tag-name tag))) (ede-expand-filename (ede-toplevel) (semantic-tag-name tag)) (let ((result (if (semantic--tag-get-property tag 'dependency-file) (semantic--tag-get-property tag 'dependency-file) (:override (save-excursion (let* ((name (semantic-tag-name tag))) (semantic-dependency-find-file-on-path name (semantic-tag-include-system-p tag)))))))) (if (stringp result) (progn (semantic--tag-put-property tag 'dependency-file result) result) (semantic--tag-put-property tag 'dependency-file 'none) nil)))))

(define-overload semantic-prototype-file (buffer) "Return a file in which prototypes belonging to BUFFER should be placed.\nDefault behavior (if not overridden) looks for a token specifying the\nprototype file, or the existence of an EDE variable indicating which\nfile prototypes belong in." (:override (if (and (fboundp 'ede-header-file) ede-minor-mode) (save-excursion (set-buffer buffer) (ede-header-file)) (save-excursion (set-buffer buffer) (if (re-search-forward "::Header:: \\([a-zA-Z0-9.]+\\)" nil t) (match-string 1))))))

;;;***

;;;### (autoloads (semantic-tag-protected-p) "semantic-tag-ls" "semantic/semantic-tag-ls.el")

(define-overload semantic-tag-calculate-parent (tag) "Attempt to calculate the parent of TAG.\nThe default behavior (if not overriden with `tag-calculate-parent')\nis to search a buffer found with TAG, and if externally defined,\nsearch locally, then semanticdb for that tag (when enabled.)")

(define-overload semantic-tag-protection (tag &optional parent) "Return protection information about TAG with optional PARENT.\nThis function returns on of the following symbols:\n   nil        - No special protection.  Language dependent.\n   'public    - Anyone can access this TAG.\n   'private   - Only methods in the local scope can access TAG.\n   'protected - Like private for outside scopes, like public for child\n                classes.\nSome languages may choose to provide additional return symbols specific\nto themselves.  Use of this function should allow for this.\n\nThe default behavior (if not overridden with `tag-protection'\nis to return a symbol based on type modifiers." (and (not parent) (semantic-tag-overlay tag) (semantic-tag-buffer tag) (setq parent (semantic-tag-calculate-parent tag))) (:override))

(autoload 'semantic-tag-protected-p "semantic-tag-ls" "\
Non-nil if TAG is is protected.
PROTECTION is a symbol which can be returned by the method
`semantic-tag-protection'.
PARENT is the parent data type which contains TAG.

For these PROTECTIONs, true is returned if TAG is:
@table @asis
@item nil
  Always true
@item  private
  True if nil.
@item protected
  True if private or nil.
@item public
  True if private, protected, or nil.
@end table" nil nil)

(define-overload semantic-tag-abstract-p (tag &optional parent) "Return non nil if TAG is abstract.\nOptional PARENT is the parent tag of TAG.\nIn UML, abstract methods and classes have special meaning and behavior\nin how methods are overridden.  In UML, abstract methods are italicized.\n\nThe default behavior (if not overridden with `tag-abstract-p'\nis to return true if `abstract' is in the type modifiers.")

(define-overload semantic-tag-leaf-p (tag &optional parent) "Return non nil if TAG is leaf.\nOptional PARENT is the parent tag of TAG.\nIn UML, leaf methods and classes have special meaning and behavior.\n\nThe default behavior (if not overridden with `tag-leaf-p'\nis to return true if `leaf' is in the type modifiers.")

(define-overload semantic-tag-static-p (tag &optional parent) "Return non nil if TAG is static.\nOptional PARENT is the parent tag of TAG.\nIn UML, static methods and attributes mean that they are allocated\nin the parent class, and are not instance specific.\nUML notation specifies that STATIC entries are underlined.")

(define-overload semantic-tag-full-name (tag &optional stream-or-buffer) "Return the fully qualified name of TAG in the package hierarchy.\nSTREAM-OR-BUFFER can be anything convertable by `semantic-something-to-stream',\nbut must be a toplevel semantic tag stream that contains TAG.\nA Package Hierarchy is defined in UML by the way classes and methods\nare organized on disk.  Some language use this concept such that a\nclass can be accessed via it's fully qualified name, (such as Java.)\nOther languages qualify names within a Namespace (such as C++) which\nresult in a different package like structure.  Languages which do not\noverride this function with `tag-full-name' will use\n`semantic-tag-name'.  Override functions only need to handle\nSTREAM-OR-BUFFER with a tag stream value, or nil." (let ((stream (semantic-something-to-tag-table (or stream-or-buffer tag)))) (:override-with-args (tag stream))))

;;;***

;;;### (autoloads nil "semantic-tag" "semantic/semantic-tag.el")

(define-overload semantic-tag-alias-definition (tag) "Return the definition TAG is an alias.\nThe returned value is a tag of the class that\n`semantic-tag-alias-class' returns for TAG.\nThe default is to return the value of the :definition attribute.\nReturn nil if TAG is not of class 'alias." (when (semantic-tag-of-class-p tag 'alias) (:override (semantic-tag-get-attribute tag :definition))))

(define-overload semantic-tag-components (tag) "Return a list of components for TAG.\nA Component is a part of TAG which itself may be a TAG.\nExamples include the elements of a structure in a \ntag of class `type, or the list of arguments to a\ntag of class 'function.")

(define-overload semantic-tag-components-with-overlays (tag) "Return the list of top level components belonging to TAG.\nChildren are any sub-tags which contain overlays.\n\nDefault behavior is to get `semantic-tag-components' in addition\nto the components of an anonymous types (if applicable.)\n\nNote for language authors:\n  If a mode defines a language tag that has tags in it with overlays\nyou should still return them with this function.\nIgnoring this step will prevent several features from working correctly.")

(define-overload semantic-obtain-foreign-tag (&optional tag) "Obtain a foreign tag from TAG.\nTAG defaults to the tag at point in current buffer.\nReturn the obtained foreign tag or nil if failed." (semantic-foreign-tag tag))

(define-overload semantic-insert-foreign-tag (foreign-tag) "Insert FOREIGN-TAG into the current buffer.\nSignal an error if FOREIGN-TAG is not a valid foreign tag.\nThis function is overridable with the symbol `insert-foreign-tag'." (semantic-foreign-tag-check foreign-tag) (:override) (message (semantic-format-tag-summarize foreign-tag)))

;;;***

;;;### (autoloads (semantic-default-texi-setup) "semantic-texi" "semantic/semantic-texi.el")

(autoload 'semantic-default-texi-setup "semantic-texi" "\
Set up a buffer for parsing of Texinfo files." nil nil)

(add-hook 'texinfo-mode-hook 'semantic-default-texi-setup)

;;;***

;;;### (autoloads (semantic-stickyfunc-mode global-semantic-stickyfunc-mode global-semantic-stickyfunc-mode semantic-show-parser-state-mode global-semantic-show-parser-state-mode global-semantic-show-parser-state-mode semantic-show-unmatched-syntax-mode global-semantic-show-unmatched-syntax-mode global-semantic-show-unmatched-syntax-mode semantic-highlight-edits-mode global-semantic-highlight-edits-mode global-semantic-highlight-edits-mode) "semantic-util-modes" "semantic/semantic-util-modes.el")

(autoload 'global-semantic-highlight-edits-mode "semantic-util-modes" "\
Toggle global use of option `semantic-highlight-edits-mode'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(progn (defvar global-semantic-highlight-edits-mode nil "*If non-nil enable global use of variable `semantic-highlight-edits-mode'.\nWhen this mode is enabled, changes made to a buffer are highlighted\nuntil the buffer is reparsed.") (custom-add-to-group 'semantic 'global-semantic-highlight-edits-mode 'custom-variable) (custom-add-load 'global-semantic-highlight-edits-mode 'semantic-util-modes))

(autoload 'semantic-highlight-edits-mode "semantic-util-modes" "\
Minor mode for highlighting changes made in a buffer.
Changes are tracked by semantic so that the incremental parser can work
properly.
This mode will highlight those changes as they are made, and clear them
when the incremental parser accounts for those edits.
With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled." t nil)

(autoload 'global-semantic-show-unmatched-syntax-mode "semantic-util-modes" "\
Toggle global use of option `semantic-show-unmatched-syntax-mode'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(progn (defvar global-semantic-show-unmatched-syntax-mode nil "*If non-nil, enable global use of `semantic-show-unmatched-syntax-mode'.\nWhen this mode is enabled, syntax in the current buffer which the\nsemantic parser cannot match is highlighted with a red underline.") (custom-add-to-group 'semantic 'global-semantic-show-unmatched-syntax-mode 'custom-variable) (custom-add-load 'global-semantic-show-unmatched-syntax-mode 'semantic-util-modes))

(autoload 'semantic-show-unmatched-syntax-mode "semantic-util-modes" "\
Minor mode to highlight unmatched lexical syntax tokens.
When a parser executes, some elements in the buffer may not match any
parser rules.  These text characters are considered unmatched syntax.
Often time, the display of unmatched syntax can expose coding
problems before the compiler is run.

With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled.

\\{semantic-show-unmatched-syntax-mode-map}" t nil)

(progn (defvar global-semantic-show-parser-state-mode nil "*If non-nil enable global use of `semantic-show-parser-state-mode'.\nWhen enabled, the current parse state of the current buffer is displayed\nin the mode line. See `semantic-show-parser-state-marker' for details\non what is displayed.") (custom-add-to-group 'semantic 'global-semantic-show-parser-state-mode 'custom-variable) (custom-add-load 'global-semantic-show-parser-state-mode 'semantic-util-modes))

(autoload 'global-semantic-show-parser-state-mode "semantic-util-modes" "\
Toggle global use of option `semantic-show-parser-state-mode'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(autoload 'semantic-show-parser-state-mode "semantic-util-modes" "\
Minor mode for displaying parser cache state in the modeline.
The cache can be in one of three states.  They are
Up to date, Partial reprase needed, and Full reparse needed.
The state is indicated in the modeline with the following characters:
 `-'  ->  The cache is up to date.
 `!'  ->  The cache requires a full update.
 `~'  ->  The cache needs to be incrementally parsed.
 `%'  ->  The cache is not currently parseable.
 `@'  ->  Auto-parse in progress (not set here.)
With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled." t nil)

(autoload 'global-semantic-stickyfunc-mode "semantic-util-modes" "\
Toggle global use of option `semantic-stickyfunc-mode'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(progn (defvar global-semantic-stickyfunc-mode nil "*If non-nil, enable global use of `semantic-stickyfunc-mode'.\nThis minor mode only works for Emacs 21 or later.\nWhen enabled, the header line is enabled, and the first line\nof the current function or method is displayed in it.\nThis makes it appear that the first line of that tag is\n`sticky' to the top of the window.") (custom-add-to-group 'semantic 'global-semantic-stickyfunc-mode 'custom-variable) (custom-add-load 'global-semantic-stickyfunc-mode 'semantic-util-modes))

(autoload 'semantic-stickyfunc-mode "semantic-util-modes" "\
Minor mode to show the title of a tag in the header line.
Enables/disables making the header line of functions sticky.
A function (or other tag class specified by
`semantic-stickyfunc-sticky-classes') has a header line, meaning the
first line which describes the rest of the construct.  This first
line is what is displayed in the Emacs 21 header line.

With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled." t nil)

;;;***

;;;### (autoloads (semantic-bovinate-toplevel semantic-refresh-tags-safe semantic-fetch-tags semantic-parse-region-default) "semantic" "semantic/semantic.el")

(eval-and-compile (defvar semantic-version "2.0pre4" "Current version of Semantic."))

(autoload 'semantic-parse-region-default "semantic" "\
Parse the area between START and END, and return any tags found.
If END needs to be extended due to a lexical token being too large, it
will be silently ignored.
Optional arguments:
NONTERMINAL is the rule to start parsing at if it is known.
DEPTH specifies the lexical depth to scan.
RETURNONERROR specifies that parsing should end when encountering
unterminated syntax." nil nil)

(autoload 'semantic-fetch-tags "semantic" "\
Fetch semantic tags from the current buffer.
If the buffer cache is up to date, return that.
If the buffer cache is out of date, attempt an incremental reparse.
If the buffer has not been parsed before, or if the incremental reparse
fails, then parse the entire buffer.
If a lexcial error had been previously discovered and the buffer
was marked unparseable, then do nothing, and return the cache." nil nil)

(autoload 'semantic-refresh-tags-safe "semantic" "\
Refreshes the current buffer's tags safely.

Return non-nil if the refresh was successful.
Return nil if there is some sort of syntax error preventing a reparse.

Does nothing if the current buffer doesn't need reparsing." nil nil)

(autoload 'semantic-bovinate-toplevel "semantic" "\
Backward Compatibility Function." nil nil)

(make-obsolete 'semantic-bovinate-toplevel 'semantic-fetch-tags)

(defsubst semantic-fetch-available-tags nil "\
Fetch available semantic tags from the current buffer.
That is, return tags currently in the cache without parsing the
current buffer.
Parse operations happen asynchronously when needed on Emacs idle time.
Use the `semantic-after-toplevel-cache-change-hook' and
`semantic-after-partial-cache-change-hook' hooks to synchronize with
new tags when they become available." semantic--buffer-cache)

;;;***

;;;### (autoloads (semanticdb-ebrowse-load-helper semanticdb-load-ebrowse-caches semanticdb-create-ebrowse-database) "semanticdb-ebrowse" "semantic/semanticdb-ebrowse.el")

(autoload 'semanticdb-create-ebrowse-database "semanticdb-ebrowse" "\
Create an EBROSE database for directory DIR.
The database file is stored in ~/.semanticdb, or whichever directory
is specified by `semanticdb-default-system-save-directory'." t nil)

(autoload 'semanticdb-load-ebrowse-caches "semanticdb-ebrowse" "\
Load all semanticdb controlled EBROWSE caches." t nil)

(autoload 'semanticdb-ebrowse-load-helper "semanticdb-ebrowse" "\
Create the semanticdb database via ebrowse for directory.
If DIRECTORY is found to be defunct, it won't load the DB, and will
warn instead." nil nil)

;;;***

;;;### (autoloads (semanticdb-full-filename semanticdb-live-p semanticdb-file-loaded-p semanticdb-project-database-file semanticdb-persistent-path semanticdb-default-save-directory semanticdb-default-file-name) "semanticdb-file" "semantic/semanticdb-file.el")

(defvar semanticdb-default-file-name "semantic.cache" "\
*File name of the semantic tag cache.")

(defvar semanticdb-default-save-directory nil "\
*Directory name where semantic cache files are stored.
If this value is nil, files are saved in the current directory.  If the value
is a valid directory, then it overrides `semanticdb-default-file-name' and
stores caches in a coded file name in this directory.")

(defvar semanticdb-persistent-path '(project) "\
*List of valid paths that semanticdb will cache tags to.
When `global-semanticdb-minor-mode' is active, tag lists will
be saved to disk when Emacs exits.  Not all directories will have
tags that should be saved.
The value should be a list of valid paths.  A path can be a string,
indicating a directory in which to save a variable.  An element in the
list can also be a symbol.  Valid symbols are `never', which will
disable any saving anywhere, `always', which enables saving
everywhere, or `project', which enables saving in any directory that
passes a list of predicates in `semanticdb-project-predicate-functions'.")

(autoload 'semanticdb-project-database-file "semanticdb-file" "Database of file tables saved to disk." nil nil)

(autoload 'semanticdb-file-loaded-p "semanticdb-file" "\
Return the project belonging to FILENAME if it was already loaded." nil nil)

(autoload 'semanticdb-live-p "semanticdb-file" "\
Return non-nil if the file associated with OBJ is live.
Live databases are objects associated with existing directories." nil nil)

(autoload 'semanticdb-full-filename "semanticdb-file" "\
Fetch the full filename that OBJ refers to." nil nil)

;;;***

;;;### (autoloads (semanticdb-find-tags-external-children-of-type semanticdb-brute-find-tags-by-class semanticdb-brute-deep-find-tags-for-completion semanticdb-brute-deep-find-tags-by-name semanticdb-deep-find-tags-for-completion semanticdb-deep-find-tags-by-name-regexp semanticdb-deep-find-tags-by-name semanticdb-find-tags-by-class semanticdb-find-tags-for-completion semanticdb-find-tags-by-name-regexp semanticdb-find-tags-by-name semanticdb-find-tags-collector semanticdb-find-result-nth-in-buffer semanticdb-find-result-nth semanticdb-find-result-with-nil-p semanticdb-find-results-p semanticdb-strip-find-results semanticdb-find-test-translate-path semanticdb-find-translate-path-default semanticdb-find-default-throttle) "semanticdb-find" "semantic/semanticdb-find.el")

(defvar semanticdb-find-throttle-custom-list '(repeat (radio (const 'local) (const 'project) (const 'unloaded) (const 'system) (const 'recursive) (const 'omniscience))) "\
Customization values for semanticdb find throttle.
See `semanticdb-find-throttle' for details.")

(defvar semanticdb-find-default-throttle '(project unloaded system recursive) "\
The default throttle for `semanticdb-find' routines.
The throttle controls how detailed the list of database
tables is for a symbol lookup.  The value is a list with
the following keys:
  `file'       - The file the search is being performed from.
                 This option is here for completeness only, and
                 is assumed to always be on.
  `local'      - Tables from the same local directory are included.
                 This includes files directly referenced by a file name
                 which might be in a different directory.
  `project'    - Tables from the same local project are included
                 If `project' is specified, then `local' is assumed.
  `unloaded'   - If a table is not in memory, load it.  If it is not cached
                 on disk either, get the source, parse it, and create
                 the table.
  `system'     - Tables from system databases.  These are specifically
                 tables from system header files, or language equivalent.
  `recursive'  - For include based searches, includes tables referenced
                 by included files.
  `omniscience' - Included system databases which are omniscience, or
                 somehow know everything.  Omniscience databases are found
                 in `semanticdb-project-system-databases'.
                 The Emacs Lisp system DB is an omniscience database.")

(autoload 'semanticdb-find-translate-path-default "semanticdb-find" "\
Translate PATH into a list of semantic tables.
If BRUTISH is non nil, return all tables associated with PATH.
Default action as described in `semanticdb-find-translate-path'." nil nil)

(define-overload semanticdb-find-table-for-include (includetag &optional table) "For a single INCLUDETAG found in TABLE, find a `semanticdb-table' object\nINCLUDETAG is a semantic TAG of class 'include.\nTABLE as defined by `semantic-something-to-tag-table' to identify\nwhere the tag came from.  TABLE is optional if INCLUDETAG has an\noverlay of :filename attribute.")

(autoload 'semanticdb-find-test-translate-path "semanticdb-find" "\
Call and output results of `semanticdb-find-translate-path'.
With ARG non-nil, specify a BRUTISH translation.
See `semanticdb-find-default-throttle' and `semanticdb-project-roots'
for details on how this list is derived." t nil)

(autoload 'semanticdb-strip-find-results "semanticdb-find" "\
Strip a semanticdb search RESULTS to exclude objects.
This makes it appear more like the results of a `semantic-find-' call.
Optional FIND-FILE-MATCH loads all files associated with RESULTS
into buffers.  This has the side effect of enabling `semantic-tag-buffer' to
return a value." nil nil)

(autoload 'semanticdb-find-results-p "semanticdb-find" "\
Non-nil if RESULTP is in the form of a semanticdb search result.
This query only really tests the first entry in the list that is RESULTP,
but should be good enough for debugging assertions." nil nil)

(autoload 'semanticdb-find-result-with-nil-p "semanticdb-find" "\
Non-nil of RESULTP is in the form of a semanticdb search result.
nil is a valid value where a TABLE usually is, but only if the TAG
results include overlays.
This query only really tests the first entry in the list that is RESULTP,
but should be good enough for debugging assertions." nil nil)

(autoload 'semanticdb-find-result-nth "semanticdb-find" "\
In RESULT, return the Nth search result.
This is a 0 based search result, with the first match being element 0.

The returned value is a cons cell: (TAG . TABLE) where TAG
is the tag at the Nth position.  TABLE is the semanticdb table where
the TAG was found.  Sometimes TABLE can be nil." nil nil)

(autoload 'semanticdb-find-result-nth-in-buffer "semanticdb-find" "\
In RESULT, return the Nth search result.
Like `semanticdb-find-result-nth', except that only the TAG
is returned, and the buffer it is found it will be made current.
If the result tag has no position information, the originating buffer
is still made current." nil nil)

(autoload 'semanticdb-find-tags-collector "semanticdb-find" "\
Search for all tags returned by FUNCTION over PATH.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer.
If optional argument BRUTISH is non-nil, then ignore include statements,
and search all tables in this project tree." nil nil)

(autoload 'semanticdb-find-tags-by-name "semanticdb-find" "\
Search for all tags matching NAME on PATH.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-find-tags-by-name-regexp "semanticdb-find" "\
Search for all tags matching REGEXP on PATH.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-find-tags-for-completion "semanticdb-find" "\
Search for all tags matching PREFIX on PATH.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-find-tags-by-class "semanticdb-find" "\
Search for all tags of CLASS on PATH.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-deep-find-tags-by-name "semanticdb-find" "\
Search for all tags matching NAME on PATH.
Search also in all components of top level tags founds.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-deep-find-tags-by-name-regexp "semanticdb-find" "\
Search for all tags matching REGEXP on PATH.
Search also in all components of top level tags founds.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-deep-find-tags-for-completion "semanticdb-find" "\
Search for all tags matching PREFIX on PATH.
Search also in all components of top level tags founds.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-brute-deep-find-tags-by-name "semanticdb-find" "\
Search for all tags matching NAME on PATH.
See `semanticdb-find-translate-path' for details on PATH.
The argument BRUTISH will be set so that searching includes all tables
in the current project.
FIND-FILE-MATCH indicates that any time a matchi is found, the file
associated wit that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-brute-deep-find-tags-for-completion "semanticdb-find" "\
Search for all tags matching PREFIX on PATH.
See `semanticdb-find-translate-path' for details on PATH.
The argument BRUTISH will be set so that searching includes all tables
in the current project.
FIND-FILE-MATCH indicates that any time a matchi is found, the file
associated wit that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-brute-find-tags-by-class "semanticdb-find" "\
Search for all tags of CLASS on PATH.
See `semanticdb-find-translate-path' for details on PATH.
The argument BRUTISH will be set so that searching includes all tables
in the current project.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

(autoload 'semanticdb-find-tags-external-children-of-type "semanticdb-find" "\
Search for all tags defined outside of TYPE w/ TYPE as a parent.
See `semanticdb-find-translate-path' for details on PATH.
FIND-FILE-MATCH indicates that any time a match is found, the file
associated with that tag should be loaded into a buffer." nil nil)

;;;***

;;;### (autoloads (semanticdb-find-nonterminal-by-function semanticdb-find-nonterminal-by-extra-spec-value semanticdb-find-nonterminal-by-extra-spec semanticdb-find-nonterminal-by-property semanticdb-find-nonterminal-by-type semanticdb-find-nonterminal-by-name-regexp semanticdb-find-nonterminal-by-name semanticdb-find-nonterminal-by-token) "semanticdb-search" "semantic/semanticdb-search.el")

(autoload 'semanticdb-find-nonterminal-by-token "semanticdb-search" "\
Find all occurances of nonterminals with token TOKEN in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES, DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN-LIST) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-name "semanticdb-search" "\
Find all occurances of nonterminals with name NAME in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES, DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-name-regexp "semanticdb-search" "\
Find all occurances of nonterminals with name matching REGEX in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN-LIST) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-type "semanticdb-search" "\
Find all nonterminals with a type of TYPE in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN-LIST) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-property "semanticdb-search" "\
Find all nonterminals with a PROPERTY equal to VALUE in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN-LIST) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-extra-spec "semanticdb-search" "\
Find all nonterminals with a SPEC in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN-LIST) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-extra-spec-value "semanticdb-search" "\
Find all nonterminals with a SPEC equal to VALUE in databases.
See `semanticdb-find-nonterminal-by-function' for details on DATABASES,
SEARCH-PARTS, SEARCH-INCLUDES DIFF-MODE, FIND-FILE-MATCH and IGNORE-SYSTEM.
Return a list ((DB-TABLE . TOKEN-LIST) ...)." nil nil)

(autoload 'semanticdb-find-nonterminal-by-function "semanticdb-search" "\
Find all occurances of nonterminals which match FUNCTION.
Search in all DATABASES.  If DATABASES is nil, search a range of
associated databases calculated `semanticdb-current-database-list' and
DATABASES is a list of variable `semanticdb-project-database' objects.
When SEARCH-PARTS is non-nil the search will include children of tags.
When SEARCH-INCLUDES is non-nil, the search will include dependency files.
When DIFF-MODE is non-nil, search databases which are of a different mode.
A Mode is the `major-mode' that file was in when it was last parsed.
When FIND-FILE-MATCH is non-nil, the make sure any found token's file is
in an Emacs buffer.
When IGNORE-SYSTEM is non-nil, system libraries are not searched.
Return a list ((DB-TABLE . TOKEN-OR-TOKEN-LIST) ...)." nil nil)

;;;***

;;;### (autoloads (semanticdb-load-system-caches semanticdb-create-system-database semanticdb-default-system-save-directory) "semanticdb-system" "semantic/semanticdb-system.el")

(defvar semanticdb-default-system-save-directory (expand-file-name "~/.semanticdb") "\
*Directory name where semantic cache files for system headers are stored.
System files cannot have caches stored near them because users rarely have
write permission to such paths.")

(autoload 'semanticdb-create-system-database "semanticdb-system" "\
Create a system database starting at PATH.
PATH should be a top level directory for a series of files containing
declarations for SYSTEM files.  In C, this would be header filaes.
CLASS is the class for the database to create.  Only child classes
of symbol `semanticdb-project-database-system' are accepted." t nil)

(autoload 'semanticdb-load-system-caches "semanticdb-system" "\
Load all system databases that were previously saved." t nil)

;;;***

;;;### (autoloads (semanticdb-file-stream semanticdb-file-table-object global-semanticdb-minor-mode semanticdb-minor-mode-p semanticdb-current-database semanticdb-global-mode) "semanticdb" "semantic/semanticdb.el")

(progn (defvar semanticdb-global-mode nil "*If non-nil enable the use of `semanticdb-minor-mode'.") (custom-add-to-group 'semantic 'semanticdb-global-mode 'custom-variable) (custom-add-load 'semanticdb-global-mode 'semanticdb))

(defvar semanticdb-current-database nil "\
For a given buffer, this is the currently active database.")

(autoload 'semanticdb-current-database "semanticdb" "\
Return the currently active database." nil nil)

(autoload 'semanticdb-minor-mode-p "semanticdb" "\
Return non-nil if `semanticdb-minor-mode' is active." nil nil)

(autoload 'global-semanticdb-minor-mode "semanticdb" "\
Toggle the use of `semanticdb-minor-mode'.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(autoload 'semanticdb-file-table-object "semanticdb" "\
Return a semanticdb table belonging to FILE.
If file has database tags available in the database, return it.
If file does not have tags available, and DONTLOAD is nil,
then load the tags for FILE, and create a new table object for it.
DONTLOAD does not affect the creation of new database objects." nil nil)

(autoload 'semanticdb-file-stream "semanticdb" "\
Return a list of tags belonging to FILE.
If file has database tags available in the database, return them.
If file does not have tags available, then load the file, and create them." nil nil)

;;;***

;;;### (autoloads (senator-try-expand-semantic global-senator-minor-mode senator-minor-mode senator-word-search-backward senator-re-search-backward senator-search-backward senator-word-search-forward senator-re-search-forward senator-search-forward senator-completion-menu-popup senator-complete-symbol senator-jump-regexp senator-jump senator-previous-tag senator-next-tag senator-step-at-start-end-tag-classes senator-step-at-tag-classes global-senator-minor-mode) "senator" "semantic/senator.el")

(progn (defvar global-senator-minor-mode nil "*If non-nil enable global use of senator minor mode.") (custom-add-to-group 'senator 'global-senator-minor-mode 'custom-variable) (custom-add-load 'global-senator-minor-mode 'senator))

(defvar senator-step-at-tag-classes nil "\
*List of tag classes where to step.
A tag class is a symbol like 'variable, 'function, 'type, or other.
If nil navigation steps at any tag found.  This is a buffer local
variable.  It can be set in a mode hook to get a specific langage
navigation.")

(defvar senator-step-at-start-end-tag-classes '(function) "\
*List of tag classes where to step at start and end.
A tag class is a symbol like 'variable, 'function, 'type, or other.
If nil, navigation only step at beginning of tags.  If t, step at
start and end of any tag where it is allowed to step.  Also, stepping
at start and end of a tag prevent stepping inside its components.
This is a buffer local variable.  It can be set in a mode hook to get
a specific langage navigation.")

(autoload 'senator-next-tag "senator" "\
Navigate to the next Semantic tag.
Return the tag or nil if at end of buffer." t nil)

(autoload 'senator-previous-tag "senator" "\
Navigate to the previous Semantic tag.
Return the tag or nil if at beginning of buffer." t nil)

(autoload 'senator-jump "senator" "\
Jump to the semantic symbol SYM.

If optional IN-CONTEXT is non-nil jump in the local type's context
\(see function `senator-current-type-context').  If optional
NO-DEFAULT is non-nil do not provide a default value.

When called interactively you can combine the IN-CONTEXT and
NO-DEFAULT switches like this:

- \\[universal-argument]       IN-CONTEXT.
- \\[universal-argument] -     NO-DEFAULT.
- \\[universal-argument] \\[universal-argument]   IN-CONTEXT + NO-DEFAULT." t nil)

(autoload 'senator-jump-regexp "senator" "\
Jump to the semantic symbol SYMREGEX.
SYMREGEX is treated as a regular expression.

If optional IN-CONTEXT is non-nil jump in the local type's context
\(see function `senator-current-type-context').  If optional
NO-DEFAULT is non-nil do not provide a default value and move to the
next match of SYMREGEX.  NOTE: Doesn't actually work yet.

When called interactively you can combine the IN-CONTEXT and
NO-DEFAULT switches like this:

- \\[universal-argument]       IN-CONTEXT.
- \\[universal-argument] -     NO-DEFAULT.
- \\[universal-argument] \\[universal-argument]   IN-CONTEXT + NO-DEFAULT." t nil)

(autoload 'senator-complete-symbol "senator" "\
Complete the current symbol under point.
If optional argument CYCLE-ONCE is non-nil, only cycle through the list
of completions once, doing nothing where there are no more matches." t nil)

(autoload 'senator-completion-menu-popup "senator" "\
Popup a completion menu for the symbol at point.
The popup menu displays all of the possible completions for the symbol
it was invoked on.  To automatically split large menus this function
use `imenu--mouse-menu' to handle the popup menu." t nil)

(autoload 'senator-search-forward "senator" "\
Search in tag names forward from point for STRING.
Set point to the end of the occurrence found, and return point.
See also the function `search-forward' for details on the BOUND,
NOERROR and COUNT arguments." t nil)

(autoload 'senator-re-search-forward "senator" "\
Search in tag names forward from point for regular expression REGEXP.
Set point to the end of the occurrence found, and return point.
See also the function `re-search-forward' for details on the BOUND,
NOERROR and COUNT arguments." t nil)

(autoload 'senator-word-search-forward "senator" "\
Search in tag names forward from point for WORD.
Set point to the end of the occurrence found, and return point.
See also the function `word-search-forward' for details on the BOUND,
NOERROR and COUNT arguments." t nil)

(autoload 'senator-search-backward "senator" "\
Search in tag names backward from point for STRING.
Set point to the beginning of the occurrence found, and return point.
See also the function `search-backward' for details on the BOUND,
NOERROR and COUNT arguments." t nil)

(autoload 'senator-re-search-backward "senator" "\
Search in tag names backward from point for regular expression REGEXP.
Set point to the beginning of the occurrence found, and return point.
See also the function `re-search-backward' for details on the BOUND,
NOERROR and COUNT arguments." t nil)

(autoload 'senator-word-search-backward "senator" "\
Search in tag names backward from point for WORD.
Set point to the beginning of the occurrence found, and return point.
See also the function `word-search-backward' for details on the BOUND,
NOERROR and COUNT arguments." t nil)

(autoload 'senator-minor-mode "senator" "\
Toggle senator minor mode.
With prefix argument ARG, turn on if positive, otherwise off.  The
minor mode can be turned on only if semantic feature is available and
the current buffer was set up for parsing.  Return non-nil if the
minor mode is enabled.

\\{senator-mode-map}" t nil)

(autoload 'global-senator-minor-mode "senator" "\
Toggle global use of senator minor mode.
If ARG is positive, enable, if it is negative, disable.
If ARG is nil, then toggle." t nil)

(autoload 'senator-try-expand-semantic "senator" "\
Attempt inline completion at the cursor.
Use Semantic, or the semantic database to look up possible
completions.  The argument OLD has to be nil the first call of this
function.  It returns t if a unique, possibly partial, completion is
found, nil otherwise." nil nil)

;;;***

;;;### (autoloads (bison->wisent) "bison-wisent" "wisent/bison-wisent.el")

(autoload 'bison->wisent "bison-wisent" "\
Treat the current buffer as a YACC or BISON file, and translate to wisent.
Replaces all comments with wisent compatible comments.
Finds % commands that wisent cannot handle, and comments them out.
Deletes all actions, replacing them with small comments." t nil)

;;;***

;;;### (autoloads (wisent-byte-compile-grammar wisent-compile-grammar wisent-toggle-verbose-flag) "wisent-comp" "wisent/wisent-comp.el")

(defvar wisent-verbose-flag nil "\
*Non-nil means to report verbose information on generated parser.")

(autoload 'wisent-toggle-verbose-flag "wisent-comp" "\
Toggle whether to report verbose information on generated parser." t nil)

(autoload 'wisent-compile-grammar "wisent-comp" "\
Compile the LALR(1) GRAMMAR.

GRAMMAR is a list (TOKENS ASSOCS . NONTERMS) where:

- TOKENS is a list of terminal symbols (tokens).

- ASSOCS is nil, or an alist of (ASSOC-TYPE . ASSOC-VALUE) elements
  describing the associativity of TOKENS.  ASSOC-TYPE must be one of
  the `default-prec' `nonassoc', `left' or `right' symbols.  When
  ASSOC-TYPE is `default-prec', ASSOC-VALUE must be nil or t (the
  default).  Otherwise it is a list of tokens which must have been
  previously declared in TOKENS.

- NONTERMS is a list of nonterminal definitions.

Optional argument START-LIST specify the possible grammar start
symbols.  This is a list of nonterminals which must have been
previously declared in GRAMMAR's NONTERMS form.  By default, the start
symbol is the first nonterminal defined.  When START-LIST contains
only one element, it is the start symbol.  Otherwise, all elements are
possible start symbols, unless `wisent-single-start-flag' is non-nil.
In that case, the first element is the start symbol, and others are
ignored.

Return an automaton as a vector: [ACTIONS GOTOS STARTS FUNCTIONS]
where:

- ACTIONS is a state/token matrix telling the parser what to do at
  every state based on the current lookahead token.  That is shift,
  reduce, accept or error.

- GOTOS is a state/nonterminal matrix telling the parser the next
  state to go to after reducing with each rule.

- STARTS is an alist which maps the allowed start nonterminal symbols
  to tokens that will be first shifted into the parser stack.

- FUNCTIONS is an obarray of semantic action symbols.  Each symbol's
  function definition is the semantic action lambda expression." nil nil)

(autoload 'wisent-byte-compile-grammar "wisent-comp" "\
Byte compile the `wisent-compile-grammar' FORM.
Automatically called by the Emacs Lisp byte compiler as a
`byte-compile' handler." nil nil)

(put 'wisent-compile-grammar 'byte-compile 'wisent-byte-compile-grammar)

;;;***

;;;### (autoloads (wisent-debug-show-entry wisent-cancel-debug-on-entry wisent-debug-on-entry) "wisent-debug" "wisent/wisent-debug.el")

(autoload 'wisent-debug-on-entry "wisent-debug" "\
Request AUTOMATON's FUNCTION to invoke debugger each time it is called.
FUNCTION must be a semantic action symbol that exists in AUTOMATON." t nil)

(autoload 'wisent-cancel-debug-on-entry "wisent-debug" "\
Undo effect of \\[wisent-debug-on-entry] on AUTOMATON's FUNCTION.
FUNCTION must be a semantic action symbol that exists in AUTOMATON." t nil)

(autoload 'wisent-debug-show-entry "wisent-debug" "\
Show the source of AUTOMATON's semantic action FUNCTION.
FUNCTION must be a semantic action symbol that exists in AUTOMATON." t nil)

;;;***

;;;### (autoloads (wisent-grammar-mode) "wisent-grammar" "wisent/wisent-grammar.el")

(autoload 'wisent-grammar-mode "wisent-grammar" "Major mode for editing Wisent grammars." t nil)

(add-to-list 'auto-mode-alist '("\\.wy$" . wisent-grammar-mode))

(eval-after-load "speedbar" '(speedbar-add-supported-extension ".wy"))

;;;***

;;;### (autoloads (wisent-java-default-setup) "wisent-java-tags" "wisent/wisent-java-tags.el")

(autoload 'wisent-java-default-setup "wisent-java-tags" "\
Hook run to setup Semantic in `java-mode'.
Use the alternate LALR(1) parser." nil nil)

(add-hook 'java-mode-hook 'wisent-java-default-setup)

;;;***

;;;### (autoloads (wisent-python-default-setup) "wisent-python" "wisent/wisent-python.el")

(autoload 'wisent-python-default-setup "wisent-python" "\
Setup buffer for parse." nil nil)

(add-hook 'python-mode-hook 'wisent-python-default-setup)

;;;***

;;;### (autoloads (wisent-parse-toggle-verbose-flag) "wisent" "wisent/wisent.el")

(defvar wisent-parse-verbose-flag nil "\
*Non-nil means to issue more messages while parsing.")

(autoload 'wisent-parse-toggle-verbose-flag "wisent" "\
Toggle whether to issue more messages while parsing." t nil)

;;;***

(provide 'semantic-autoloads)
