// asmcheck

// Copyright 2023 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package codegen

func combine2string(p *[2]string, a, b string) {
	// amd64:`.*runtime[.]gcWriteBarrier4\(SB\)`
	// arm64:`.*runtime[.]gcWriteBarrier4\(SB\)`
	p[0] = a
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[1] = b
}

func combine4string(p *[4]string, a, b, c, d string) {
	// amd64:`.*runtime[.]gcWriteBarrier8\(SB\)`
	// arm64:`.*runtime[.]gcWriteBarrier8\(SB\)`
	p[0] = a
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[1] = b
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[2] = c
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[3] = d
}

func combine2slice(p *[2][]byte, a, b []byte) {
	// amd64:`.*runtime[.]gcWriteBarrier4\(SB\)`
	// arm64:`.*runtime[.]gcWriteBarrier4\(SB\)`
	p[0] = a
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[1] = b
}

func combine4slice(p *[4][]byte, a, b, c, d []byte) {
	// amd64:`.*runtime[.]gcWriteBarrier8\(SB\)`
	// arm64:`.*runtime[.]gcWriteBarrier8\(SB\)`
	p[0] = a
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[1] = b
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[2] = c
	// amd64:-`.*runtime[.]gcWriteBarrier`
	// arm64:-`.*runtime[.]gcWriteBarrier`
	p[3] = d
}

type S struct {
	a, b string
	c    *int
}

var g1, g2 *int

func issue71228(dst *S, ptr *int) {
	// Make sure that the non-write-barrier write.
	// "sp.c = ptr" happens before the large write
	// barrier "*dst = *sp". We approximate testing
	// that by ensuring that two global variable write
	// barriers aren't combined.
	_ = *dst
	var s S
	sp := &s
	//amd64:`.*runtime[.]gcWriteBarrier1`
	g1 = nil
	sp.c = ptr // outside of any write barrier
	//amd64:`.*runtime[.]gcWriteBarrier1`
	g2 = nil
	//amd64:`.*runtime[.]wbMove`
	*dst = *sp
}
