#	$NetBSD: bsd.prog.mk,v 1.100 1999/02/12 01:10:08 lukem Exp $
#	@(#)bsd.prog.mk	8.2 (Berkeley) 4/2/94

.if !target(__initialized__)
__initialized__:
.if exists(${.CURDIR}/../Makefile.inc)
.include "${.CURDIR}/../Makefile.inc"
.endif
.include <bsd.own.mk>
.include <bsd.obj.mk>
.MAIN:		all
.endif

.PHONY:		cleanprog proginstall scriptsinstall
realinstall:	proginstall scriptsinstall
clean cleandir distclean: cleanprog

CFLAGS+=	${COPTS}

# ELF platforms depend on crtbegin.o and crtend.o
.if ${OBJECT_FMT} == "ELF"
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/crtbegin.o)
LIBCRTBEGIN?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/crtbegin.o
.else
LIBCRTBEGIN?=	${DESTDIR}/usr/lib/crtbegin.o
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/crtend.o)
LIBCRTEND?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/crtend.o
.else
LIBCRTEND?=	${DESTDIR}/usr/lib/crtend.o
.endif
.else
LIBCRTBEGIN?=
LIBCRTEND?=
.endif

LIBCRT0?=	

.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libbz2.a)
LIBBZ2?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libbz2.a
.else
LIBBZ2?=	${DESTDIR}/usr/lib/libbz2.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libc.a)
LIBC?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libc.a
.else
LIBC?=		${DESTDIR}/usr/lib/libc.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libc_pic.a)
LIBC_PIC?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libc_pic.a
.else
LIBC_PIC?=	${DESTDIR}/usr/lib/libc_pic.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libcompat.a)
LIBCOMPAT?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libcompat.a
.else
LIBCOMPAT?=	${DESTDIR}/usr/lib/libcompat.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libcrypt.a)
LIBCRYPT?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libcrypt.a
.else
LIBCRYPT?=	${DESTDIR}/usr/lib/libcrypt.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libcurses.a)
LIBCURSES?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libcurses.a
.else
LIBCURSES?=	${DESTDIR}/usr/lib/libcurses.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libdbm.a)
LIBDBM?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libdbm.a
.else
LIBDBM?=	${DESTDIR}/usr/lib/libdbm.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libdes.a)
LIBDES?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libdes.a
.else
LIBDES?=	${DESTDIR}/usr/lib/libdes.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libedit.a)
LIBEDIT?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libedit.a
.else
LIBEDIT?=	${DESTDIR}/usr/lib/libedit.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libgcc.a)
LIBGCC?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libgcc.a
.else
LIBGCC?=	${DESTDIR}/usr/lib/libgcc.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libgnumalloc.a)
LIBGNUMALLOC?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libgnumalloc.a
.else
LIBGNUMALLOC?=	${DESTDIR}/usr/lib/libgnumalloc.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libkdb.a)
LIBKDB?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libkdb.a
.else
LIBKDB?=	${DESTDIR}/usr/lib/libkdb.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libkrb.a)
LIBKRB?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libkrb.a
.else
LIBKRB?=	${DESTDIR}/usr/lib/libkrb.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libkvm.a)
LIBKVM?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libkvm.a
.else
LIBKVM?=	${DESTDIR}/usr/lib/libkvm.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libl.a)
LIBL?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libl.a
.else
LIBL?=		${DESTDIR}/usr/lib/libl.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libm.a)
LIBM?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libm.a
.else
LIBM?=		${DESTDIR}/usr/lib/libm.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libmp.a)
LIBMP?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libmp.a
.else
LIBMP?=		${DESTDIR}/usr/lib/libmp.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libntp.a)
LIBNTP?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libntp.a
.else
LIBNTP?=	${DESTDIR}/usr/lib/libntp.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libobjc.a)
LIBOBJC?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libobjc.a
.else
LIBOBJC?=	${DESTDIR}/usr/lib/libobjc.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libpc.a)
LIBPC?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libpc.a
.else
LIBPC?=		${DESTDIR}/usr/lib/libpc.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libpcap.a)
LIBPCAP?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libpcap.a
.else
LIBPCAP?=	${DESTDIR}/usr/lib/libpcap.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libplot.a)
LIBPLOT?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libplot.a
.else
LIBPLOT?=	${DESTDIR}/usr/lib/libplot.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libposix.a)
LIBPOSIX?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libposix.a
.else
LIBPOSIX?=	${DESTDIR}/usr/lib/libposix.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libresolv.a)
LIBRESOLV?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libresolv.a
.else
LIBRESOLV?=	${DESTDIR}/usr/lib/libresolv.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/librpcsvc.a)
LIBRPCSVC?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/librpcsvc.a
.else
LIBRPCSVC?=	${DESTDIR}/usr/lib/librpcsvc.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libskey.a)
LIBSKEY?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libskey.a
.else
LIBSKEY?=	${DESTDIR}/usr/lib/libskey.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libtermcap.a)
LIBTERMCAP?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libtermcap.a
.else
LIBTERMCAP?=	${DESTDIR}/usr/lib/libtermcap.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libtelnet.a)
LIBTELNET?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libtelnet.a
.else
LIBTELNET?=	${DESTDIR}/usr/lib/libtelnet.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libutil.a)
LIBUTIL?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libutil.a
.else
LIBUTIL?=	${DESTDIR}/usr/lib/libutil.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libwrap.a)
LIBWRAP?=	${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libwrap.a
.else
LIBWRAP?=	${DESTDIR}/usr/lib/libwrap.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/liby.a)
LIBY?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/liby.a
.else
LIBY?=		${DESTDIR}/usr/lib/liby.a
.endif
.if exists(${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libz.a)
LIBZ?=		${DESTDIR}/usr/lib/${MACHINE_MULTIARCH}/libz.a
.else
LIBZ?=		${DESTDIR}/usr/lib/libz.a
.endif

.if defined(SHAREDSTRINGS)
CLEANFILES+=strings
.c.o:
	${CC} -E ${CFLAGS} ${.IMPSRC} | xstr -c -
	@${CC} ${CFLAGS} -c x.c -o ${.TARGET}
	@rm -f x.c

.cc.o:
	${CXX} -E ${CXXFLAGS} ${.IMPSRC} | xstr -c -
	@mv -f x.c x.cc
	@${CXX} ${CXXFLAGS} -c x.cc -o ${.TARGET}
	@rm -f x.cc

.C.o:
	${CXX} -E ${CXXFLAGS} ${.IMPSRC} | xstr -c -
	@mv -f x.c x.C
	@${CXX} ${CXXFLAGS} -c x.C -o ${.TARGET}
	@rm -f x.C
.endif


.if defined(PROG)
SRCS?=		${PROG}.c

DPSRCS+=	${SRCS:M*.l:.l=.c} ${SRCS:M*.y:.y=.c}
CLEANFILES+=	${DPSRCS}
.if defined(YHEADER)
CLEANFILES+=	${SRCS:M*.y:.y=.h}
.endif

.if !empty(SRCS:N*.h:N*.sh)
OBJS+=		${SRCS:N*.h:N*.sh:R:S/$/.o/g}
LOBJS+=		${LSRCS:.c=.ln} ${SRCS:M*.c:.c=.ln}
.endif

.if defined(OBJS) && !empty(OBJS)
.NOPATH: ${OBJS}
.if defined(DESTDIR)

${PROG}: ${LIBCRT0} ${DPSRCS} ${OBJS} ${LIBC} ${LIBCRTBEGIN} ${LIBCRTEND} ${DPADD}
	${CC} ${LDFLAGS} ${LDSTATIC} -o ${.TARGET} -nostdlib -L${DESTDIR}/usr/lib ${LIBCRT0} ${LIBCRTBEGIN} ${OBJS} ${LDADD} -lgcc -lc -lgcc ${LIBCRTEND}

.else

${PROG}: ${LIBCRT0} ${DPSRCS} ${OBJS} ${LIBC} ${LIBCRTBEGIN} ${LIBCRTEND} ${DPADD}
	${CC} ${LDFLAGS} ${LDSTATIC} -o ${.TARGET} ${OBJS} ${LDADD}

.endif	# defined(DESTDIR)
.endif	# defined(OBJS) && !empty(OBJS)

.if !defined(MAN)
MAN=	${PROG}.1
.endif	# !defined(MAN)
.endif	# defined(PROG)

all: ${PROG}

cleanprog:
	rm -f a.out [Ee]rrs mklog core *.core \
	    ${PROG} ${OBJS} ${LOBJS} ${CLEANFILES}

.if defined(SRCS)
afterdepend: .depend
	@(TMP=`mktemp -t _dependXXXXXXXXXX` || exit $$?; \
	    sed -e 's/^\([^\.]*\).o[ ]*:/\1.o \1.ln:/' \
	      < .depend > $$TMP; \
	    mv $$TMP .depend)
.endif

.if defined(PROG) && !target(proginstall)
PROGNAME?= ${PROG}
proginstall:: ${DESTDIR}${BINDIR}/${PROGNAME}
.if !defined(UPDATE)
.PHONY: ${DESTDIR}${BINDIR}/${PROGNAME}
.endif
.if !defined(BUILD)
${DESTDIR}${BINDIR}/${PROGNAME}: .MADE
.endif

.PRECIOUS: ${DESTDIR}${BINDIR}/${PROGNAME}
${DESTDIR}${BINDIR}/${PROGNAME}: ${PROG}
	${INSTALL} ${RENAME} ${PRESERVE} ${COPY} ${STRIPFLAG} -o ${BINOWN} \
	    -g ${BINGRP} -m ${BINMODE} ${.ALLSRC} ${.TARGET}
.endif

.if !target(proginstall)
proginstall::
.endif

.if defined(SCRIPTS) && !target(scriptsinstall)
SCRIPTSDIR?=${BINDIR}
SCRIPTSOWN?=${BINOWN}
SCRIPTSGRP?=${BINGRP}
SCRIPTSMODE?=${BINMODE}
.for S in ${SCRIPTS}
SCRIPTSDIR_${S}?=${SCRIPTSDIR}
SCRIPTSOWN_${S}?=${SCRIPTSOWN}
SCRIPTSGRP_${S}?=${SCRIPTSGRP}
SCRIPTSMODE_${S}?=${SCRIPTSMODE}
.if defined(SCRIPTSNAME)
SCRIPTSNAME_${S} ?= ${SCRIPTSNAME}
.else
SCRIPTSNAME_${S} ?= ${S:T:R}
.endif
SCRIPTSDIR_${S} ?= ${SCRIPTSDIR}
scriptsinstall:: ${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}
.if !defined(UPDATE)
.PHONY: ${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}
.endif
.if !defined(BUILD)
${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}: .MADE
.endif

.PRECIOUS: ${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}
${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}: ${S}
	${INSTALL} ${RENAME} ${PRESERVE} ${COPY} -o ${SCRIPTSOWN_${S}} -g \
	    ${SCRIPTSGRP_${S}} -m ${SCRIPTSMODE_${S}} ${.ALLSRC} ${.TARGET}
.endfor
.endif

.if !target(scriptsinstall)
scriptsinstall::
.endif

lint: ${LOBJS}
.if defined(LOBJS) && !empty(LOBJS)
	${LINT} ${LINTFLAGS} ${LDFLAGS:M-L*} ${LOBJS} ${LDADD}
.endif

.include <bsd.man.mk>
.include <bsd.nls.mk>
.include <bsd.files.mk>
.include <bsd.inc.mk>
.include <bsd.links.mk>
.include <bsd.dep.mk>
.include <bsd.sys.mk>

# Make sure all of the standard targets are defined, even if they do nothing.
regress:
