/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl;

import javax.swing.tree.DefaultMutableTreeNode;
import tudresden.ocl.check.TypeQueryable;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.Start;

public class Visualizer
extends DepthFirstAdapter {
    Start root;
    String errorMessage;
    RuntimeException exception;
    TypeQueryable tq;
    boolean catchExceptions;

    public Visualizer(boolean catchExceptions) {
        this(catchExceptions, null);
    }

    public Visualizer(boolean catchExceptions, TypeQueryable tq) {
        this.tq = tq;
        this.catchExceptions = catchExceptions;
    }

    public void inStart(Start node) {
        this.root = node;
        this.defaultIn(node);
    }

    public void outStart(Start s) {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void defaultIn(Node node) {
        String text;
        block5: {
            text = node.getClass().toString();
            if ((text = text.substring(text.lastIndexOf(".") + 1)).startsWith("A")) {
                text = text.substring(1);
            }
            text = text + " - " + node.toString();
            if (this.tq != null) {
                try {
                    Type o = this.tq.getNodeType(node);
                    text = o == null ? text + " - no type" : text + " - " + o;
                }
                catch (RuntimeException e) {
                    text = text + " - ERROR " + e.getMessage();
                    this.errorMessage = e.getMessage();
                    if (this.catchExceptions) {
                        e.printStackTrace(System.out);
                    }
                    if (this.exception != null) break block5;
                    this.exception = e;
                }
            }
        }
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(text);
        this.setIn(node, dmtn);
    }

    public void defaultOut(Node node) {
        Node parent = node.parent();
        if (parent != null) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.getIn(parent);
            dmtn.add((DefaultMutableTreeNode)this.getIn(node));
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void defaultCase(Node node) {
        String text = node.getClass().toString();
        if ((text = text.substring(text.lastIndexOf(".") + 1)).startsWith("T")) {
            text = text.substring(1);
        }
        text = text + " - " + node.toString();
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(text);
        ((DefaultMutableTreeNode)this.getIn(node.parent())).add(dmtn);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getIn(this.root);
    }
}

