/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefStruct;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.mdr.handlers.EnumResolver;
import org.netbeans.mdr.handlers.StructImpl;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.XmiUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BootReader {
    private static final String JMI_PACKAGE_PREFIX = "javax.jmi.model.";
    private final MdrStorage mdrStorage;
    private final URL docURL;
    private final Hashtable odByName = new Hashtable(100);
    private final Hashtable odByXmiId = new Hashtable(100);
    private final Hashtable aliases = new Hashtable(10);
    private final List excludeTypes = new ArrayList(3);
    private final Hashtable objectsByName = new Hashtable(100);
    private final Hashtable proxyIdByName = new Hashtable(11);
    private final Hashtable proxyById = new Hashtable();
    private final ArrayList superclassByClass = new ArrayList();
    private final Hashtable proxyIdByXmiId = new Hashtable();
    private final HashSet proxyReferences = new HashSet();
    private final HashMap otherEnds = new HashMap();
    private Document document = null;
    private StorableAssociation containsAssociation = null;

    public BootReader(MdrStorage storage, URL docURL) {
        this.mdrStorage = storage;
        this.docURL = docURL;
    }

    protected Document parse(URL docURL) throws IOException, SAXException, ParserConfigurationException {
        Document result = null;
        DocumentBuilderFactory bfact = DocumentBuilderFactory.newInstance();
        bfact.setValidating(false);
        DocumentBuilder docBuilder = bfact.newDocumentBuilder();
        docBuilder.setEntityResolver(DummyER.getInstance());
        InputSource is = new InputSource(docURL.toString());
        result = docBuilder.parse(is);
        return result;
    }

    public Collection read() throws IOException, SAXException {
        try {
            this.document = this.parse(this.docURL);
            Node xmiContent = this.document.getElementsByTagName("XMI.content").item(0);
            this.createProxies(xmiContent);
            Collection result = this.createInstances(xmiContent);
            this.rebuildMetas();
            this.initSuperClasses();
            return result;
        }
        catch (ParserConfigurationException e) {
            Logger.getDefault().log("Unable to parse document. " + e.getMessage());
            return null;
        }
    }

    private void initSuperClasses() {
        Class[] iface = new Class[1];
        Iterator it = this.proxyById.values().iterator();
        while (it.hasNext()) {
            Object sc = it.next();
            if (!(sc instanceof StorableClass)) continue;
            try {
                iface[0] = null;
                ((StorableClass)sc).initClassSuperclass(iface);
                iface[0] = null;
                ((StorableClass)sc).initInstanceSuperclass(iface);
            }
            catch (Exception e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
    }

    private void createProxies(Node xmiContent) {
        NodeList childNodes = xmiContent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node packageNode = childNodes.item(i);
            if (XmiUtils.isTextNode(packageNode) || !XmiUtils.getXmiAttrValueAsString(packageNode, "Model.ModelElement.name").equals("Model")) continue;
            String logicalMOFName = "";
            this.createProxiesInPackage(null, new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName), packageNode);
        }
    }

    private Collection createInstances(Node xmiContent) {
        XmiUtils.XmiNodeIterator classes = new XmiUtils.XmiNodeIterator(xmiContent);
        Collection result = this.createInstances(classes, null, "", null);
        this.resolveSuperClasses();
        this.resolveReferences();
        this.setValues();
        return result;
    }

    private void rebuildMetas() {
        try {
            StorablePackage sp = this.mdrStorage.getContextOutermostPackage("BootMOF");
            sp.replaceValues(this.objectsByName);
            Iterator classes = sp.getAllClasses().iterator();
            while (classes.hasNext()) {
                StorableClass sc = (StorableClass)classes.next();
                sc.replaceValues(this.objectsByName);
                Iterator instances = sc.allObjects(false).iterator();
                while (instances.hasNext()) {
                    StorableObject so = (StorableObject)instances.next();
                    so.replaceValues(this.objectsByName);
                }
            }
            Iterator associations = sp.getAllAssociations().iterator();
            while (associations.hasNext()) {
                StorableAssociation sa = (StorableAssociation)associations.next();
                sa.replaceValues(this.objectsByName);
            }
            this.mdrStorage.rebuildMetas("BootMOF", this.objectsByName);
            this.mdrStorage.setProperty("TOPMOST_PACKAGE", sp.getMofId());
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private StorablePackage createProxiesInPackage(StorablePackage immediatePackage, MOFID fullPackageName, Node packageNode) {
        String stringifiedFullPackageName = fullPackageName.getStorageID();
        String packagePrefix = stringifiedFullPackageName.length() > 0 ? stringifiedFullPackageName + "." : "";
        String elementName = XmiUtils.getXmiAttrValueAsString(packageNode, "Model.ModelElement.name");
        String logicalMOFName = packagePrefix + elementName;
        MOFID packageName = new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName);
        StorablePackage currentPackage = this.createPackage(immediatePackage, packageName, elementName);
        Node contents = XmiUtils.getChildNode(packageNode, "Model.Namespace.contents");
        XmiUtils.XmiNodeIterator ni = new XmiUtils.XmiNodeIterator(contents);
        MOFID name = null;
        String nodeName = null;
        ArrayList<StorableClass.AttributeDescriptor> attrDescs = null;
        ArrayList<StorableClass.AttributeDescriptor> clAttrDescs = null;
        Node classContents = null;
        XmiUtils.XmiNodeIterator features = null;
        String storableXmiId = null;
        StorableClass sc = null;
        while (ni.hasNext()) {
            Node nonAbstract = ni.next();
            elementName = XmiUtils.getXmiAttrValueAsString(nonAbstract, "Model.ModelElement.name");
            logicalMOFName = packageName.getStorageID() + "." + elementName;
            name = new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName);
            nodeName = XmiUtils.resolveFullName(nonAbstract);
            if (nodeName.equals("Model.Class")) {
                attrDescs = new ArrayList<StorableClass.AttributeDescriptor>();
                clAttrDescs = new ArrayList<StorableClass.AttributeDescriptor>();
                boolean classDerived = false;
                boolean instanceDerived = false;
                boolean isSingleton = "true".equalsIgnoreCase(XmiUtils.getXmiAttrValueAsString(nonAbstract, "Model.Class.isSingleton"));
                boolean isAbstract = "true".equalsIgnoreCase(XmiUtils.getXmiAttrValueAsString(nonAbstract, "Model.GeneralizableElement.isAbstract"));
                classContents = XmiUtils.getChildNode(nonAbstract, "Model.Namespace.contents");
                if (classContents != null && (features = new XmiUtils.XmiNodeIterator(classContents)) != null) {
                    Node featureNode = null;
                    String attName = null;
                    boolean isDerived = false;
                    while (features.hasNext()) {
                        featureNode = features.next();
                        if (XmiUtils.resolveFullName(featureNode).equals("Model.Attribute")) {
                            attName = XmiUtils.getXmiAttrValueAsString(featureNode, "Model.ModelElement.name");
                            isDerived = "true".equalsIgnoreCase(XmiUtils.getXmiAttrValueAsString(featureNode, "Model.Attribute.isDerived"));
                            boolean classifier = "classifier_level".equals(XmiUtils.getXmiAttrValueAsString(featureNode, "Model.Feature.scope"));
                            if (!isDerived && attName != null) {
                                int maxSize;
                                String upper;
                                Node multiplicity = XmiUtils.getChildNode(featureNode, "Model.StructuralFeature.multiplicity");
                                Node fields = XmiUtils.getChildNode(multiplicity, "Model.MultiplicityType");
                                if (fields == null) {
                                    XmiUtils.XmiNodeIterator fieldVals = new XmiUtils.XmiNodeIterator(multiplicity, "XMI.field");
                                    fieldVals.next();
                                    upper = fieldVals.next().getFirstChild().getNodeValue();
                                } else {
                                    upper = XmiUtils.getXmiAttrValueAsString(fields, "Model.MultiplicityType.upper");
                                }
                                try {
                                    maxSize = Integer.parseInt(upper);
                                }
                                catch (NumberFormatException e) {
                                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
                                }
                                logicalMOFName = name.getStorageID() + "." + attName;
                                StorableClass.AttributeDescriptor desc = new StorableClass.AttributeDescriptor(this.mdrStorage, new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName), attName, class$java$lang$Object == null ? BootReader.class$("java.lang.Object") : class$java$lang$Object, 0, maxSize, false, true, true, null);
                                if (classifier) {
                                    clAttrDescs.add(desc);
                                } else {
                                    attrDescs.add(desc);
                                }
                            }
                        } else {
                            isDerived = XmiUtils.resolveFullName(featureNode).equals("Model.Operation");
                        }
                        if (!isDerived) continue;
                        if ("classifier_level".equalsIgnoreCase(XmiUtils.getXmiAttrValueAsString(featureNode, "Model.Feature.scope"))) {
                            classDerived = true;
                            continue;
                        }
                        instanceDerived = true;
                    }
                }
                sc = this.createClass(currentPackage, name, elementName, attrDescs, clAttrDescs, classDerived, instanceDerived, isSingleton, isAbstract);
                storableXmiId = XmiUtils.getAttributeValueAsString(nonAbstract, "xmi.id");
                if (sc != null && storableXmiId != null) {
                    this.proxyIdByXmiId.put(storableXmiId, sc.getMofId());
                    continue;
                }
                Logger.getDefault().log("Unable to set proxy by XmiId: " + nonAbstract.getNodeName());
                continue;
            }
            if (nodeName.equals("Model.Association")) {
                StorableAssociation storableAssociation;
                String uniqueB;
                String orderedB;
                String upperB;
                String lowerB;
                String uniqueA;
                String orderedA;
                String upperA;
                String lowerA;
                Node asocContents = XmiUtils.getChildNode(nonAbstract, "Model.Namespace.contents");
                XmiUtils.XmiNodeIterator asocEnds = new XmiUtils.XmiNodeIterator(asocContents, "Model.AssociationEnd");
                Node asocEndA = asocEnds.next();
                String endAName = XmiUtils.getXmiAttrValueAsString(asocEndA, "Model.ModelElement.name");
                Node multiplicityA = XmiUtils.getChildNode(asocEndA, "Model.AssociationEnd.multiplicity");
                Node fieldsA = XmiUtils.getChildNode(multiplicityA, "Model.MultiplicityType");
                if (fieldsA == null) {
                    XmiUtils.XmiNodeIterator fields = new XmiUtils.XmiNodeIterator(multiplicityA, "XMI.field");
                    lowerA = fields.next().getFirstChild().getNodeValue();
                    upperA = fields.next().getFirstChild().getNodeValue();
                    orderedA = fields.next().getFirstChild().getNodeValue();
                    uniqueA = fields.next().getFirstChild().getNodeValue();
                } else {
                    lowerA = XmiUtils.getXmiAttrValueAsString(fieldsA, "Model.MultiplicityType.lower");
                    upperA = XmiUtils.getXmiAttrValueAsString(fieldsA, "Model.MultiplicityType.upper");
                    orderedA = XmiUtils.getXmiAttrValueAsString(fieldsA, "Model.MultiplicityType.isOrdered");
                    uniqueA = XmiUtils.getXmiAttrValueAsString(fieldsA, "Model.MultiplicityType.isUnique");
                }
                boolean aggrA = !XmiUtils.getXmiAttrValueAsString(asocEndA, "Model.AssociationEnd.aggregation").equals("none");
                Node asocEndB = asocEnds.next();
                String endBName = XmiUtils.getXmiAttrValueAsString(asocEndB, "Model.ModelElement.name");
                Node multiplicityB = XmiUtils.getChildNode(asocEndB, "Model.AssociationEnd.multiplicity");
                Node fieldsB = XmiUtils.getChildNode(multiplicityB, "Model.MultiplicityType");
                if (fieldsB == null) {
                    XmiUtils.XmiNodeIterator fields = new XmiUtils.XmiNodeIterator(multiplicityB, "XMI.field");
                    lowerB = fields.next().getFirstChild().getNodeValue();
                    upperB = fields.next().getFirstChild().getNodeValue();
                    orderedB = fields.next().getFirstChild().getNodeValue();
                    uniqueB = fields.next().getFirstChild().getNodeValue();
                } else {
                    lowerB = XmiUtils.getXmiAttrValueAsString(fieldsB, "Model.MultiplicityType.lower");
                    upperB = XmiUtils.getXmiAttrValueAsString(fieldsB, "Model.MultiplicityType.upper");
                    orderedB = XmiUtils.getXmiAttrValueAsString(fieldsB, "Model.MultiplicityType.isOrdered");
                    uniqueB = XmiUtils.getXmiAttrValueAsString(fieldsB, "Model.MultiplicityType.isUnique");
                }
                boolean aggrB = !XmiUtils.getXmiAttrValueAsString(asocEndB, "Model.AssociationEnd.aggregation").equals("none");
                try {
                    storableAssociation = this.createAssociation(currentPackage, name, elementName, endAName, endBName, Integer.parseInt(lowerA), Integer.parseInt(upperA), Integer.parseInt(lowerB), Integer.parseInt(upperB), orderedA.equals("true"), orderedB.equals("true"), uniqueA.equals("true"), uniqueB.equals("true"), aggrA, aggrB);
                }
                catch (NumberFormatException e) {
                    throw new DebugException("Wrong format of multiplicity");
                }
                String endALogicalName = name.getStorageID() + "." + endAName;
                String endBLogicalName = name.getStorageID() + "." + endBName;
                long asn = this.bootSequenceNumber(endALogicalName);
                long bsn = this.bootSequenceNumber(endBLogicalName);
                this.otherEnds.put(new MOFID(asn, endALogicalName), new MOFID(bsn, endBLogicalName));
                this.otherEnds.put(new MOFID(bsn, endBLogicalName), new MOFID(asn, endALogicalName));
                if (!name.getStorageID().equals("Model.Contains")) continue;
                this.containsAssociation = storableAssociation;
                continue;
            }
            if (nodeName.equals("Model.Package")) {
                this.createProxiesInPackage(currentPackage, packageName, nonAbstract);
                continue;
            }
            if (nodeName.equals("Model.PrimitiveType")) {
                if (name.getStorageID().startsWith("PrimitiveTypes.")) continue;
                String xmiId = XmiUtils.getAttributeValueAsString(nonAbstract, "xmi.id");
                this.excludeTypes.add(xmiId);
                continue;
            }
            if (!nodeName.equals("Model.AliasType")) continue;
            String xmiId = XmiUtils.getAttributeValueAsString(nonAbstract, "xmi.id");
            this.aliases.put(xmiId, XmiUtils.getXmiRefValue(nonAbstract, "Model.TypedElement.type").get(0));
        }
        return currentPackage;
    }

    private Collection createInstances(XmiUtils.XmiNodeIterator items, MOFID containerMofId, String namePrefix, ObjectDescriptor parent) {
        ArrayList<StorableObject> instances = new ArrayList<StorableObject>();
        while (items.hasNext()) {
            Node classContents;
            Node classNode = items.next();
            if (XmiUtils.isTextNode(classNode)) continue;
            String logicalMOFName = namePrefix + XmiUtils.getXmiAttrValueAsString(classNode, "Model.ModelElement.name");
            MOFID name = new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName);
            String xmiId = XmiUtils.getAttributeValueAsString(classNode, "xmi.id");
            logicalMOFName = XmiUtils.resolveFullName(classNode);
            MOFID mofClassName = new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName);
            MOFID mofPackageName = this.getPackageName(mofClassName);
            MOFID classProxy = (MOFID)this.proxyIdByName.get(mofClassName);
            MOFID packageProxy = (MOFID)this.proxyIdByName.get(mofPackageName);
            String dataType = null;
            if (xmiId != null && this.excludeTypes.contains(this.resolveTypeId(xmiId)) || (mofClassName.getStorageID().equals("Model.Attribute") || mofClassName.getStorageID().equals("Model.StructureField")) && this.excludeTypes.contains(dataType = this.resolveTypeId((String)XmiUtils.getXmiRefValue(classNode, "Model.TypedElement.type").get(0)))) continue;
            StorableObject instance = this.createObject(mofClassName, packageProxy, classProxy);
            instances.add(instance);
            this.objectsByName.put(name, instance.getMofId());
            ObjectDescriptor od = new ObjectDescriptor(classNode, instance, name);
            if (this.odByName.put(name, od) != null) {
                Logger.getDefault().log("duplicate for: " + name);
            }
            if (xmiId != null) {
                this.odByXmiId.put(xmiId, od);
            }
            if (containerMofId != null) {
                try {
                    this.containsAssociation.addLink(containerMofId, instance.getMofId());
                }
                catch (StorageException e) {
                    throw new DebugException("Storage exception: " + e);
                }
            }
            if (mofClassName.getStorageID().equals("Model.Attribute")) {
                if (XmiUtils.getXmiAttrValueAsString(classNode, "Model.Attribute.isDerived").equals("false")) {
                    String upper = XmiUtils.getXmiAttrValueAsString(XmiUtils.getChildNode(XmiUtils.getChildNode(classNode, "Model.StructuralFeature.multiplicity"), "Model.MultiplicityType"), "Model.MultiplicityType.upper");
                    if (upper == null) {
                        XmiUtils.XmiNodeIterator fields = new XmiUtils.XmiNodeIterator(XmiUtils.getChildNode(classNode, "Model.StructuralFeature.multiplicity"), "XMI.field");
                        fields.next();
                        upper = fields.next().getFirstChild().getNodeValue();
                    }
                    parent.addFeature(new Feature(name, 0, dataType, null, !upper.equals("1")));
                }
            } else if (mofClassName.getStorageID().equals("Model.StructureField")) {
                parent.addFeature(new Feature(name, 2, dataType, null, false));
            } else if (mofClassName.getStorageID().equals("Model.Reference")) {
                String referencedEnd = (String)XmiUtils.getXmiRefValue(classNode, "Model.Reference.referencedEnd").get(0);
                parent.addFeature(new Feature(name, 1, null, referencedEnd, true));
                this.proxyReferences.add(parent);
            } else if (mofClassName.getStorageID().equals("Model.Class")) {
                List superTypes = XmiUtils.getXmiRefValue(classNode, "Model.GeneralizableElement.supertypes");
                Iterator st = superTypes.iterator();
                while (st.hasNext()) {
                    String superTypeXmiId = (String)st.next();
                    od.addSupertype(superTypeXmiId);
                    MOFID superProxyId = (MOFID)this.proxyIdByXmiId.get(superTypeXmiId);
                    if (superProxyId != null) {
                        this.superclassByClass.add(new SuperClassDescriptor((MOFID)this.proxyIdByXmiId.get(xmiId), superProxyId));
                        continue;
                    }
                    throw new DebugException("Unable to get MofId for proxy woth XmiId : " + superTypeXmiId);
                }
            }
            if ((classContents = XmiUtils.getChildNode(classNode, "Model.Namespace.contents")) == null) continue;
            XmiUtils.XmiNodeIterator subnodes = new XmiUtils.XmiNodeIterator(classContents);
            this.createInstances(subnodes, instance.getMofId(), name.getStorageID() + ".", od);
        }
        return instances;
    }

    private void setValues() {
        Iterator it = this.odByName.values().iterator();
        while (it.hasNext()) {
            ObjectDescriptor od = (ObjectDescriptor)it.next();
            this.readFeatureValues(od, (ObjectDescriptor)this.odByName.get(od.getStorable().getMetaObjectId()));
        }
    }

    private void readFeatureValues(ObjectDescriptor object, ObjectDescriptor od) {
        Iterator it = od.getFeatures().iterator();
        block6: while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            try {
                switch (feature.getType()) {
                    case 0: {
                        Object attrValue = this.getXmiAttrValue(object.getNode(), feature);
                        String featureName = BootReader.getObjectName(feature.getName());
                        object.getStorable().setAttribute(featureName, attrValue);
                        break;
                    }
                    case 1: {
                        if (feature.getName().getStorageID().equals("Model.Namespace.contents")) break;
                        List value = XmiUtils.getXmiRefValue(object.getNode(), feature.getName().getStorageID());
                        Iterator refs = value.iterator();
                        while (refs.hasNext()) {
                            String ref = (String)refs.next();
                            object.getStorable().addReference(BootReader.getObjectName(feature.getName()), ((ObjectDescriptor)this.odByXmiId.get(ref)).getStorable().getMofId());
                        }
                        continue block6;
                    }
                }
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        it = od.getSupertypes().iterator();
        while (it.hasNext()) {
            this.readFeatureValues(object, (ObjectDescriptor)this.odByXmiId.get(it.next()));
        }
    }

    private Object getXmiAttrValue(Node node, Feature feature) {
        ObjectDescriptor dataType = feature.getDataType();
        MOFID metaType = dataType.getStorable().getMetaObjectId();
        RefStruct value = null;
        if (metaType.getStorageID().equals("Model.StructureType")) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            Node attrNode = XmiUtils.getChildNode(node, feature.getName().getStorageID());
            Node structNode = XmiUtils.getChildNode(attrNode, dataType.getName().getStorageID());
            if (structNode == null) {
                XmiUtils.XmiNodeIterator fieldNodes = new XmiUtils.XmiNodeIterator(attrNode, "XMI.field");
                Iterator it = dataType.getFeatures().iterator();
                while (it.hasNext()) {
                    Node fieldNode = fieldNodes.next();
                    Feature field = (Feature)it.next();
                    fields.put(BootReader.getObjectName(field.getName()), this.decodeStringValue(fieldNode.getFirstChild().getNodeValue(), field.getDataType().getStorable().getMetaObjectId(), field.getDataType()));
                }
            } else {
                Iterator it = dataType.getFeatures().iterator();
                while (it.hasNext()) {
                    Feature field = (Feature)it.next();
                    fields.put(BootReader.getObjectName(field.getName()), this.getXmiAttrValue(structNode, field));
                }
            }
            try {
                value = StructImpl.newInstance(Class.forName(JMI_PACKAGE_PREFIX + BootReader.getObjectName(dataType.getName())), new ArrayList(fields.keySet()), fields, this.parseDots(dataType.getName()));
            }
            catch (ClassNotFoundException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
            }
        }
        if (feature.isMultivalued()) {
            List vals = XmiUtils.getXmiMultiValueAsString(node, feature.getName().getStorageID());
            RefStruct x = new ArrayList(vals.size());
            Iterator it = vals.iterator();
            while (it.hasNext()) {
                x.add(this.decodeStringValue((String)it.next(), metaType, dataType));
            }
            value = x;
        } else {
            value = this.decodeStringValue(XmiUtils.getXmiAttrValueAsString(node, feature.getName().getStorageID()), metaType, dataType);
        }
        return value;
    }

    private Object decodeStringValue(String stringValue, MOFID metaType, ObjectDescriptor dataType) {
        Object value = null;
        if (metaType.getStorageID().equals("Model.EnumerationType")) {
            value = EnumResolver.resolveEnum(JMI_PACKAGE_PREFIX + BootReader.getObjectName(dataType.getName()), stringValue);
        } else if (metaType.getStorageID().equals("Model.PrimitiveType")) {
            String typeName = dataType.getName().getStorageID();
            if (typeName.equals("PrimitiveTypes.String")) {
                value = stringValue;
            } else if (typeName.equals("PrimitiveTypes.Boolean")) {
                value = Boolean.valueOf(stringValue);
            } else if (typeName.equals("PrimitiveTypes.Integer")) {
                value = new Integer(stringValue);
            } else if (typeName.equals("PrimitiveTypes.Double")) {
                value = new Double(stringValue);
            } else if (typeName.equals("PrimitiveTypes.Float")) {
                value = new Float(stringValue);
            } else if (typeName.equals("PrimitiveTypes.Long")) {
                value = new Long(stringValue);
            } else {
                Logger.getDefault().log("unrecognized type: " + typeName);
            }
        } else {
            Logger.getDefault().log("unrecognized metatype: " + metaType);
        }
        return value;
    }

    private String resolveTypeId(String xmiId) {
        String temp;
        String result = xmiId;
        while ((temp = (String)this.aliases.get(result)) != null) {
            result = temp;
        }
        return result;
    }

    private StorablePackage createPackage(StorablePackage immediatePackage, MOFID metaObjectId, String metaObjectName) {
        try {
            StorablePackage sp = new StorablePackage(this.mdrStorage, immediatePackage == null ? null : immediatePackage.getMofId(), metaObjectId, "BootMOF", new HashMap());
            MdrStorage storage = this.mdrStorage;
            storage.addBootObject(sp.getMofId());
            this.proxyIdByName.put(metaObjectId, sp.getMofId());
            if (immediatePackage != null) {
                immediatePackage.addPackage(metaObjectName, sp.getMofId());
            }
            return sp;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private StorableClass createClass(StorablePackage immediatePackage, MOFID metaMofId, String metaObjectName, List attrDescs, List clAttrDescs, boolean classDerived, boolean instanceDerived, boolean isSingleton, boolean isAbstract) {
        try {
            StorableClass sc = new StorableClass(this.mdrStorage, immediatePackage.getMofId(), metaMofId, attrDescs, clAttrDescs, new HashMap(), classDerived, instanceDerived, isSingleton, isAbstract);
            MdrStorage storage = this.mdrStorage;
            storage.addBootClass(sc.getMofId());
            this.proxyIdByName.put(metaMofId, sc.getMofId());
            this.proxyById.put(sc.getMofId(), sc);
            immediatePackage.addClass(metaObjectName, sc.getMofId());
            return sc;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private StorableAssociation createAssociation(StorablePackage immediatePackage, MOFID metaMofId, String metaObjectName, String endA, String endB, int minA, int maxA, int minB, int maxB, boolean orderedA, boolean orderedB, boolean uniqueA, boolean uniqueB, boolean aggrA, boolean aggrB) {
        try {
            String endALogicalName = metaMofId.getStorageID() + "." + endA;
            String endBLogicalName = metaMofId.getStorageID() + "." + endB;
            StorableAssociation sa = new StorableAssociation(this.mdrStorage, immediatePackage.getMofId(), metaMofId, endA, new MOFID(this.bootSequenceNumber(endALogicalName), endALogicalName), endB, new MOFID(this.bootSequenceNumber(endBLogicalName), endBLogicalName), Object.class, Object.class, minA, maxA, minB, maxB, orderedA, orderedB, uniqueA, uniqueB, aggrA, aggrB, false, false);
            MdrStorage storage = this.mdrStorage;
            storage.addBootAssociation(sa.getMofId());
            this.proxyIdByName.put(metaMofId, sa.getMofId());
            this.proxyById.put(sa.getMofId(), sa);
            immediatePackage.addAssociation(metaObjectName, sa.getMofId());
            return sa;
        }
        catch (StorageException e) {
            throw new DebugException("Storage exception: " + e);
        }
    }

    private StorableObject createObject(MOFID metaObject, MOFID immediatePackage, MOFID classProxy) {
        try {
            StorableObject so = new StorableObject(this.mdrStorage, immediatePackage, metaObject, classProxy);
            MdrStorage storage = this.mdrStorage;
            storage.addBootObject(so.getMofId());
            return so;
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private List parseDots(MOFID mofid) {
        int pos;
        ArrayList<String> value = new ArrayList<String>();
        if (!(mofid instanceof MOFID)) {
            throw new IllegalArgumentException();
        }
        String attr = mofid.getStorageID();
        while ((pos = attr.indexOf(46)) > -1) {
            if (pos > 0) {
                value.add(attr.substring(0, pos));
            }
            attr = attr.substring(pos + 1);
        }
        value.add(attr);
        return value;
    }

    private void resolveReferences() {
        ObjectDescriptor od = null;
        Feature feature = null;
        Object sc = null;
        Iterator it = this.proxyReferences.iterator();
        while (it.hasNext()) {
            od = (ObjectDescriptor)it.next();
            sc = this.proxyById.get(this.proxyIdByName.get(od.getName()));
            if (!(sc instanceof StorableClass)) continue;
            Iterator features = od.getFeatures().iterator();
            while (features.hasNext()) {
                feature = (Feature)features.next();
                if (feature.getType() != 1) continue;
                MOFID endName = (MOFID)this.otherEnds.get(feature.getAssocEndName());
                ((StorableClass)sc).addReferenceDescriptor(feature.getName(), BootReader.getObjectName(feature.getName()), (MOFID)this.proxyIdByName.get(feature.getAssocName()), BootReader.getObjectName(endName));
            }
        }
    }

    private void resolveSuperClasses() {
        MOFID classId = null;
        ArrayList superclasses = new ArrayList();
        ArrayList<MOFID> resolved = new ArrayList<MOFID>();
        SuperClassDescriptor scd = null;
        Object sc = null;
        Iterator it = this.superclassByClass.iterator();
        while (it.hasNext()) {
            superclasses.clear();
            scd = (SuperClassDescriptor)it.next();
            classId = scd.getClassId();
            sc = this.proxyById.get(classId);
            if (resolved.contains(classId) || !(sc instanceof StorableClass)) continue;
            resolved.add(classId);
            superclasses.addAll(this.getAllSuperClasses(classId));
            StorableClass storable = sc;
            Iterator foundSuperClasses = superclasses.iterator();
            while (foundSuperClasses.hasNext()) {
                storable.addSuperclass((MOFID)foundSuperClasses.next());
            }
        }
    }

    private List getAllSuperClasses(MOFID classId) {
        ArrayList<MOFID> result = new ArrayList<MOFID>();
        MOFID superClassId = null;
        ArrayList superClassIds = new ArrayList();
        superClassIds.addAll(this.getSuperClassByClass(classId));
        Iterator it = superClassIds.iterator();
        while (it.hasNext()) {
            superClassId = (MOFID)it.next();
            if (superClassId == null || result.contains(superClassId)) continue;
            result.add(superClassId);
            result.addAll(this.getAllSuperClasses(superClassId));
        }
        return result;
    }

    private List getSuperClassByClass(MOFID classId) {
        ArrayList<MOFID> result = new ArrayList<MOFID>();
        SuperClassDescriptor scd = null;
        if (classId != null) {
            Iterator it = this.superclassByClass.iterator();
            while (it.hasNext()) {
                scd = (SuperClassDescriptor)it.next();
                if (!classId.equals(scd.getClassId())) continue;
                result.add(scd.getSuperClassId());
            }
        }
        return result;
    }

    private MOFID getPackageName(MOFID bootMOFID) {
        String storageId = bootMOFID.getStorageID();
        String logicalMOFName = storageId.substring(0, storageId.lastIndexOf(46));
        return new MOFID(this.bootSequenceNumber(logicalMOFName), logicalMOFName);
    }

    private static String getObjectName(MOFID bootMOFID) {
        String storageId = bootMOFID.getStorageID();
        return storageId.substring(storageId.lastIndexOf(46) + 1);
    }

    private long bootSequenceNumber(String logicalMOFName) {
        return logicalMOFName.hashCode();
    }

    private class Feature {
        public static final int ATTRIBUTE = 0;
        public static final int REFERENCE = 1;
        public static final int FIELD = 2;
        private final MOFID fullName;
        private final int type;
        private final String dataTypeXmiId;
        private final String assocEndXmiId;
        private final boolean multivalued;
        private ObjectDescriptor dataType = null;
        private MOFID assocName = null;
        private MOFID assocEndName = null;

        private void resolveNames() {
            ObjectDescriptor od = (ObjectDescriptor)BootReader.this.odByXmiId.get(this.assocEndXmiId);
            this.assocEndName = od.getName();
            this.assocName = od.getParentName();
        }

        public Feature(MOFID fullName, int type, String dataTypeXmiId, String assocEndXmiId, boolean multivalued) {
            this.fullName = fullName;
            this.type = type;
            this.dataTypeXmiId = dataTypeXmiId;
            this.assocEndXmiId = assocEndXmiId;
            this.multivalued = multivalued;
        }

        public MOFID getName() {
            return this.fullName;
        }

        public MOFID getAssocName() {
            if (this.assocName == null) {
                this.resolveNames();
            }
            return this.assocName;
        }

        public MOFID getAssocEndName() {
            if (this.assocEndName == null) {
                this.resolveNames();
            }
            return this.assocEndName;
        }

        public ObjectDescriptor getDataType() {
            if (this.dataType == null) {
                this.dataType = (ObjectDescriptor)BootReader.this.odByXmiId.get(this.dataTypeXmiId);
            }
            return this.dataType;
        }

        public boolean isMultivalued() {
            return this.multivalued;
        }

        public int getType() {
            return this.type;
        }
    }

    private class ObjectDescriptor {
        private final Node node;
        private final StorableObject storable;
        private final MOFID name;
        private MOFID parentName;
        private List features = null;
        private List supertypes = null;

        public ObjectDescriptor(Node node, StorableObject storable, MOFID name) {
            this.node = node;
            this.storable = storable;
            this.name = name;
        }

        public MOFID getName() {
            return this.name;
        }

        public MOFID getParentName() {
            if (this.parentName == null) {
                String sname = this.name.getStorageID();
                String logicalMOFName = sname.substring(0, sname.lastIndexOf(46));
                this.parentName = new MOFID(BootReader.this.bootSequenceNumber(logicalMOFName), logicalMOFName);
            }
            return this.parentName;
        }

        public Node getNode() {
            return this.node;
        }

        public StorableObject getStorable() {
            return this.storable;
        }

        public List getSupertypes() {
            if (this.supertypes == null) {
                this.supertypes = new ArrayList();
            }
            return this.supertypes;
        }

        public List getFeatures() {
            if (this.features == null) {
                this.features = new ArrayList();
            }
            return this.features;
        }

        public void addSupertype(String supertypeXmiId) {
            this.getSupertypes().add(supertypeXmiId);
        }

        public void addFeature(Feature feature) {
            this.getFeatures().add(feature);
        }
    }

    private class SuperClassDescriptor {
        private MOFID classId = null;
        private MOFID superClassId = null;

        public SuperClassDescriptor(MOFID classId, MOFID superClassId) {
            this.classId = classId;
            this.superClassId = superClassId;
        }

        public MOFID getClassId() {
            return this.classId;
        }

        public MOFID getSuperClassId() {
            return this.superClassId;
        }
    }

    private static class DummyER
    implements EntityResolver {
        private static EntityResolver instance = new DummyER();

        private DummyER() {
        }

        public static EntityResolver getInstance() {
            return instance;
        }

        public InputSource resolveEntity(String publicID, String systemID) {
            Logger.getDefault().log("resolving reference: " + publicID + ", " + systemID);
            return new InputSource(new StringReader(""));
        }
    }
}

