/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefStruct;
import javax.jmi.reflect.TypeMismatchException;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.IOUtils;

public class AttrImmutList
extends AbstractList {
    protected Object[] data;
    private String typeName;

    public AttrImmutList() {
    }

    AttrImmutList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc) throws StorageException {
        this(mdrObject, desc, null);
    }

    AttrImmutList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor desc, Collection values) throws StorageException {
        Class type = desc.getType();
        this.typeName = RefEnum.class.isAssignableFrom(type) || RefStruct.class.isAssignableFrom(type) ? type.getName() : null;
        if (values == null) {
            this.data = new Object[0];
        } else {
            this.data = values.toArray();
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == null) {
                    throw new NullPointerException();
                }
                if (type.isInstance(this.data[i])) continue;
                throw new TypeMismatchException(type, this.data[i], this.getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
            }
        }
        if (this.data.length < desc.getMinSize() || desc.getMaxSize() > -1 && this.data.length > desc.getMaxSize()) {
            throw new WrongSizeException(this.getMetaElement(mdrObject.getMdrStorage(), desc.getMofId()));
        }
        if (type.isInstance(RefObject.class)) {
            this.setAttribComposite(mdrObject.getMofId(), values, desc.getMofId());
        }
    }

    protected void setAttribComposite(MOFID compositeId, RefObject object, MOFID metaMofId) throws StorageException {
        StorableObject storable = (StorableObject)((BaseObjectHandler)object)._getDelegate();
        storable.setComposite(compositeId, storable.getMofId(), metaMofId);
    }

    protected void setAttribComposite(MOFID compositeId, Collection list, MOFID metaMofId) throws StorageException {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.setAttribComposite(compositeId, (RefObject)it.next(), metaMofId);
        }
    }

    protected RefObject getMetaElement(MdrStorage mdrStorage, MOFID mofId) {
        try {
            return (RefObject)mdrStorage.getRepository().getHandler(mdrStorage.getObject(mofId));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object get(int index) {
        return this.data[index];
    }

    public int size() {
        return this.data.length;
    }

    public void read(InputStream stream, StorableBaseObject storable) throws IOException {
        this.typeName = (String)storable.getMdrStorage().values(storable.getMofId()).resolve(IOUtils.readInt(stream));
        int size = IOUtils.readInt(stream);
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = IOUtils.read(stream, storable);
        }
    }

    public void write(OutputStream stream, StorableBaseObject storable) throws IOException {
        IOUtils.writeInt(stream, storable.getMdrStorage().values(storable.getMofId()).indexOf(this.typeName));
        IOUtils.writeInt(stream, this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            IOUtils.write(stream, this.data[i], storable);
        }
    }
}

