/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageException;

public interface Storage {
    public String getName();

    public String getStorageId();

    public long getSerialNumber();

    public MOFID readMOFID(InputStream var1) throws StorageException;

    public void writeMOFID(OutputStream var1, MOFID var2) throws StorageException;

    public SinglevaluedIndex getPrimaryIndex() throws StorageException;

    public boolean exists() throws StorageException;

    public boolean delete() throws StorageException;

    public void create(boolean var1, ObjectResolver var2) throws StorageException;

    public void open(boolean var1, ObjectResolver var2) throws StorageException;

    public void close() throws StorageException;

    public SinglevaluedIndex createSinglevaluedIndex(String var1, EntryType var2, EntryType var3) throws StorageException;

    public MultivaluedOrderedIndex createMultivaluedOrderedIndex(String var1, EntryType var2, EntryType var3, boolean var4) throws StorageException;

    public MultivaluedIndex createMultivaluedIndex(String var1, EntryType var2, EntryType var3, boolean var4) throws StorageException;

    public Index getIndex(String var1) throws StorageException;

    public SinglevaluedIndex getSinglevaluedIndex(String var1) throws StorageException;

    public MultivaluedIndex getMultivaluedIndex(String var1) throws StorageException;

    public MultivaluedOrderedIndex getMultivaluedOrderedIndex(String var1) throws StorageException;

    public void dropIndex(String var1) throws StorageException;

    public void objectStateWillChange(Object var1) throws StorageException;

    public void objectStateChanged(Object var1) throws StorageException;

    public void commitChanges() throws StorageException;

    public void rollBackChanges() throws StorageException;

    public void shutDown() throws StorageException;

    public static final class EntryType {
        public static final EntryType MOFID = new EntryType(1, "MOFID");
        public static final EntryType STREAMABLE = new EntryType(2, "STREAMABLE");
        public static final EntryType STRING = new EntryType(3, "STRING");
        public static final EntryType INT = new EntryType(4, "INT");
        private static final EntryType[] all = new EntryType[]{MOFID, STREAMABLE, STRING, INT};
        private final byte id;
        private final String textId;

        private EntryType(byte id, String textId) {
            this.id = id;
            this.textId = textId;
        }

        public static Collection getEntryTypes() {
            return Collections.unmodifiableCollection(Arrays.asList(all));
        }

        public static EntryType decodeEntryType(String name) {
            for (int i = 0; i < all.length; ++i) {
                if (!EntryType.all[i].textId.equals(name)) continue;
                return all[i];
            }
            return null;
        }

        public static EntryType decodeEntryType(byte code) {
            if (code > 0 && code <= 4) {
                return all[code - 1];
            }
            return null;
        }

        public String toString() {
            return this.textId;
        }

        public byte encode() {
            return this.id;
        }
    }
}

