/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.DockBoundary;

class WrappingDockBoundary
extends DockBoundary {
    private boolean ourLayoutReflects = false;

    public WrappingDockBoundary(int n) {
        super(n);
        this.ourLayoutReflects = n == 5 || n == 3;
    }

    public WrappingDockBoundary(int n, int n2) {
        super(n, n2);
        this.ourLayoutReflects = n == 5 || n == 3;
    }

    public int getDockIndex(Point point) {
        JToolBar[] jToolBarArray = this.getToolBars();
        for (int i = 0; i < jToolBarArray.length; ++i) {
            if (!jToolBarArray[i].getBounds().contains(point)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public int getDockIndex(JToolBar jToolBar) {
        return Arrays.asList(this.getToolBars()).indexOf(jToolBar);
    }

    public int getRowIndex(Point point) {
        return 0;
    }

    public int getRowIndex(JToolBar jToolBar) {
        if (Arrays.asList(this.getToolBars()).contains(jToolBar)) {
            return 0;
        }
        return -1;
    }

    public void validate() {
        int n = this.getSpacing();
        int n2 = this.getOrientation();
        int n3 = 0;
        n3 = n2 == 0 ? this.width : this.height;
        JToolBar[] jToolBarArray = this.getToolBars();
        int n4 = this.getPreferredDepth();
        int n5 = 0;
        int n6 = n4;
        int n7 = 0;
        for (int i = 0; i < jToolBarArray.length; ++i) {
            JToolBar jToolBar = jToolBarArray[i];
            n5 = this.getPreferredToolBarLength(jToolBar);
            if (n7 != 0) {
                n7 += n;
            }
            this.setToolBarBounds(jToolBar, n7, n6 - n4, Math.min(n5, n3), n4);
            if ((n7 += n5) <= n3 || i <= 0) continue;
            n7 = 0;
            this.setToolBarBounds(jToolBar, n7, (n6 += n4 + n) - n4, Math.min(n5, n3), n4);
            n7 = n5;
        }
        this.setDepth(n6);
    }

    private int getPreferredDepth() {
        int n = 0;
        JToolBar[] jToolBarArray = super.getToolBars();
        for (int i = 0; i < jToolBarArray.length; ++i) {
            JToolBar jToolBar = jToolBarArray[i];
            Dimension dimension = jToolBar.getPreferredSize();
            n = this.getOrientation() == 0 ? Math.max(n, dimension.height) : Math.max(n, dimension.width);
        }
        return n;
    }

    private void setToolBarBounds(JToolBar jToolBar, int n, int n2, int n3, int n4) {
        if (this.getOrientation() == 0) {
            jToolBar.setBounds(this.x + n, this.y + n2, n3, n4);
            if (this.ourLayoutReflects) {
                Rectangle rectangle = jToolBar.getBounds();
                this.mirrorBounds(rectangle, this.y);
                jToolBar.setBounds(rectangle);
            }
        } else {
            jToolBar.setBounds(this.x + n2, this.y + n, n4, n3);
            if (this.ourLayoutReflects) {
                Rectangle rectangle = jToolBar.getBounds();
                this.mirrorBounds(rectangle, this.x);
                jToolBar.setBounds(rectangle);
            }
        }
    }
}

