/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.ToolBarHandler;

public abstract class DockBoundary
extends Rectangle {
    private ArrayList ourToolBars = new ArrayList();
    private Rectangle ourDockableBoundary = null;
    private int ourDockableMargin = 10;
    private int ourDockEdge = 1;
    private int ourOrientation = 0;
    private int ourSpacing = 0;

    public DockBoundary(int n) {
        super(0, 0, 0, 0);
        this.ourDockEdge = n;
        this.ourDockableBoundary = new Rectangle(0, 0, this.ourDockableMargin, this.ourDockableMargin);
        this.ourOrientation = n == 1 || n == 5 ? 0 : 1;
    }

    public DockBoundary(int n, int n2) {
        this(n);
        this.setSpacing(n2);
    }

    public void setSpacing(int n) {
        this.ourSpacing = n >= 0 ? n : 0;
    }

    public int getSpacing() {
        return this.ourSpacing;
    }

    public int getOrientation() {
        return this.ourOrientation;
    }

    public int getEdge() {
        return this.ourDockEdge;
    }

    public boolean isDockablePoint(Point point) {
        return this.ourDockableBoundary.contains(point);
    }

    public boolean isDraggablePoint(Point point, JToolBar jToolBar) {
        return true;
    }

    public abstract int getDockIndex(Point var1);

    public abstract int getDockIndex(JToolBar var1);

    public abstract int getRowIndex(Point var1);

    public abstract int getRowIndex(JToolBar var1);

    public void setPosition(int n, int n2, int n3) {
        super.setLocation(n, n2);
        if (this.ourOrientation == 0) {
            this.width = n3;
        } else {
            this.height = n3;
        }
        this.setDepth(0);
        this.validate();
        if (this.ourDockEdge == 5) {
            int n4 = Math.abs(this.height);
            this.setBounds(n, n2 - n4, this.width, n4);
        } else if (this.ourDockEdge == 3) {
            int n5 = Math.abs(this.width);
            this.setBounds(n - n5, n2, n5, this.height);
        }
        this.validateDockableBoundary();
    }

    public abstract void validate();

    public void revalidate() {
        this.validate();
        this.validateDockableBoundary();
    }

    public int getDepth() {
        if (this.ourOrientation == 0) {
            return this.height;
        }
        return this.width;
    }

    protected void setDepth(int n) {
        if (this.ourOrientation == 0) {
            this.height = Math.abs(n);
        } else {
            this.width = Math.abs(n);
        }
    }

    public void addToolBar(JToolBar jToolBar, int n, int n2) {
        jToolBar.setOrientation(this.ourOrientation);
        this.ourToolBars.add(jToolBar);
        this.toolBarAdded(jToolBar, n, n2);
    }

    public void addToolBar(JToolBar jToolBar, Point point) {
        this.addToolBar(jToolBar, this.getRowIndex(point), this.getDockIndex(point));
    }

    protected void toolBarAdded(JToolBar jToolBar, int n, int n2) {
    }

    public void removeToolBar(JToolBar jToolBar) {
        this.ourToolBars.remove(jToolBar);
        this.toolBarRemoved(jToolBar);
    }

    public void removeComponent(Component component) {
        if (component instanceof JToolBar) {
            this.removeToolBar((JToolBar)component);
        }
    }

    protected void toolBarRemoved(JToolBar jToolBar) {
    }

    public JToolBar[] getToolBars() {
        JToolBar[] jToolBarArray = new JToolBar[this.ourToolBars.size()];
        jToolBarArray = this.ourToolBars.toArray(jToolBarArray);
        return jToolBarArray;
    }

    public boolean containsToolBar(JToolBar jToolBar) {
        return this.ourToolBars.contains(jToolBar);
    }

    void refreshHandlers() {
        String string = "ToolBarHandler";
        for (int i = 0; i < this.ourToolBars.size(); ++i) {
            JToolBar jToolBar = (JToolBar)this.ourToolBars.get(i);
            Object object = jToolBar.getClientProperty(string);
            ToolBarHandler toolBarHandler = (ToolBarHandler)object;
            if (toolBarHandler == null) continue;
            toolBarHandler.setDockEdge(this.getEdge());
            toolBarHandler.setDockIndex(this.getDockIndex(jToolBar));
            toolBarHandler.setRowIndex(this.getRowIndex(jToolBar));
        }
    }

    protected int getPreferredToolBarLength(JToolBar jToolBar) {
        Dimension dimension = jToolBar.getPreferredSize();
        if (this.ourOrientation == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    protected int getPreferredToolBarDepth(JToolBar jToolBar) {
        Dimension dimension = jToolBar.getPreferredSize();
        if (this.ourOrientation == 0) {
            return dimension.height;
        }
        return dimension.width;
    }

    protected void mirrorBounds(Rectangle rectangle, int n) {
        int n2 = 0;
        if (this.getOrientation() == 0) {
            int n3;
            n2 = rectangle.y - n;
            rectangle.y = n3 = rectangle.y - 2 * n2 - rectangle.height;
        } else {
            int n4;
            n2 = rectangle.x - n;
            rectangle.x = n4 = rectangle.x - 2 * n2 - rectangle.width;
        }
    }

    private void validateDockableBoundary() {
        this.ourDockableBoundary.setBounds(this);
        if (this.ourOrientation == 0) {
            this.ourDockableBoundary.height += this.ourDockableMargin;
        } else {
            this.ourDockableBoundary.width += this.ourDockableMargin;
        }
        if (this.ourDockEdge == 5) {
            this.ourDockableBoundary.y -= this.ourDockableMargin;
        } else if (this.ourDockEdge == 3) {
            this.ourDockableBoundary.x -= this.ourDockableMargin;
        }
    }
}

