/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

class JGraphInternalPane
extends JPanel {
    private Editor _editor;
    private boolean registeredWithTooltip;
    static final long serialVersionUID = -5067026168452437942L;

    public JGraphInternalPane(Editor e) {
        this._editor = e;
        this.setLayout(null);
        this.setDoubleBuffered(false);
    }

    public void paintComponent(Graphics g) {
        this._editor.paint(g);
    }

    public Graphics getGraphics() {
        Graphics res = super.getGraphics();
        if (res == null) {
            return res;
        }
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JViewport view = (JViewport)parent;
            Rectangle bounds = view.getBounds();
            Point pos = view.getViewPosition();
            res.clipRect(bounds.x + pos.x - 1, bounds.y + pos.y - 1, bounds.width + 1, bounds.height + 1);
        }
        return res;
    }

    public Point getToolTipLocation(MouseEvent event) {
        event = Globals.curEditor().retranslateMouseEvent(event);
        return super.getToolTipLocation(event);
    }

    public void setToolTipText(String text) {
        if ("".equals(text)) {
            text = null;
        }
        this.putClientProperty("ToolTipText", text);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (!this.registeredWithTooltip) {
            toolTipManager.registerComponent(this);
            this.registeredWithTooltip = true;
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.requestFocus();
        }
        super.processMouseEvent(e);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

