/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPainter;
import org.tigris.gef.util.EnumerationEmpty;
import org.tigris.gef.util.EnumerationPredicate;
import org.tigris.gef.util.PredFigInRect;
import org.tigris.gef.util.PredFigNodeInRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Layer
implements Serializable {
    private String name = "aLayer";
    private String type = "aLayer";
    private boolean hidden = false;
    private boolean grayed = false;
    private boolean locked = false;
    private boolean alwaysOnTop = false;
    private double scale = 1.0;
    @Deprecated
    protected boolean _onMenu = false;
    private transient List<Editor> editors = new ArrayList<Editor>();

    public Layer() {
    }

    public Layer(String name) {
        this.name = name;
    }

    public Layer(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Object clone() {
        Layer lay;
        try {
            lay = (Layer)this.getClass().newInstance();
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (InstantiationException ignore) {
            return null;
        }
        lay.name = this.name;
        lay.type = this.type;
        lay._onMenu = this._onMenu;
        lay.grayed = this.grayed;
        lay.setHidden(this.hidden);
        lay.setGrayed(this.grayed);
        lay.setScale(this.scale);
        lay.setLocked(this.locked);
        lay.setAlwaysOnTop(this.alwaysOnTop);
        return lay;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setHidden(boolean b) {
        this.hidden = b;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setGrayed(boolean b) {
        this.grayed = b;
    }

    public boolean getGrayed() {
        return this.grayed;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setAlwaysOnTop(boolean onTop) {
        this.alwaysOnTop = onTop;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void setOnMenu(boolean b) {
        this._onMenu = b;
    }

    public boolean getOnMenu() {
        return this._onMenu;
    }

    public abstract List<Fig> getContents();

    public List<? extends Fig> getContents(Class<? extends Fig> figClass) {
        return Collections.emptyList();
    }

    public List<DiagramElement> getDiagramElements() {
        List<Fig> contents = this.getContents();
        ArrayList<DiagramElement> list = new ArrayList<DiagramElement>(contents.size());
        for (Fig f : contents) {
            list.add(f);
        }
        return list;
    }

    public List<GraphEdge> getGraphEdges() {
        List<Fig> contents = this.getContents();
        ArrayList<GraphEdge> list = new ArrayList<GraphEdge>(contents.size() * 8 / 10);
        for (Fig f : contents) {
            if (!(f instanceof GraphEdge)) continue;
            list.add((GraphEdge)((Object)f));
        }
        return list;
    }

    public List<GraphNode> getGraphNodes() {
        List<Fig> contents = this.getContents();
        ArrayList<GraphNode> list = new ArrayList<GraphNode>(contents.size() * 8 / 10);
        for (Fig f : contents) {
            if (!(f instanceof GraphNode)) continue;
            list.add((GraphNode)((Object)f));
        }
        return list;
    }

    public List getContentsNoEdges() {
        List<Fig> contents = this.getContents();
        int size = contents.size();
        Vector<Fig> v = new Vector<Fig>(size);
        for (int i = 0; i < size; ++i) {
            Fig o = contents.get(i);
            if (o instanceof FigEdge) continue;
            v.add(o);
        }
        return v;
    }

    public List getContentsEdgesOnly() {
        List<Fig> contents = this.getContents();
        int size = contents.size();
        ArrayList<Fig> list = new ArrayList<Fig>(size);
        for (int i = 0; i < size; ++i) {
            Fig o = contents.get(i);
            if (!(o instanceof FigEdge)) continue;
            list.add(o);
        }
        return list;
    }

    public List<Editor> getEditors() {
        return Collections.unmodifiableList(new ArrayList<Editor>(this.editors));
    }

    public void add(Fig f) {
    }

    public void remove(Fig f) {
    }

    public void add(DiagramElement f) {
        this.add((Fig)f);
    }

    public void remove(DiagramElement f) {
        this.remove((Fig)f);
    }

    public void removeAll() {
    }

    public Enumeration elements() {
        return EnumerationEmpty.theInstance();
    }

    public Fig hit(Rectangle r) {
        return null;
    }

    public Enumeration elementsIn(Rectangle r) {
        return new EnumerationPredicate(this.elements(), new PredFigInRect(r));
    }

    public Enumeration nodesIn(Rectangle r) {
        return new EnumerationPredicate(this.elements(), new PredFigNodeInRect(r));
    }

    public abstract Fig presentationFor(Object var1);

    public String getPerspectiveType() {
        return this.type;
    }

    public void setPerspectiveType(String t) {
        this.type = t;
    }

    public void sendToBack(Fig f) {
    }

    public void bringForward(Fig f) {
    }

    public void sendBackward(Fig f) {
    }

    public void bringToFront(Fig f) {
    }

    public void bringInFrontOf(Fig f1, Fig f2) {
    }

    public void reorder(Fig f, int function) {
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.paint(g, null);
    }

    public void paint(Graphics g, FigPainter painter) {
        if (this.hidden) {
            return;
        }
        if (!this.grayed) {
            this.paintContents(g, painter);
        } else {
            this.paintGrayContents(g);
        }
    }

    public void paintContents(Graphics g, FigPainter painter) {
        this.paintContents(g);
    }

    public abstract void paintContents(Graphics var1);

    public void paintGrayContents(Graphics g) {
        g.setColor(Color.lightGray);
        this.paintContents(g);
    }

    public Rectangle calcDrawingArea() {
        Enumeration iter = this.elements();
        if (!iter.hasMoreElements()) {
            return new Rectangle();
        }
        Fig f = (Fig)iter.nextElement();
        Rectangle drawingArea = new Rectangle(f.getBounds());
        while (iter.hasMoreElements()) {
            f = (Fig)iter.nextElement();
            drawingArea.add(f.getBounds());
        }
        drawingArea.grow(4, 4);
        return drawingArea;
    }

    public void damageAll() {
        if (this.editors == null) {
            return;
        }
        int count = this.editors.size();
        for (int editorIndex = 0; editorIndex < count; ++editorIndex) {
            Editor editor = this.editors.get(editorIndex);
            editor.damageAll();
        }
    }

    public void deleted(Fig f) {
        if (this.editors == null) {
            return;
        }
        int editorCount = this.editors.size();
        for (int editorIndex = 0; editorIndex < editorCount; ++editorIndex) {
            Editor editor = this.editors.get(editorIndex);
            editor.removed(f);
        }
    }

    public void refreshEditors() {
        if (this.editors == null) {
            return;
        }
        int editorCount = this.editors.size();
        for (int editorIndex = 0; editorIndex < editorCount; ++editorIndex) {
            Editor editor = this.editors.get(editorIndex);
            editor.damageAll();
        }
    }

    public void addEditor(Editor ed) {
        if (this.editors == null) {
            this.editors = new ArrayList<Editor>();
        }
        this.editors.add(ed);
    }

    public void removeEditor(Editor ed) {
        if (this.editors == null) {
            return;
        }
        this.editors.remove(ed);
    }

    public void preSave() {
    }

    public void postSave() {
    }

    public void postLoad() {
    }

    public void adjust() {
    }

    public void adjust(HashMap map) {
    }
}

