/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.graph.GraphController;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.ui.PaletteFig;
import org.tigris.gef.ui.ToolBar;

public class Diagram
implements Serializable,
GraphListener {
    private static final long serialVersionUID = 4847606736320428403L;
    @Deprecated
    protected String _name = "no title set";
    @Deprecated
    protected String _comments = "(no comments given)";
    private LayerPerspective layer;
    @Deprecated
    protected transient ToolBar _toolBar;
    private transient Vector<VetoableChangeListener> vetoListeners;
    private transient PropertyChangeSupport changeSupport;
    private Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();
    public static final String SCALE_KEY = "scale";
    public static final String NAME_KEY = "name";

    public Diagram() {
        this("untitled");
    }

    public Diagram(String name) {
        this(name, new DefaultGraphModel());
    }

    public Diagram(String name, GraphModel graphModel) {
        this(name, graphModel, new LayerPerspective(name, graphModel));
        this.getLayer().setDiagram(this);
    }

    public Diagram(String name, GraphModel graphModel, LayerPerspective layer) {
        this.changeSupport = new PropertyChangeSupport(this);
        this._name = name;
        this.layer = layer;
        this.layer.setDiagram(this);
        this.setGraphModel(graphModel);
    }

    protected void initToolBar() {
        this._toolBar = new PaletteFig();
    }

    public void initialize(Object owner) {
    }

    public ToolBar getToolBar() {
        if (this._toolBar == null) {
            this.initToolBar();
        }
        return this._toolBar;
    }

    public void setToolBar(ToolBar tb) {
        this._toolBar = tb;
    }

    public String getComments() {
        return this._comments;
    }

    public void setComments(String c) throws PropertyVetoException {
        this.fireVetoableChange("comments", this._comments, c);
        this._comments = c;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) throws PropertyVetoException {
        this.fireVetoableChange(NAME_KEY, this._name, name);
        String oldName = this._name;
        this._name = name;
        this.changeSupport.firePropertyChange(NAME_KEY, oldName, name);
    }

    public void setShowSingleMultiplicity(boolean enable) {
    }

    public boolean getShowSingleMultiplicity() {
        return false;
    }

    public double getScale() {
        return this.getLayer().getScale();
    }

    public void setScale(double scale) {
        double oldScale = this.getScale();
        this.getLayer().setScale(scale);
        this.firePropertyChange(SCALE_KEY, new Double(oldScale), new Double(scale));
    }

    public String getClassAndModelID() {
        return this.getClass().getName();
    }

    public GraphModel getGraphModel() {
        return this.getLayer().getGraphModel();
    }

    public void setGraphModel(GraphModel gm) {
        GraphModel oldGM = this.getLayer().getGraphModel();
        if (oldGM != null) {
            oldGM.removeGraphEventListener(this);
        }
        this.getLayer().setGraphModel(gm);
        gm.addGraphEventListener(this);
    }

    public GraphController getGraphController() {
        return this.getLayer().getGraphController();
    }

    public LayerPerspective getLayer() {
        return this.layer;
    }

    protected void setLayer(LayerPerspective layer) {
        if (layer != null) {
            layer.setDiagram(this);
        } else if (this.layer != null) {
            this.layer.setDiagram(null);
        }
        this.layer = layer;
    }

    public int countContained(List owners) {
        int count = 0;
        int numOwners = owners.size();
        for (Object node : this.getNodes()) {
            for (int j = 0; j < numOwners; ++j) {
                if (node != owners.get(j)) continue;
                ++count;
            }
        }
        for (Object edge : this.getEdges()) {
            for (int j = 0; j < numOwners; ++j) {
                if (edge != owners.get(j)) continue;
                ++count;
            }
        }
        List<Fig> figs = this.getLayer().getContents();
        for (Fig fig : figs) {
            for (int j = 0; j < numOwners; ++j) {
                if (fig != owners.get(j)) continue;
                ++count;
            }
        }
        return count;
    }

    public List getNodes() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        List<Fig> figs = this.getLayer().getContents();
        for (Fig fig : figs) {
            if (!(fig instanceof FigNode)) continue;
            nodes.add(fig.getOwner());
        }
        return nodes;
    }

    public List getEdges() {
        ArrayList<Object> edges = new ArrayList<Object>();
        List<Fig> figs = this.getLayer().getContents();
        for (Fig fig : figs) {
            if (!(fig instanceof FigEdge) || fig.getOwner() == null) continue;
            edges.add(fig.getOwner());
        }
        return edges;
    }

    public void add(Fig f) {
        this.layer.add(f);
    }

    public void remove(Fig f) {
        this.layer.remove(f);
    }

    public void removeAll(Fig f) {
        this.layer.removeAll();
    }

    public Enumeration elements() {
        Enumeration result = this.layer.elements();
        return result;
    }

    public Fig hit(Rectangle r) {
        return this.layer.hit(r);
    }

    public Enumeration elementsIn(Rectangle r) {
        return this.layer.elementsIn(r);
    }

    public Fig presentationFor(Object obj) {
        return this.layer.presentationFor(obj);
    }

    public List presentationsFor(Object obj) {
        return this.layer.presentationsFor(obj);
    }

    public void sendToBack(Fig f) {
        this.layer.sendToBack(f);
    }

    public void bringForward(Fig f) {
        this.layer.bringForward(f);
    }

    public void sendBackward(Fig f) {
        this.layer.sendBackward(f);
    }

    public void bringToFront(Fig f) {
        this.layer.bringToFront(f);
    }

    public void reorder(Fig f, int function) {
        this.layer.reorder(f, function);
    }

    public void nodeAdded(GraphEvent e) {
        try {
            this.fireVetoableChange("nodeAdded", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void edgeAdded(GraphEvent e) {
        try {
            this.fireVetoableChange("edgeAdded", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void nodeRemoved(GraphEvent e) {
        try {
            this.fireVetoableChange("nodeRemoved", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void edgeRemoved(GraphEvent e) {
        try {
            this.fireVetoableChange("edgeRemoved", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void graphChanged(GraphEvent e) {
        try {
            this.fireVetoableChange("graphChanged", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void preSave() {
        this.layer.preSave();
    }

    public void postSave() {
        this.layer.postSave();
    }

    public void postLoad() {
        this.layer.postLoad();
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoListeners == null) {
            this.vetoListeners = new Vector();
        }
        this.vetoListeners.removeElement(listener);
        this.vetoListeners.addElement(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoListeners == null) {
            return;
        }
        this.vetoListeners.removeElement(listener);
    }

    public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        this.fireVetoableChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    public void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        this.fireVetoableChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this.vetoListeners == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            for (int i = 0; i < this.vetoListeners.size(); ++i) {
                VetoableChangeListener target = this.vetoListeners.elementAt(i);
                target.vetoableChange(evt);
            }
        }
        catch (PropertyVetoException veto) {
            evt = new PropertyChangeEvent(this, propertyName, newValue, oldValue);
            for (int i = 0; i < this.vetoListeners.size(); ++i) {
                try {
                    VetoableChangeListener target = this.vetoListeners.elementAt(i);
                    target.vetoableChange(evt);
                    continue;
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
            throw veto;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
        this.propertyChangeListeners.add(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(propertyName, l);
        this.propertyChangeListeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.removePropertyChangeListenerInt(l);
        this.propertyChangeListeners.remove(l);
    }

    private void removePropertyChangeListenerInt(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(propertyName, l);
        this.propertyChangeListeners.remove(l);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void remove() {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            this.removePropertyChangeListenerInt(listener);
        }
        if (this.vetoListeners != null) {
            this.vetoListeners.clear();
        }
    }
}

