/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;

public class CmdCopy
extends Cmd {
    private static final long serialVersionUID = -7316080407001846501L;

    public CmdCopy() {
        super("Copy");
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        List<Selection> copiedElements = ce.getSelectionManager().getSelections();
        ArrayList<Fig> figs = new ArrayList<Fig>();
        for (Selection s : copiedElements) {
            Fig f = s.getContent();
            if (f instanceof FigEdge) continue;
            f = (Fig)f.clone();
            figs.add(f);
        }
        Globals.clipBoard = figs;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdCopy");
    }

    static class SimpleSelection
    implements Transferable,
    ClipboardOwner {
        protected Fig selection;
        protected DataFlavor flavor;

        public SimpleSelection(Fig selection, DataFlavor flavor) {
            this.selection = selection;
            this.flavor = flavor;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        public boolean isDataFlavorSupported(DataFlavor f) {
            return f.equals(this.flavor);
        }

        public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException {
            if (f.equals(this.flavor)) {
                return this.selection;
            }
            throw new UnsupportedFlavorException(f);
        }

        public void lostOwnership(Clipboard c, Transferable t) {
            this.selection = null;
        }
    }
}

