/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.change.util;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.ListChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDifferenceAnalyzer {
    public EList<ListChange> analyzeLists(EList<?> oldList, EList<?> newList) {
        BasicEList listChanges = new BasicEList();
        this.analyzeLists((EList<Object>)new BasicEList(oldList), newList, (EList<ListChange>)listChanges);
        return listChanges;
    }

    public void analyzeLists(EList<Object> oldList, EList<?> newList, EList<ListChange> listChanges) {
        this.createListChanges((EList<Object>)new BasicEList(oldList), newList, listChanges);
    }

    protected void createListChanges(EList<Object> oldList, EList<?> newList, EList<ListChange> listChanges) {
        int index = 0;
        for (Object newObject : newList) {
            if (oldList.size() <= index) {
                this.createAddListChange(oldList, listChanges, newObject, index);
            } else {
                boolean done;
                do {
                    done = true;
                    Object targetObject = oldList.get(index);
                    if (!(targetObject == null ? newObject != null : !targetObject.equals(newObject))) continue;
                    int position = ECollections.indexOf(oldList, newObject, (int)index);
                    if (position != -1) {
                        int targetIndex = ECollections.indexOf(newList, (Object)targetObject, (int)index);
                        if (targetIndex == -1) {
                            this.createRemoveListChange(oldList, listChanges, targetObject, index);
                            done = false;
                            continue;
                        }
                        if (targetIndex > position) {
                            if (oldList.size() <= targetIndex) {
                                targetIndex = oldList.size() - 1;
                            }
                            this.createMoveListChange(oldList, listChanges, targetObject, index, targetIndex);
                            done = false;
                            continue;
                        }
                        this.createMoveListChange(oldList, listChanges, newObject, position, index);
                        continue;
                    }
                    this.createAddListChange(oldList, listChanges, newObject, index);
                } while (!done);
            }
            ++index;
        }
        int i = oldList.size();
        while (i > index) {
            this.createRemoveListChange(oldList, listChanges, oldList.get(--i), i);
        }
    }

    protected void createAddListChange(EList<Object> oldList, EList<ListChange> listChanges, Object newObject, int index) {
        ListChange listChange = this.createListChange(listChanges, ChangeKind.ADD_LITERAL, index);
        listChange.getValues().add(newObject);
        oldList.add(index, newObject);
    }

    protected void createRemoveListChange(EList<?> oldList, EList<ListChange> listChanges, Object newObject, int index) {
        this.createListChange(listChanges, ChangeKind.REMOVE_LITERAL, index);
        oldList.remove(index);
    }

    protected void createMoveListChange(EList<?> oldList, EList<ListChange> listChanges, Object newObject, int index, int toIndex) {
        ListChange listChange = this.createListChange(listChanges, ChangeKind.MOVE_LITERAL, index);
        listChange.setMoveToIndex(toIndex);
        oldList.move(toIndex, index);
    }

    protected ListChange createListChange(EList<ListChange> listChanges, ChangeKind kind, int index) {
        ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
        listChange.setKind(kind);
        listChange.setIndex(index);
        listChanges.add((Object)listChange);
        return listChange;
    }
}

