/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.php.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.argouml.language.php.PHPDocumentor;
import org.argouml.language.php.generator.NameGenerator;
import org.argouml.language.php.generator.Section;
import org.argouml.model.Model;
import org.argouml.uml.UUIDHelper;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.TempFileUtils;

public class GeneratorPHP4
implements CodeGenerator {
    protected static final String INDENT = "    ";
    private int iLanguageMajorVersion;
    private static Section objSection = null;
    private static final Logger LOG = Logger.getLogger(GeneratorPHP4.class);

    public GeneratorPHP4() {
        this(4);
    }

    protected GeneratorPHP4(int n) {
        this.iLanguageMajorVersion = n;
    }

    private String generateSubmachine(Object object) {
        Object object2 = Model.getFacade().getSubmachine(object);
        if (object2 == null) {
            return "include / ";
        }
        if (Model.getFacade().getName(object2) == null) {
            return "include / ";
        }
        if (Model.getFacade().getName(object2).length() == 0) {
            return "include / ";
        }
        return "include / " + Model.getFacade().getName(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateOperation(Object object, boolean bl) {
        Object object22;
        Object object3;
        if (!Model.getFacade().isAOperation(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Operation required");
        }
        String string = "";
        if (bl) {
            object3 = null;
            try {
                object3 = new PHPDocumentor(object);
            }
            catch (Exception exception) {
                LOG.error((Object)("Generating operation DocBlock FAILED: " + exception.getMessage()));
            }
            finally {
                if (object3 != null) {
                    string = string + ((PHPDocumentor)object3).toString();
                }
            }
        }
        if ((object3 = this.generateVisibility(Model.getFacade().getVisibility(object))) != null && object3 != "") {
            string = string + (String)object3 + " ";
        }
        if (this.iLanguageMajorVersion > 4) {
            if (Model.getFacade().isStatic(object)) {
                string = string + "static ";
            }
            if (Model.getFacade().isLeaf(object)) {
                string = string + "final ";
            }
            if (Model.getFacade().isAbstract(object)) {
                string = string + "abstract ";
            }
        }
        boolean bl2 = false;
        for (Object object22 : Model.getFacade().getTaggedValuesCollection(object)) {
            if (!"&".equals(Model.getFacade().getTagOfTag(object22)) || !"true".equals(Model.getFacade().getValueOfTag(object22))) continue;
            bl2 = true;
            break;
        }
        Object object4 = NameGenerator.generate(object, this.iLanguageMajorVersion);
        if (bl2) {
            object4 = "&" + (String)object4;
        }
        string = string + "function " + (String)object4 + "(";
        object22 = Model.getFacade().getParameters(object);
        if (object22 != null) {
            boolean bl3 = true;
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (Model.getFacade().isReturn(e)) continue;
                if (!bl3) {
                    string = string + ", ";
                } else {
                    bl3 = false;
                }
                string = string + this.generateParameter(e);
            }
        }
        string = string + ")";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateAttribute(Object object, boolean bl) {
        Object object2;
        if (!Model.getFacade().isAAttribute(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Attribute required");
        }
        String string = "";
        if (bl) {
            object2 = null;
            try {
                object2 = new PHPDocumentor(object);
            }
            catch (Exception exception) {
                LOG.error((Object)("Generating attribute DocBlock FAILED: " + exception.getMessage()));
            }
            finally {
                if (object2 != null) {
                    string = string + ((PHPDocumentor)object2).toString(INDENT);
                }
            }
        }
        if (Model.getFacade().isReadOnly(object)) {
            string = string + "const ";
        } else {
            object2 = this.generateVisibility(Model.getFacade().getVisibility(object));
            if (object2 != null && object2 != "") {
                string = string + (String)object2 + " ";
            }
            if (this.iLanguageMajorVersion > 4) {
                if (Model.getFacade().isStatic(object)) {
                    string = string + "static ";
                }
            } else {
                string = string + "var ";
            }
            string = string + "$";
        }
        string = string + NameGenerator.generate(object, this.iLanguageMajorVersion);
        object2 = null;
        Object object3 = Model.getFacade().getInitialValue(object);
        object2 = object3 != null ? this.generateDefaultValue(Model.getFacade().getType(object), GeneratorPHP4.generateExpression(object3).trim(), false) : this.generateDefaultValue(Model.getFacade().getType(object), null, false);
        if (object2 != null && ((String)object2).length() > 0) {
            string = string + " = " + (String)object2;
        } else {
            string = string + "[ ";
            string = string + (object3 != null ? "!= null" : "null");
            string = string + " | ";
            string = string + this.generateDefaultValue(Model.getFacade().getType(object), GeneratorPHP4.generateExpression(object3).trim(), false);
            string = string + " | ";
            string = string + this.generateDefaultValue(Model.getFacade().getType(object), GeneratorPHP4.generateExpression(object3).trim(), true);
            string = string + " ]";
        }
        string = string + ";";
        return string;
    }

    private static String generateExpression(Object object) {
        if (Model.getFacade().isAExpression(object)) {
            return GeneratorPHP4.generateUninterpreted((String)Model.getFacade().getBody(object));
        }
        if (Model.getFacade().isAConstraint(object)) {
            return GeneratorPHP4.generateExpression(Model.getFacade().getBody(object));
        }
        return "";
    }

    private static String generateUninterpreted(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateParameter(Object object) {
        Object object2;
        if (!Model.getFacade().isAParameter(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Parameter required");
        }
        String string = "";
        if (Model.getFacade().isReturn(object)) {
            Object object3 = Model.getFacade().getType(object);
            if (object3 == null || Model.getFacade().getName(object3).equals("void")) {
                return "";
            }
            String string2 = this.convertType(object3);
            if (string2 != null && !"".equals(string2.trim())) {
                return "return (" + string2 + ") $returnValue;";
            }
            return "return $returnValue;";
        }
        if (this.iLanguageMajorVersion < 5 && (object2 = Model.getFacade().getKind(object)) != null && (object2.equals(Model.getDirectionKind().getInOutParameter()) || object2.equals(Model.getDirectionKind().getOutParameter()))) {
            string = string + "&";
        }
        if (this.iLanguageMajorVersion >= 5) {
            object2 = null;
            try {
                object2 = NameGenerator.generateClassifierName(Model.getFacade().getType(object));
            }
            catch (Exception exception) {
                LOG.error((Object)("Finding type hint FAILED: " + exception.getMessage()));
            }
            finally {
                if (object2 != null && object2 != "" && this.convertType(Model.getFacade().getType(object)) == null) {
                    string = string + " " + (String)object2 + " ";
                }
            }
        }
        string = string + "$" + Model.getFacade().getName(object);
        object2 = GeneratorPHP4.generateExpression(Model.getFacade().getDefaultValue(object));
        if (object2 != null && ((String)object2).length() > 0) {
            string = string + " = " + (String)object2;
        } else {
            boolean bl = false;
            Collection collection = Model.getFacade().getParameters(Model.getFacade().getBehavioralFeature(object));
            if (collection != null) {
                for (Object e : collection) {
                    if (Model.getFacade().isReturn(e)) continue;
                    if (object.equals(e)) break;
                    if (Model.getFacade().getDefaultValue(e) == null) continue;
                    bl = true;
                }
            }
            if (bl) {
                string = string + " = " + this.generateDefaultValue(Model.getFacade().getType(object), null, false);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generatePackage(Object object) {
        String string = "";
        if (!Model.getFacade().isAPackage(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Package required");
        }
        String string2 = NameGenerator.generate(object, this.iLanguageMajorVersion);
        PHPDocumentor pHPDocumentor = null;
        try {
            pHPDocumentor = new PHPDocumentor(object);
        }
        catch (Exception exception) {
            LOG.error((Object)("Generating package DocBlock FAILED: " + exception.getMessage()));
        }
        finally {
            if (pHPDocumentor != null) {
                string = string + pHPDocumentor.toString() + "\n";
            }
        }
        Collection collection = Model.getFacade().getOwnedElements(object);
        if (collection.size() == 0) {
            string = string + "// this package contains no elements\n";
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (Model.getFacade().isAPackage(e)) {
                    string = string + this.generatePackage(e) + "\n";
                } else if (Model.getFacade().isAClassifier(e)) {
                    string = string + this.generateClassifier(e) + "\n";
                } else {
                    string = string + "/*\n";
                    string = string + "feature not supported by PHP:\n";
                    string = string + "-----------------------------\n";
                    string = string + Model.getFacade().getName(e);
                    string = string + " [" + e + "]\n";
                    string = string + "*/\n";
                }
                if (!iterator.hasNext()) continue;
                string = string + "\n";
            }
        }
        string = string + "\n/* end of package " + string2 + " */";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateClassifier(Object object) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string = "";
        String string2 = "";
        if (this.iLanguageMajorVersion > 4) {
            if (Model.getFacade().isAClass(object)) {
                string2 = Model.getFacade().isLeaf(object) ? "final class" : "class";
                if (Model.getFacade().isAbstract(object)) {
                    string2 = "abstract " + string2;
                }
            } else {
                if (!Model.getFacade().isAInterface(object)) return null;
                string2 = "interface";
                if (Model.getFacade().isLeaf(object)) {
                    string2 = "final " + string2;
                }
            }
        } else {
            if (!Model.getFacade().isAClass(object)) {
                if (!Model.getFacade().isAInterface(object)) return null;
            }
            string2 = "class";
        }
        PHPDocumentor pHPDocumentor = null;
        try {
            pHPDocumentor = new PHPDocumentor(object);
        }
        catch (Exception exception) {
            LOG.error((Object)("Generating classifier DocBlock FAILED: " + exception.getMessage()));
        }
        finally {
            if (pHPDocumentor != null) {
                string = string + pHPDocumentor.toString();
            }
        }
        String string3 = NameGenerator.generate(object, this.iLanguageMajorVersion);
        string = string + string2 + " " + string3 + "\n";
        string = string + this.generateClassifierGeneralisations(object);
        string = string + this.generateClassifierSpecifications(object);
        string = string + "{\n";
        string = string + this.generateClassifierAssociations(object);
        string = string + this.generateClassifierAttributes(object);
        string = string + this.generateClassifierOperations(object);
        return string + "\n} /* end of " + string2 + " " + string3 + " */";
    }

    private String generateClassifierAssociations(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Model.getFacade().isAClass(object)) {
            stringBuilder.append(INDENT).append("// --- ASSOCIATIONS ---\n");
            for (Object e : Model.getFacade().getAssociationEnds(object)) {
                Object object2 = this.getNavigableOppositeEnd(e);
                if (object2 == null) continue;
                stringBuilder.append(INDENT);
                stringBuilder.append(this.generateAssociationEnd(object2));
            }
        }
        return stringBuilder.append("\n\n").toString();
    }

    private Object getNavigableOppositeEnd(Object object) {
        Collection collection = Model.getFacade().getOtherAssociationEnds(object);
        Object var3_3 = null;
        if (collection.size() == 1) {
            Object e = collection.iterator().next();
            if (Model.getFacade().isNavigable(e)) {
                var3_3 = e;
            }
        }
        return var3_3;
    }

    private String generateAssociation(Object object) {
        LOG.debug((Object)"generateAssociation(Association modelElement)");
        if (!Model.getFacade().isAAssociation(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Association required");
        }
        String string = Model.getFacade().getName(object);
        if (string == null) {
            string = "";
        }
        return "// generateAssociation : " + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateAssociationEnd(Object object) {
        LOG.debug((Object)"generateAssociationEnd(AssociationEnd modelElement)");
        if (!Model.getFacade().isAAssociationEnd(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, AssociationEnd required");
        }
        StringBuffer stringBuffer = new StringBuffer();
        PHPDocumentor pHPDocumentor = null;
        try {
            pHPDocumentor = new PHPDocumentor(object);
        }
        catch (Exception exception) {
            LOG.error((Object)("Generating AssociationEnd DocBlock FAILED: " + exception.getMessage()));
        }
        finally {
            if (pHPDocumentor != null) {
                stringBuffer.append(pHPDocumentor.toString());
            }
        }
        String string = Model.getFacade().getName(object);
        if (string == null) {
            string = "";
        }
        return "// generateAssociationEnd : " + string;
    }

    private String generateMultiplicity(Object object) {
        LOG.debug((Object)"generateMultiplicity(Multiplicity modelElement)");
        if (!Model.getFacade().isAMultiplicity(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Multiplicity required");
        }
        return "// generateMultiplicity(Multiplicity modelElement)";
    }

    private String generateVisibility(Object object) {
        if (!Model.getFacade().isAVisibilityKind(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, VisibilityKind required");
        }
        if (this.iLanguageMajorVersion > 4) {
            if (Model.getVisibilityKind().getPublic().equals(object)) {
                return "public";
            }
            if (Model.getVisibilityKind().getProtected().equals(object)) {
                return "protected";
            }
            if (Model.getVisibilityKind().getPrivate().equals(object)) {
                return "private";
            }
        }
        return "";
    }

    private String generateFile(Object object, String string) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string2 = NameGenerator.generateFilename(object, string, this.iLanguageMajorVersion);
        if (string2 == null || string2.length() == 0) {
            LOG.error((Object)"Can't generate a nameless class");
            return null;
        }
        File file = new File(string2);
        if (file.exists()) {
            LOG.info((Object)(this.getName() + " updates " + file.getPath()));
            try {
                this.updateFile(object, file);
            }
            catch (Exception exception) {
                LOG.error((Object)("Update " + file.getPath() + " failed: " + exception.getMessage()));
                return null;
            }
            LOG.debug((Object)("Update " + file.getPath() + " successfull"));
            return string2;
        }
        LOG.info((Object)(this.getName() + " creates " + file.getPath()));
        File file2 = new File(string);
        if (!file2.isDirectory() && !file2.mkdirs()) {
            LOG.error((Object)(this.getName() + " could not make directory " + string));
            return null;
        }
        try {
            if (this.createFile(object, file)) {
                LOG.debug((Object)("Creating " + file.getPath() + " successfull"));
                return string2;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Creating " + file.getPath() + " failed"), (Throwable)exception);
            return null;
        }
        LOG.error((Object)("Creating " + file.getPath() + " failed"));
        return null;
    }

    private String getName() {
        return "PHP" + this.iLanguageMajorVersion;
    }

    protected final String convertType(Object object) {
        String string = Model.getFacade().getName(object).trim();
        if (string.equals("void")) {
            return null;
        }
        if (string.equals("char")) {
            return "string";
        }
        if (string.equals("boolean")) {
            return "bool";
        }
        if (string.equals("bool")) {
            return "bool";
        }
        if (string.equals("int")) {
            return "int";
        }
        if (string.equals("byte")) {
            return "int";
        }
        if (string.equals("short")) {
            return "int";
        }
        if (string.equals("long")) {
            return "int";
        }
        if (string.equals("float")) {
            return "float";
        }
        if (string.equals("double")) {
            return "float";
        }
        if (string.equals("string")) {
            return "string";
        }
        if (string.equals("array")) {
            return "array";
        }
        return null;
    }

    private final String generateDefaultValue(Object object, String string, boolean bl) {
        if (object == null) {
            return null;
        }
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string2 = this.convertType(object);
        if (string2 == null) {
            return "null";
        }
        if (string2.equals("string")) {
            String string3;
            String string4 = string3 = bl ? "(string) " : "";
            if (string != null) {
                int n = string.indexOf("'");
                while (n != -1) {
                    string = string.substring(0, n) + "\\" + string.substring(n);
                    n = string.indexOf("'", n + 2);
                }
                return string3 + "'" + string + "'";
            }
            return string3 + "''";
        }
        if (string2.equals("bool")) {
            String string5;
            String string6 = string5 = bl ? "(bool) " : "";
            if (string != null) {
                if ((string = string.trim()).length() > 0) {
                    if ("0".equals(string)) {
                        return string5 + "false";
                    }
                    if ("false".equals(string)) {
                        return string5 + "false";
                    }
                    return string5 + "true";
                }
                return string5 + "false";
            }
            return string5 + "false";
        }
        if (string2.equals("int")) {
            String string7;
            String string8 = string7 = bl ? "(int) " : "";
            if (string != null && string.trim().length() > 0) {
                return string7 + string.trim();
            }
            return string7 + String.valueOf(0);
        }
        if (string2.equals("float")) {
            String string9;
            String string10 = string9 = bl ? "(float) " : "";
            if (string != null && string.trim().length() > 0) {
                return string9 + string.trim();
            }
            return string9 + "0.0";
        }
        if (string2.equals("array")) {
            if (string != null && !"".equals(string.trim())) {
                return "array(" + string + ")";
            }
            return "array()";
        }
        return "null";
    }

    private String generateSection(Object object) {
        return this.generateSection(object, INDENT, null);
    }

    private String generateSection(Object object, String string, String string2) {
        String string3 = UUIDHelper.getUUID((Object)object);
        if (string2 != null && string2.trim() != "") {
            return Section.generate(string3 + "-" + string2.trim(), string);
        }
        return Section.generate(string3, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createFile(Object object, File file) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        LOG.info((Object)("    Generating new " + file.getPath()));
        String string = "<?php\n\n";
        string = string + "error_reporting(E_ALL);\n\n";
        PHPDocumentor pHPDocumentor = null;
        try {
            pHPDocumentor = new PHPDocumentor(object, 1);
        }
        catch (Exception exception) {
            LOG.error((Object)("Generating file DocBlock FAILED: " + exception.getMessage()));
        }
        finally {
            if (pHPDocumentor != null) {
                try {
                    pHPDocumentor.setFilename(NameGenerator.generateFilename(object, this.iLanguageMajorVersion));
                }
                catch (Exception exception) {
                    LOG.error((Object)("Setting filename for DocBlock FAILED: " + exception.getMessage()));
                }
                finally {
                    string = string + pHPDocumentor.toString() + "\n";
                }
            }
        }
        string = string + "if (0 > version_compare(PHP_VERSION, '" + this.iLanguageMajorVersion + "')) {\n";
        string = string + "    die('This file was generated for PHP " + this.iLanguageMajorVersion + "');\n" + "}\n\n";
        string = string + this.generateRequired(object);
        string = string + "/* user defined includes */\n";
        string = string + this.generateSection(object, "", "includes") + "\n";
        string = string + "/* user defined constants */\n";
        string = string + this.generateSection(object, "", "constants") + "\n";
        string = string + this.generateClassifier(object);
        string = string + "\n\n?>";
        boolean bl = true;
        BufferedWriter bufferedWriter = null;
        try {
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            return bl;
        }
        catch (IOException iOException) {
            LOG.error((Object)("    Catched IOException: " + iOException + ", for file " + file.getPath()));
            bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                LOG.error((Object)("    Catched IOException: " + iOException + ", for file " + file.getPath()));
                bl = false;
            }
        }
    }

    private void updateFile(Object object, File file) throws Exception {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        objSection = new Section();
        File file2 = new File(file.getAbsolutePath() + ".out");
        File file3 = new File(file.getAbsolutePath() + ".bak");
        LOG.debug((Object)("    Parsing sections from " + file.getPath()));
        objSection.read(file.getAbsolutePath());
        if (file3.exists()) {
            LOG.debug((Object)("    Delete (old) backup " + file3.getPath()));
            file3.delete();
        }
        LOG.debug((Object)("    Backup " + file.getPath() + " to " + file3.getPath()));
        file.renameTo(file3);
        if (this.createFile(object, file)) {
            LOG.debug((Object)("    Merging sections into " + file2.getPath()));
            objSection.write(file.getAbsolutePath(), INDENT, true);
            LOG.debug((Object)("    Renaming " + file2.getPath() + " to " + file.getPath()));
            file.delete();
            file2.renameTo(file);
        } else {
            if (file3.exists()) {
                LOG.debug((Object)("    Renaming (restore) " + file3.getPath() + " to " + file.getPath()));
                file3.renameTo(file);
            }
            LOG.error((Object)("    Updating " + file.getPath() + " failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateClassifierAttributes(Object object) {
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string = "";
        if (Model.getFacade().isAClass(object)) {
            string = string + "    // --- ATTRIBUTES ---\n";
            List list = Model.getFacade().getAttributes(object);
            if (list != null) {
                for (Object e : list) {
                    string = string + "\n";
                    PHPDocumentor pHPDocumentor = null;
                    try {
                        pHPDocumentor = new PHPDocumentor(e);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)("Generating attribute DocBlock FAILED: " + exception.getMessage()));
                    }
                    finally {
                        if (pHPDocumentor != null) {
                            string = string + pHPDocumentor.toString(INDENT);
                        }
                    }
                    string = string + INDENT + this.generateAttribute(e, false) + "\n";
                }
            }
            string = string + "\n";
        }
        return string;
    }

    private String generateClassifierGeneralisations(Object object) {
        Iterator iterator;
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string = "";
        Collection collection = Model.getFacade().getGeneralizations(object);
        if (collection != null && (iterator = collection.iterator()).hasNext()) {
            if (collection.size() == 1) {
                string = string + "    extends ";
            } else {
                string = string + "    /* multiple generalisations not supported by PHP: */\n";
                string = string + "    /* extends ";
            }
            while (iterator.hasNext()) {
                Object object2 = Model.getFacade().getGeneral(iterator.next());
                if (object2 == null) continue;
                string = string + NameGenerator.generate(object2, this.iLanguageMajorVersion);
                if (!iterator.hasNext()) continue;
                string = string + ",\n            ";
            }
            if (collection.size() > 1) {
                string = string + " */";
            }
            string = string + "\n";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateClassifierOperations(Object object) {
        Iterator iterator;
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string = "";
        string = string + "    // --- OPERATIONS ---\n";
        Object object2 = Model.getFacade().getTaggedValue(object, "constructor");
        if (object2 != null && (iterator = Model.getFacade().getValueOfTag(object2)) != null && ((String)((Object)iterator)).equals("true") && this.findConstructor(object) == null) {
            Object object3 = null;
            object3 = this.iLanguageMajorVersion < 5 ? "function " + NameGenerator.generate(object, this.iLanguageMajorVersion) : "public function __construct";
            string = string + "\n";
            string = string + "    /**\n";
            string = string + "     * Class constructor\n";
            string = string + "     *\n";
            string = string + "     * @access public\n";
            string = string + "     *\n";
            string = string + "     * @return void\n";
            string = string + "     *\n";
            string = string + "     * @author ArgoUML PHP Module (revised $Date: 2010-01-12 20:15:17 +0100 (Tue, 12 Jan 2010) $)\n";
            string = string + "     */\n";
            string = string + INDENT + object3 + "()\n";
            string = string + "    {\n";
            string = string + this.generateSection(object, INDENT, ((String)object3).substring(((String)object3).lastIndexOf(" ")));
            string = string + "    }\n";
        }
        if (Model.getFacade().isAClass(object)) {
            for (Object object3 : Model.getFacade().getSpecifications(object)) {
                for (Object e : Model.getFacade().getOperations(object3)) {
                    string = string + "\n";
                    PHPDocumentor pHPDocumentor = null;
                    try {
                        pHPDocumentor = new PHPDocumentor(e);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)("Generating operation DocBlock FAILED: " + exception.getMessage()));
                    }
                    finally {
                        if (pHPDocumentor != null) {
                            string = string + pHPDocumentor.toString(INDENT);
                        }
                    }
                    string = string + INDENT + this.generateOperation(e, false);
                    string = string + this.generateMethodBody(e, true);
                }
            }
        }
        for (Object object3 : Model.getFacade().getOperations(object)) {
            string = string + "\n";
            Object object4 = null;
            try {
                object4 = new PHPDocumentor(object3);
            }
            catch (Exception exception) {
                LOG.error((Object)("Generating operation DocBlock FAILED: " + exception.getMessage()));
            }
            finally {
                if (object4 != null) {
                    string = string + ((PHPDocumentor)object4).toString(INDENT);
                }
            }
            string = string + INDENT + this.generateOperation(object3, false);
            if (Model.getFacade().isAClass(object)) {
                string = string + this.generateMethodBody(object3, false);
                continue;
            }
            if (this.iLanguageMajorVersion < 5) {
                string = string + "\n    {\n";
                string = string + "        die('abstract method called');\n";
                string = string + "    }\n";
                continue;
            }
            string = string + ";\n";
        }
        return string;
    }

    private String generateClassifierSpecifications(Object object) {
        Collection collection;
        Iterator iterator;
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        String string = "";
        if (Model.getFacade().isAClass(object) && (iterator = (collection = Model.getFacade().getSpecifications(object)).iterator()).hasNext()) {
            if (this.iLanguageMajorVersion < 5) {
                string = string + "        /* specifications are not supported by PHP versions before 5.0 */\n";
            }
            string = string + "        ";
            if (this.iLanguageMajorVersion < 5) {
                string = string + "/* ";
            }
            string = string + "implements ";
            while (iterator.hasNext()) {
                Object e = iterator.next();
                string = string + NameGenerator.generate(e, this.iLanguageMajorVersion);
                if (!iterator.hasNext()) continue;
                string = string + ",\n                   ";
            }
            if (this.iLanguageMajorVersion < 5) {
                string = string + " */";
            }
            string = string + "\n";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateRequireOnceStatement(Object object, boolean bl) {
        Object object2;
        String string = "";
        if (bl) {
            object2 = null;
            try {
                object2 = new PHPDocumentor(object, 2);
            }
            catch (Exception exception) {
                LOG.error((Object)("Generating include DocBlock FAILED: " + exception.getMessage()));
            }
            finally {
                if (object2 != null) {
                    string = string + ((PHPDocumentor)object2).toString();
                }
            }
        }
        object2 = NameGenerator.generateFilename(object, this.iLanguageMajorVersion);
        if (FILE_SEPARATOR != "/") {
            int n = ((String)object2).indexOf(FILE_SEPARATOR);
            while (n != -1) {
                object2 = ((String)object2).substring(0, n) + "/" + ((String)object2).substring(n + 1);
                n = ((String)object2).indexOf(FILE_SEPARATOR, n + 1);
            }
        }
        string = string + "require_once('" + (String)object2 + "');\n";
        return string;
    }

    private String generateMethodBody(Object object, boolean bl) {
        if (!Model.getFacade().isAOperation(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Operation required");
        }
        String string = "";
        if (!Model.getFacade().isAbstract(object) || bl) {
            Object object22;
            string = string + "\n    {\n";
            Collection collection = Model.getFacade().getParameters(object);
            Object var5_5 = null;
            for (Object object22 : collection) {
                if (!Model.getFacade().isReturn(object22)) continue;
                if (var5_5 != null) {
                    throw new IllegalStateException("Found more than 1 return parameter in method " + Model.getFacade().getName(object));
                }
                var5_5 = object22;
            }
            Object object3 = null;
            object22 = null;
            if (var5_5 != null) {
                object3 = this.generateDefaultValue(Model.getFacade().getType(var5_5), null, true);
                object22 = this.generateParameter(var5_5);
            }
            if (object3 != null && ((String)object22).trim() != "") {
                string = string + "        $returnValue = " + (String)object3 + ";\n\n";
            }
            string = string + this.generateSection(object);
            if (object22 != null && object22 != "") {
                string = string + "\n        " + object22 + "\n";
            }
            string = string + "    }\n";
        } else if (this.iLanguageMajorVersion < 5) {
            string = string + "\n    {\n";
            string = string + "        die('abstract method called');\n";
            string = string + "    }\n";
        } else {
            string = string + ";\n";
        }
        return string;
    }

    private String generateRequired(Object object) {
        String string = "";
        if (!Model.getFacade().isAClassifier(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Classifier required");
        }
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                if (object != null) {
                    if (!Model.getFacade().isAClassifier(object)) {
                        throw new ClassCastException(object.getClass() + " is not comparable as classifier");
                    }
                    if (!Model.getFacade().isAClassifier(object2)) {
                        throw new ClassCastException(object2.getClass() + " is not comparable as classifier");
                    }
                    String string = NameGenerator.generateFilename(object, GeneratorPHP4.this.iLanguageMajorVersion);
                    if (string != null) {
                        return string.compareTo(NameGenerator.generateFilename(object2, GeneratorPHP4.this.iLanguageMajorVersion));
                    }
                    return NameGenerator.generateFilename(object2, GeneratorPHP4.this.iLanguageMajorVersion) != null ? -1 : 0;
                }
                if (object2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        for (Object object2 : Model.getFacade().getGeneralizations(object)) {
            treeSet.add(Model.getFacade().getGeneral(object2));
        }
        for (Object e : Model.getFacade().getAssociationEnds(object)) {
            Iterator iterator = this.getNavigableOppositeEnd(e);
            if (iterator == null) continue;
            treeSet.add(Model.getFacade().getType((Object)iterator));
        }
        for (Object e : Model.getFacade().getClientDependencies(object)) {
            for (Object e2 : Model.getFacade().getSuppliers(e)) {
                treeSet.add(e2);
            }
        }
        for (Object object2 : treeSet) {
            if (object2.equals(object)) continue;
            string = string + this.generateRequireOnceStatement(object2, true) + "\n";
        }
        return string;
    }

    private Object findConstructor(Object object) {
        if (!Model.getFacade().isAClass(object)) {
            throw new ClassCastException(object.getClass() + " has wrong object type, Class required");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection generate(Collection collection, boolean bl) {
        LOG.debug((Object)"generate() called");
        File file = null;
        try {
            file = TempFileUtils.createTempDir();
            if (file != null) {
                this.generateFiles(collection, file.getPath(), bl);
                Collection collection2 = TempFileUtils.readAllFiles((File)file);
                return collection2;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (file != null) {
                TempFileUtils.deleteDir((File)file);
            }
            LOG.debug((Object)"generate() terminated");
        }
    }

    public Collection<String> generateFiles(Collection collection, String string, boolean bl) {
        LOG.debug((Object)"generateFiles() called");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : collection) {
            String string2 = this.generateFile(e, string);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection generateFileList(Collection collection, boolean bl) {
        LOG.debug((Object)"generateFileList() called");
        File file = null;
        try {
            file = TempFileUtils.createTempDir();
            for (Object e : collection) {
                this.generateFile(e, file.getName());
            }
            Collection collection2 = TempFileUtils.readFileNames((File)file);
            return collection2;
        }
        finally {
            if (file != null) {
                TempFileUtils.deleteDir((File)file);
            }
        }
    }
}

