/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.core.propertypanels.ui.UmlControl;
import org.argouml.ui.targetmanager.TargetManager;

public class UMLComboBoxNavigator
extends UmlControl
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -4076669106516586439L;
    private static ImageIcon icon = ResourceLoaderWrapper.lookupIconResource((String)"ComboNav");
    private JComboBox theComboBox;
    private JButton theButton = new JButton(icon);

    public UMLComboBoxNavigator(String tooltip, UMLComboBox box) {
        super(new BorderLayout());
        List<Action> actions;
        this.theComboBox = box;
        this.theButton.setPreferredSize(new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 6));
        this.theButton.setToolTipText(tooltip);
        this.theButton.addActionListener(this);
        box.addActionListener(this);
        box.addItemListener(this);
        this.add((Component)this.theComboBox, "Center");
        this.add((Component)this.theButton, "East");
        ComboBoxModel model = box.getModel();
        if (model instanceof UMLComboBoxModel && !(actions = ((UMLComboBoxModel)model).getActions()).isEmpty()) {
            JPanel buttonPanel = this.createSingleButtonPanel(actions);
            this.add((Component)buttonPanel, "West");
        }
        Object item = this.theComboBox.getSelectedItem();
        this.setButtonEnabled(item);
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getMinimumSize().height);
    }

    public void actionPerformed(ActionEvent event) {
        Object item;
        if (event.getSource() == this.theButton && (item = this.theComboBox.getSelectedItem()) != null) {
            TargetManager.getInstance().setTarget(item);
        }
        if (event.getSource() == this.theComboBox) {
            item = this.theComboBox.getSelectedItem();
            this.setButtonEnabled(item);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.theComboBox) {
            Object item = this.theComboBox.getSelectedItem();
            this.setButtonEnabled(item);
        }
    }

    private void setButtonEnabled(Object item) {
        if (item != null) {
            this.theButton.setEnabled(true);
        } else {
            this.theButton.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        this.theComboBox.setEnabled(enabled);
        this.theComboBox.setEditable(enabled);
    }
}

