/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

class UMLAssociationRoleBaseComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = -7060017054488071743L;
    private Collection others = new ArrayList();

    public UMLAssociationRoleBaseComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected void buildModelList() {
        this.removeAllElements();
        Object ar = this.getTarget();
        Object base = Model.getFacade().getBase(ar);
        if (Model.getFacade().isAAssociationRole(ar)) {
            this.setElements(Model.getCollaborationsHelper().getAllPossibleBases(ar));
        }
        if (base != null) {
            this.addElement(base);
        }
    }

    protected Object getSelectedModelElement() {
        Object base;
        Object ar = this.getTarget();
        if (Model.getFacade().isAAssociationRole(ar) && (base = Model.getFacade().getBase(ar)) != null) {
            return base;
        }
        return null;
    }

    protected boolean isValidElement(Object element) {
        Object ar = this.getTarget();
        if (Model.getFacade().isAAssociationRole(ar)) {
            Object base = Model.getFacade().getBase(ar);
            if (element == base) {
                return true;
            }
            Collection b = Model.getCollaborationsHelper().getAllPossibleBases(ar);
            return b.contains(element);
        }
        return false;
    }

    protected void addOtherModelEventListeners(Object newTarget) {
        super.addOtherModelEventListeners(newTarget);
        Collection connections = Model.getFacade().getConnections(newTarget);
        ArrayList<Object> types = new ArrayList<Object>();
        for (Object e : connections) {
            types.add(Model.getFacade().getType(e));
        }
        for (Object e : types) {
            this.others.addAll(Model.getFacade().getBases(e));
        }
        for (Object e : this.others) {
            Model.getPump().addModelEventListener((PropertyChangeListener)this, e, "feature");
        }
    }

    protected void removeOtherModelEventListeners(Object oldTarget) {
        super.removeOtherModelEventListeners(oldTarget);
        for (Object classifier : this.others) {
            Model.getPump().removeModelEventListener((PropertyChangeListener)this, classifier, "feature");
        }
        this.others.clear();
    }

    public Action getAction() {
        return new ActionSetAssociationRoleBase();
    }

    private class ActionSetAssociationRoleBase
    extends UndoableAction {
        private static final long serialVersionUID = -3966106395848112765L;

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox source = (UMLComboBox)e.getSource();
            Object assoc = source.getSelectedItem();
            Object ar = source.getTarget();
            if (Model.getFacade().getBase(ar) == assoc) {
                return;
            }
            if (Model.getFacade().isAAssociation(assoc) && Model.getFacade().isAAssociationRole(ar)) {
                Model.getCollaborationsHelper().setBase(ar, assoc);
            }
        }
    }
}

