/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.model.UmlChangeEvent;
import org.argouml.ui.UndoableAction;

class UMLActivityGraphContextComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = 8957839123057771519L;

    public UMLActivityGraphContextComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, false);
    }

    protected void buildModelList() {
        ArrayList elements = new ArrayList();
        Project p = ProjectManager.getManager().getCurrentProject();
        for (Object model : p.getUserDefinedModelList()) {
            elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getClassifier()));
            elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getBehavioralFeature()));
            elements.addAll(Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getPackage()));
        }
        this.setElements(elements);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAClassifier(element) || Model.getFacade().isABehavioralFeature(element) || Model.getFacade().isAPackage(element);
    }

    protected Object getSelectedModelElement() {
        return Model.getFacade().getContext(this.getTarget());
    }

    public void modelChange(UmlChangeEvent evt) {
    }

    public Action getAction() {
        return new ActionSetContext();
    }

    private class ActionSetContext
    extends UndoableAction {
        private static final long serialVersionUID = -8118983979324112900L;

        protected ActionSetContext() {
            super(Translator.localize((String)"action.set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"action.set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox source = (UMLComboBox)e.getSource();
            Object target = source.getTarget();
            if (Model.getFacade().getContext(target) != source.getSelectedItem()) {
                Model.getStateMachinesHelper().setContext(target, source.getSelectedItem());
            }
        }
    }
}

